/**
 * @author Rajkumar.patidar
 * This js previously a form but now it changed to grid
 */
Ext.define('Academia.view.enquiry.dashboard.PendingEnquiryForm', {   
	extend : 'Ext.grid.Panel',
	alias : 'widget.pendingenquiryform',
	store:'enquiry.dashboard.PendingEnquiryFormGrid',
    autoScroll: false,
    frame: false,
    border:true,
    style:{'padding-top':'10px'},
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	columns : [{
				header : getEnquiryTranslation('DASHBOARD_ENQ_COUNT_CATEGORY'),
				dataIndex : 'key',
				flex : 4,
				sortable : true,
				renderer:function(val){
					if(val=='totalPendingEnquiry'){
						return getEnquiryTranslation('TOTAL_PENDING_ENQUIRIES');
					}else if(val=='pendingEnqMoreThanOneWeek'){
						return getEnquiryTranslation('ENQUIRIES_PENDING_FOR_MORE_THAN_ONE_WEAK');
					}else if(val=='pendingEnqMoreThanOneMonth'){
						return getEnquiryTranslation('ENQUIRIES_PENDING_FOR_MORE_THAN_ONE_MONTH');
					}
				}
			},{
				header : getEnquiryTranslation('COUNTS'),
				dataIndex : 'count',
				flex : 1,
				sortable : true,
				renderer:function(val){
					if(val>0){
						return '<a href=#>'+val+'</a>';						
					}else{
						return '0';
					}
				}
			}]
});