/**
 * @author Rohit Sharma
 */
Ext.define('Academia.view.eventlevelremark.EventLevelRemarkGrid', {
    extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias: 'widget.eventlevelremarkgrid',
    store: 'eventlevelremark.EventLevelRemarkGridStore',
    title: getMegaMenuTranslation('EVENT_LEVEL_REMARK_LIST'),
    border: true,
    refreshStoreData: true,
    isGridConfigurable: true,
    enableColumnHide: false,
    /*headerFix: {
        headerFix: true,
        portalIdsWithStructure: {
            'eventlevelremarktab': 1
        }
    },*/
    selModel: {
        mode: 'SINGLE'
    },
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
    dockedItems: [{
		xtype: 'toolbar',
		dock: 'bottom',
		itemId: 'dockedItemsItemId',
		items: [{
			xtype: 'custompagingtoolbar',
			plugins: ['pagesize'],
			store: 'eventlevelremark.EventLevelRemarkGridStore',
			emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo: true
		}]
	}],
    tbar: [{
        xtype: 'button',
        itemId: 'btnAdd',
        tooltip: getCommonTranslation('ADD'),
        glyph: ICONGLYPH.ADDGLYPH
    }, {
        xtype: 'button',
        itemId: 'btnEdit',
        tooltip: getCommonTranslation('EDIT'),
        glyph: ICONGLYPH.EDITGLYPH
    }, {
        xtype: 'button',
        itemId: 'btnView',
        tooltip: getCommonTranslation('VIEW'),
        iconCls: 'view-icon'
    }, {
        xtype: 'button',
        itemId: 'btnDelete',
        cls: 'CustomToolbarBtnReject',
        tooltip: getCommonTranslation('DELETE'),
        glyph: ICONGLYPH.DELETEGLYPH
    }, {
		xtype: 'button',
		itemId: 'applyToBtnId',
		text : getExaminationTranslation('APPLY_TO'),
		tooltip: getExaminationTranslation('APPLY_TO'),
		disabled: true
	}],
    initComponent: function () {
        var grid = this;
        grid.addExportToolBarItems(grid, true);
        this.callParent(arguments);
    },
    columns: [{
        header: getCommonTranslation('REMARK_CODE'),
        dataIndex: 'remarkCode',
        flex: 1
    }, {
        header: getCommonTranslation('REMARK_NAME'),
        dataIndex: 'remarkName',
        flex: 1
    }, {
        header: getCommonTranslation('STATUS'),
        dataIndex: 'status',
        flex: 1,
        renderer: function(value) {
			return statusRender(value);
		}
    }, {
        header: getCommonTranslation('MAPPED_AL'),
        dataIndex: 'totalMappedAcademyLocation',
        flex: 1,
        renderer: function(value,meta,record) {
        	if(!isNullOrEmpty(value) && value != 0) {
        		return '<a href="#">'+value+'</a>';
        	}
        	else if(!isNullOrEmpty(value) && value == 0) {
        		return value;
        	}
        	else {
        		return "-";
        	}                     
        }
    }]
});