Ext.define('Academia.view.examblock.ExamBlockFilter', {
    extend: 'Ext.form.FormPanel',
    alias: 'widget.examblockfilter',

    cls: 'customSearchPanel',
    frame: false,
    method: 'POST',
    standardSubmit: false,
    plugins: 'formlabelrequired',

    /**
     * 🔹 Shared listConfig helper
     */
    getListConfig: function (displayField) {
        return {
            loadingText: getCommonTranslation('SEARCHING'),
            emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
            minWidth: 226,
            getInnerTpl: function () {
                return '<div class="search-item">{' + displayField + '}</div>';
            },
            listeners: {
                expand: function (combo) {
                    var picker = combo.getPicker();
                    picker.setMinWidth(combo.getWidth());
                    picker.setMaxWidth(combo.getWidth());
                }
            }
        };
    },

    initComponent: function () {
        var me = this;

        Ext.apply(me, {
            items: [

                /** 🔹 Row 1 */
                {
                    xtype: 'fieldcontainer',
                    layout: 'hbox',
                    defaults: {
                        width: 226,
                        labelAlign: 'top',
                        margin: '0 10 0 0',
                        allowBlank: false
                    },
                    items: [{
                        xtype: 'customcombobox',
                        itemId: 'examBlockId',
                        name: 'examBlockId',
                        fieldLabel: getExaminationTranslation('EXAM_BLOCK_CODE_OR_NAME'),
                        store: 'assessmentSchedule.examCodeNameStore',
                        displayField: 'codeName',
                        valueField: 'id',
                        minChars: 2,
                        forceSelection: true,
                      //  listConfig: me.getListConfig('examBlockName'),
                        width: 460
                    }, {
                        xtype: 'customcombobox',
                        itemId: 'centreId',
                        name: 'centreId',
                        fieldLabel: getExaminationTranslation('CENTRE_NAME'),
                        store: 'assessmentSchedule.examBlockCenterStore',
                        displayField: 'examCenterName',
                        valueField: 'examCenterId',
                        allowBlank: true,
						disabled:true,
                        listConfig: me.getListConfig('centreName')
                    }]
                },

                /** 🔹 Row 2 */
                {
                    xtype: 'fieldcontainer',
                    layout: 'hbox',
                    defaults: {
                        width: 226,
                        labelAlign: 'top',
                        margin: '0 10 0 0'
                    },
                    items: [{
                        xtype: 'datefield',
                        itemId: 'fromDate',
                        name: 'fromDate',
                        fieldLabel: getCommonTranslation('FROM_DATE'),
                        format: 'd-m-Y',
                        submitFormat: 'Y-m-d'
                    }, {
                        xtype: 'datefield',
                        itemId: 'toDate',
                        name: 'toDate',
                        fieldLabel: getCommonTranslation('TO_DATE'),
                        format: 'd-m-Y',
                        submitFormat: 'Y-m-d'
                    }]
                },

                /** 🔹 Buttons */
                {
                    xtype: 'fieldcontainer',
                    cls: 'windowBtnPos',
                    layout: 'hbox',
                    items: [{
                        xtype: 'button',
                        text: getCommonTranslation('SEARCH'),
                        itemId: 'searchBtn',
                        ui: 'CustomBtnSubmit',
                        scale: CONSTANTS.BUTTONSIZE,
                        formBind: true
                    }, {
                        xtype: 'button',
                        text: getCommonTranslation('RESET'),
                        itemId: 'resetBtn',
                        ui: 'CustomBtnCancel',
                        scale: CONSTANTS.BUTTONSIZE
                    }]
                }
            ]
        });

        me.callParent(arguments);
    }
});
