
/**
 * @author
 * Manas
 */
var RegAssessmentGroupCoreStore = Ext.create('Academia.store.RegEGStores.RegAssessmentGroupCoreStore');

Ext.define('Academia.view.examexecution.RegAssessmentGroupCoreGrid', {
    extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias: 'widget.regassessmentgroupcoregrid',
    store: RegAssessmentGroupCoreStore,
    title: getExaminationTranslation('LIST_OF_REGISTER_FOR_ASSESSMENT_GROUP'),
    border: true,
    frame: false,
    selType: 'checkboxmodel',
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
    selModel: {
        mode: 'MULTI',
        showHeaderCheckbox: true,
        allowDeselect: false,
        checkOnly: true
    },
    isGridConfigurable: true,
    enableColumnHide: false,

    dockedItems: [{
        xtype: 'toolbar',
        dock: 'bottom',
        items: [{
            xtype: 'custompagingtoolbar',
            plugins: ['pagesize'],
            store: RegAssessmentGroupCoreStore,
            emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
            displayInfo: true
        }]
    }],

    initComponent: function() {
		
		this.addEvents(
			'coursecountclick' 
		);
		
        var grid = this;
        grid.addExportToolBarItems(grid, false);
        this.callParent(arguments);
    },
	
    tbar: [/*{
        xtype: 'button',
        itemId: 'btnAdd',
        tooltip: getCommonTranslation('ADD'),
        glyph: ICONGLYPH.ADDGLYPH
    },*/ {
        xtype: 'button',
        itemId: 'btnEdit',
        tooltip: getCommonTranslation('EDIT'),
        glyph: ICONGLYPH.EDITGLYPH
    }, {
        xtype: 'splitbutton',
        itemId: 'spBtnMoreActions',
        text: getCommonTranslation('MOREACTIONS'),
        menu: [{
            text: getExaminationTranslation('APPROVE'),
            itemId: 'approveItemId'
        }, {
            text: getExaminationTranslation('WITHDRAWN'),
            itemId: 'withdrawnItemId'
        }, {
            text: getExaminationTranslation('GENERATE_HALL_TKT'),
            itemId: 'hallTicketGenerationItemId'
        }, {
            text: getExaminationTranslation('PUBLISH_HALL_TICKET'),
            itemId: 'publishHallTicketItemId'
        }, {
            text: getExaminationTranslation('PRINT_HALL_TICKET'),
            itemId: 'printHallTicketItemId',
            hidden: true
        }, {
            text: getExaminationTranslation('NOTIFY'),
            itemId: 'notifyItemId',
            hidden: true
        }, {
            text: getExaminationTranslation('DOWNLOAD_APPLICATION'),
            itemId: 'downloadApplicationItemId',
            hidden: true
        }],
        listeners: { click: function() { this.showMenu(); } }
	}, {
		xtype: 'button',
		itemId: 'collectPaymentBtnId',
		tooltip: getExaminationTranslation('COLLECT_PAYMENT'),
		text: getExaminationTranslation('COLLECT_PAYMENT'),
		disabled: true
	},'->', {
        xtype: 'button',
        itemId: 'downloadHallTicketBtnId',
        tooltip: getExaminationTranslation('DOWNLOAD_HALL_TICKETS'),
        text: getExaminationTranslation('DOWNLOAD_HALL_TICKETS'),
        disabled: true
    }, {
        xtype: 'button',
        itemId: 'evalGroupExportReport',
        tooltip: getCommonTranslation('EXPORTREPORTS'),
        text: getCommonTranslation('EXPORTREPORTS'),
        disabled: true,
        hidden: true
    }, {
        xtype: 'button',
        itemId: 'downloadForm',
        tooltip: getExaminationTranslation('DOWNLOAD_FORM'),
        text: getExaminationTranslation('DOWNLOAD_FORM'),
        disabled: true
    }],

    columns: [{
        header: getCommonTranslation('ADMISSION_ID'),
        dataIndex: 'admissionCode',
        flex: .4,
        sortable: true
    }, {
        header: getCommonTranslation('STUDENT_CODE'),
        dataIndex: 'studentCode',
        flex: .4,
        sortable: true
    }, {
        header: getCommonTranslation('STUDENT_NAME'),
        dataIndex: 'studentName',
        flex: .4,
        sortable: true
    }, {
        header: getCommonTranslation('PROGRAM'),
        dataIndex: 'programName',
        flex: .3,
        sortable: true
    }, {
        header: getCommonTranslation('BATCH'),
        dataIndex: 'batchName',
        flex: .3,
        sortable: true
    }, {
        header: getCommonTranslation('PERIOD'),
        dataIndex: 'periodName',
        flex: .3,
        sortable: true
    }, {
        header: getCommonTranslation('EVALUATION_GROUP'),
        dataIndex: 'evaluationGroupCode',
        flex: .3,
        sortable: true
    }, {
        header: getCommonTranslation('AMOUNT'),
        dataIndex: 'newFeeAmount',
        flex: .3,
        sortable: true
    }, {
        header: getCommonTranslation('LATE_FEE'),
        dataIndex: 'lateFeeAmount',
        flex: .3,
        renderer: function(value, meta, record) {
            if (record.data.lateFeeAmount == 0.0) {
                return ' ';
            } else {
                return record.data.lateFeeAmount;
            }
        }
    }, {
        header: getCommonTranslation('TOTAL_AMOUNT'),
        dataIndex: 'totalAmount',
        flex: .3,
        sortable: true
    }, {
        header: getCommonTranslation('PAYMENT_MODE'),
        dataIndex: 'paymentMode',
        flex: .3,
        sortable: true,
        hidden: true
    }, {
        header: getCommonTranslation('APPLICATION_STATUS'),
        dataIndex: 'applicationStatus',
        flex: .3,
        sortable: true,
        renderer: function(value) {
            if (!isNullOrEmpty(value)) {
                return capitaliseEnumValue(value);
            } else {
                return '';
            }
        }
    }, {
        header: getCommonTranslation('HALL_TICKET_NO'),
        dataIndex: 'hallticket',
        flex: .3,
        sortable: true,
        renderer: function(value, meta, record) {
            if (value != null) {
                return '<a href=#>' + value + '</a>';
            }
        }
    }, {
        header: getCommonTranslation('HALL_TICKET_PUBLISH'),
        dataIndex: 'isPublishHallTicket',
        flex: .3,
        renderer: function(value, meta, record) {
            if (!isNullOrEmpty(record.data.financeHoldStatus) && (record.data.financeHoldStatus == "Hold")) {
                return '<span style=\'color:red\'>Hold for Student</span>';
            } else if (record.data.isPublishHallTicket) {
                return '<span>Published</span>';
            } else {
                return '<span style=\'color:red\'>Pending</span>';
            }
        }
    }, {
        header: getExaminationTranslation('CENTER_ALLOTED'),
        dataIndex: 'centerAllotted',
        flex: .3,
        sortable: true,
        renderer: function(value) {
            if (!isNullOrEmpty(value)) {
                return capitaliseEnumValue(value);
            } else {
                return '';
            }
        }
    }, {
        header: getExaminationTranslation('COURSE_COUNT'),
        dataIndex: 'totalCourse',
        flex: .4,
        sortable: true,
		renderer: function(value, meta, record) {
			if (value != null) {
				return '<a href=#>' + value + '</a>';
			}
		}
    }]
});
