/**
 * Grid for “Events Available for Student”
 */
Ext.define('Academia.view.examexecution.RegGroupApplyEventGrid', {
    extend: 'Ext.grid.Panel',
    alias: 'widget.reggroupapplyeventgrid',

    store: 'RegEGStores.ApplyCoursesGridStore',
    itemId: 'eventGrid',
    title: getMegaMenuTranslation('EVENT_AVAILABLE_FOR_STUDENT'),
	height: 360,
    border: false,
    frame: false,
    columnLines: true,
    selType: 'checkboxmodel',
    selModel: {
        mode: 'MULTI',
        showHeaderCheckbox: true,
        allowDeselect: false,
        checkOnly: true
    },

    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS,
        emptyText:getCommonTranslation('EMPTY_MESSAGE'),
        deferEmptyText: false,
		listeners: {
			        refresh: function(view) {
			            view.el.dom.style.overflowX = 'hidden';  // Remove Horizontal scoller
			        }
			    }
    },

    columns: [
        {
            text: 'Course Name',
            dataIndex: 'courseName',
            flex: 1,
            sortable: true
        },
        {
            text: 'Course Variant',
            dataIndex: 'courseVariantCode',
            flex: 1.2,
            sortable: true
        },
        {
            text: 'Period',
            dataIndex: 'periodName',
            flex: 1,
            sortable: true
        },
        {
            text: 'Section',
            dataIndex: 'sectionName',
            flex: 1,
            sortable: true
        },
        {
            text: 'Assessment Event',
            dataIndex: 'eventName',
            flex: 1.2,
            sortable: true
        }
    ]
});