/**
 * Application Details (Register for Assessment Group)
 */
Ext.define('Academia.view.examexecution.RegGroupApplyWindow', {
    extend: 'Ext.form.Panel',
    alias: 'widget.reggroupapplywindow',

    bodyPadding: 10,
    scrollable: true,
    layout: 'anchor',

    initComponent: function () {
        var me = this;
        function field(label, name, readOnly) {
            return {
                xtype: 'textfield',
                fieldLabel: label,
                name: name,
                labelAlign: 'top',
                width: 226,
                margin: '0 15 0 0',
				readOnly: readOnly === true ? true : true
				
            };
        }

        Ext.apply(me, {
            defaults: {
                anchor: '100%'
            },

            items: [

                /** -------------------------------
                 *  FORM SECTION
                 *  -------------------------------- */
                {
                    xtype: 'form',
                    itemId: 'applyDetailsForm',
                    border: false,
                    bodyPadding: 0,
                    layout: 'vbox',

                    defaults: {
                        xtype: 'container',
                        layout: 'hbox',
                        margin: '5 0 5 0'
                    },

                    items: [
                        // ===== Row 1 =====
                        {
                            items: [
                                field('Admission ID/Student Name', 'studentName', true),
                                field('Name', 'name', true),
                                field('Assessment Group Name', 'assessmentGroupName', true)
                            ]
                        },

                        // ===== Row 2 =====
                        {
                            items: [
                                field('Assessment Group Status', 'groupStatus', true),
                                field('Center Status', 'centerStatus', true),
                                field('Program', 'program', true)
                            ]
                        },

                        // ===== Row 3 =====
                        {
                            items: [
                                field('Batch', 'batch', true),
                                field('Application Status', 'applicationStatus', true),
                                field('Room Allocation Status', 'roomAllocationStatus', true)
                            ]
                        }
                    ]
                },

                /** -------------------------------
                 *  GRID SECTION
                 *  -------------------------------- */
                {
                    xtype: 'reggroupapplyeventgrid',
                    itemId: 'reggroupapplyeventgrid',
                    title: getMegaMenuTranslation('EVENT_AVAILABLE_FOR_STUDENT'),
                    margin: '10 0 0 0'
                },

                /** -------------------------------
                 *  BUTTON SECTION
                 *  -------------------------------- */
                {
                    xtype: 'fieldcontainer',
                    layout: 'hbox',
                    margin: '10 0 0 0',
                    items: [{
                        xtype: 'button',
                        itemId: 'submitBtn',
                        text: getCommonTranslation('SAVE'),
                        ui: 'CustomBtnSubmit',
                        scale: CONSTANTS.BUTTONSIZE,
                        formBind: true
                    }]
                }
            ]
        });

        me.callParent(arguments);
    }
});