/**

 * @author 
 * Vinay Kumrawat
 *
 */
Ext.define('Academia.view.examinationattendancerule.AttendanceRangeForm', {
	extend:'Academia.view.common.DynamicFieldForm',
	alias: 'widget.attendancerangeform',
	autoScroll:true,
	layout: 'vbox',
	method: 'POST',
	defaults : {
		labelAlign : 'top',
		width : 226
	},
	plugins : "formlabelrequired",
	items : [ {
		xtype : 'hidden',
		name : 'id'
	},{
		xtype : 'hidden',
		name : 'attendanceRuleId'
	}, {
		xtype : 'fieldcontainer',
		width : 'auto',
		defaults : {
			labelAlign : 'top',
			width : 226
		},
		layout : {
			type : 'hbox'
		},
		items : [{
			xtype : 'textfield',
			name : 'attendanceRuleName',
			itemId: 'attendanceRuleNameId',
			allowBlank : true,
			fieldLabel : getExaminationTranslation('ATTENDANCE_RULE_NAME'),
			readOnly: true
		},
		{
			xtype : 'numberfield',
			name : 'marks',
			itemId: 'marksId',
			allowDecimals: true,
			decimalPrecision: 2,
			minValue: 0,
			maxValue: 100,
			allowBlank : false,
			fieldLabel : getCommonTranslation('MARKS'),
			readOnly: false
		}]
	},{
		xtype : 'fieldcontainer',
		width : 'auto',
		defaults : {
			labelAlign : 'top',
			width : 226
		},
		layout : {
			type : 'hbox'
		},
		items : [{
			xtype : 'numberfield',
			name : 'rangeFrom',
			itemId: 'rangeFrom',
			allowBlank : false,
			fieldLabel : getExaminationTranslation('ATTENDANCE_RANGE_FROM'),
			allowDecimals: true,
			decimalPrecision: 2,
			minValue: 0,
			maxValue: 99.99
		},{
			xtype : 'numberfield',
			name : 'rangeTo',
			itemId: 'rangeTo',
			allowBlank : false,
			fieldLabel : getExaminationTranslation('ATTENDANCE_RANGE_TO'),
			allowDecimals: true,
			decimalPrecision: 2,
			minValue: 0.01,
			maxValue: 100
		}]
	}, {
		xtype : 'fieldcontainer',
		width : '100%',
		cls : 'windowBtnPos',
		items : [ {
			xtype : 'button',
			text : getCommonTranslation('SAVE'),
			itemId : 'attendanceRangeSubmitBtn',
			ui : 'CustomBtnSubmit',
			scale : CONSTANTS.BUTTONSIZE,
			formBind : true
		}, {
			xtype : 'button',
			itemId : 'attendanceRangeCancelBtn',
			text : getCommonTranslation('CANCEL'),
			ui : 'CustomBtnCancel',
			scale : CONSTANTS.BUTTONSIZE
		} ]
	} ]
});