/**
 * @Author Vinay Kumrawat
 */

Ext.define('Academia.view.examinationattendancerule.AttendanceRuleApplyToStructure', { 
	extend : 'Ext.panel.Panel',
	alias : 'widget.attendanceruleapplytostructure',
	autoScroll:false,  
	plain: true,
    items : [
		{ 
			xtype:'grid',
			border:true,
			autoScroll:true,
			store:'attendancerulestores.AttendanceRuleProgramAssociatedGridStore',
		    title: getCommonTranslation('SEARCHRESULTSGRIDHEADER'),
		    autoScroll: true,
		    viewConfig: {
		        stripeRows: CONSTANTS.STRIPEROWS
		    },
		    tbar: [{
		        xtype: 'button',
		        itemId: 'btnAdd',
		        tooltip: getCommonTranslation('ADD'),
		        iconCls:'icon-addbutton',
				cls:'addbutton'
		    }, {
		        xtype: 'button',
		        itemId: 'btnView',
		        tooltip: getCommonTranslation('VIEW'),
		        iconCls: 'icon-View',
				cls:'iconView',
		        disabled: true
		    }, {
		        xtype: 'button',
		        itemId: 'btnDelete',
		        cls: 'CustomToolbarBtnReject',
		        tooltip: getCommonTranslation('DELETE'),
		        iconCls: 'icon-Delete',
				cls:'iconDelete',
		        disabled: true
		    }],
			columns:[{
				header:getCommonTranslation('ACADEMY_LOCATION'),
				dataIndex:'academyLocationName',
				flex:1
			},{
				header:getCommonTranslation('PROGRAM'),
				dataIndex:'programName',
				flex:1
			},{
				header:getCommonTranslation('BATCH'),
				dataIndex:'batchName',
				flex:1
			}],	
			dockedItems: [{  
                xtype: 'toolbar',
                dock: 'bottom',
                items: [{
                    xtype: 'custompagingtoolbar',
                    plugins: ['pagesize'],
                    store: 'attendancerulestores.AttendanceRuleProgramAssociatedGridStore',
                    emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
                    displayInfo: true
                }]
            }] 
		}
	] 
});	