/**
 * @author Rohit Sharma
 */
Ext.define('Academia.view.examinationcenters.assessmentEvent.ExamConcessionStaffAllocationGrid', {
    extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias: 'widget.examConcessionStaffAllocationGrid',
    store: 'exam.examConcessionStaffAllocation.ExamConcessionStaffAllocationGridStore',
    border: true,
    frame: false,
    title: getExaminationTranslation('EXAM_CONCESSION_STAFF_ALLOCATION_GRID'),
    selType: 'checkboxmodel',
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
    selModel: {
        multiSelect: true,
        mode: 'SIMPLE',
        checkOnly: false
    },
    dockedItems: [{
        xtype: 'toolbar',
        dock: 'bottom',
        items: [{
            xtype: 'custompagingtoolbar',
            plugins: ['pagesize'],
            store: 'exam.examConcessionStaffAllocation.ExamConcessionStaffAllocationGridStore',
            emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
            displayInfo: true
        }]
    }],
     isGridConfigurable: true,
    enableColumnHide: false,  
    initComponent: function () {
        var grid = this;
        grid.addExportToolBarItems(grid);
        this.callParent(arguments);
    },
    tbar: [{
        xtype: 'button',
        itemId: 'deleteBtnId',
        text: getExaminationTranslation('DELETE'),
        disabled: true
    }, {
        xtype: 'button',
        itemId: 'publishBtnId',
        text: getExaminationTranslation('PUBLISH_TIMETABLE'),
        disabled: true
    }],
    columns: [{
        header: getCommonTranslation('SU_NUMBER'),
        dataIndex: 'externalSysRefOne',
        flex: .1,
        sortable: true,
        hidden: true
    }, {
        header: getCommonTranslation('STUDENT_ID'),
        dataIndex: 'studentCode',
        flex: .1,
        sortable: true
    }, {
        header: getCommonTranslation('STUDENT_NAME'),
        dataIndex: 'studentName',
        flex: .1,
        sortable: true
    }, {
        header: getCommonTranslation('REQUEST_CATEGORY'),
        dataIndex: 'requestType',
        flex: .1,
        sortable: true,
        renderer: function (value, metaData, record) {
        	return 'Exam Consession';
        }
    }, {
        header: getCommonTranslation('REQUEST_TYPE'),
        dataIndex: 'requestType',
        flex: .1,
        sortable: true
    }, {
        header: getCommonTranslation('COURSE_CODE_NAME'),
        dataIndex: 'courseName',
        flex: .1,
        sortable: true
    }, {
        header: getCommonTranslation('DETAILED_SEQUENCE'),
        dataIndex: 'eventName',
        flex: .1,
        sortable: true
    }, {
        header: getCommonTranslation('DATE'),
        dataIndex: 'printDate',
        flex: .1,
        sortable: true
    }, {
        header: getCommonTranslation('TIME'),
        dataIndex: 'time',
        flex: .1,
        sortable: true
    }, {
        header: getCommonTranslation('COURSE_ENROLLMENT_COUNT'),
        dataIndex: 'courseEnrolmentCount',
        flex: .1,
        sortable: true
    }, {
        header: getCommonTranslation('EVENT_MAPPED_STUDENT'),
        dataIndex: 'eventMappedStudent',
        flex: .1,
        sortable: true
    }, {
        header: getCommonTranslation('BUILDING'),
        dataIndex: 'buildingName',
        flex: .1,
        sortable: true
    }, {
        header: getCommonTranslation('ROOM'),
        dataIndex: 'resourceNameRoom',
        flex: .1,
        sortable: true
    }, {
        header: getCommonTranslation('ROOM_CAPACITY'),
        dataIndex: 'roomCapacity',
        flex: .1,
        sortable: true
    }, {
        header: getCommonTranslation('PRIMARY_INVIGILATOR'),
        dataIndex: 'firstInvigilatorFirstName',
        flex: .1,
        sortable: true,
        renderer: function (value, metaData, record) {
			if(value == null) {
				return "";
			}
        	return value + ' ' + record.get('firstInvigilatorLastName');
        }
    }, {
        header: getCommonTranslation('SECONDARY_INVIGILATOR'),
        dataIndex: 'secondInivigilatorFirstName',
        flex: .1,
        sortable: true,
        renderer: function (value, metaData, record) {
			if(value == null) {
				return "";
			}
        	return value + ' ' + record.get('secondInivigilatorLastName');
        }
    }, {
        header: getCommonTranslation('INVIGILATOR_3'),
        dataIndex: 'thirdInivigilatorFirstName',
        flex: .1,
        sortable: true,
        renderer: function (value, metaData, record) {
			if(value == null) {
				return "";
			}
        	return value + ' ' + record.get('thirdInivigilatorLastName');
        }
    }, {
        header: getCommonTranslation('INVIGILATOR_4'),
        dataIndex: 'fourthInivigilatorFirstName',
        flex: .1,
        sortable: true,
        renderer: function (value, metaData, record) {
			if(value == null) {
				return "";
			}
        	return value + ' ' + record.get('fourthInivigilatorLastName');
        }
    }, {
        header: getCommonTranslation('PUBLISH_STATUS'),
        dataIndex: 'publishStatus',
        flex: .1,
        sortable: true,
        renderer: function (value, metaData, record) {
        	if(value) {
        		return getExaminationTranslation('PUBLISHED');
        	}
        	else {
        		return getExaminationTranslation('NOT_PUBLISHED');
        	}
        }
    }/*, {
        header: getExaminationTranslation('REMAINING_ROOM_CAPACITY'),
        dataIndex: 'academicTermName',
        flex: .1,
        sortable: true
    }*/]
});