/**
 * @author sumit.meena
 */
Ext.define('Academia.view.examinationcenters.calculateResults.CalculateResultFilter', {
	//extend: 'Ext.form.Panel',
	extend: 'Academia.view.common.DynamicFieldForm',
    alias: 'widget.calculateresultfilter',
    autoScroll: false,
    frame: false,
	cls:'customSearchPanel',
    plugins : "formlabelrequired",
    standardSubmit : false,
    modal: true,
    items: [{
	        xtype: 'fieldcontainer',
	    	layout: 'hbox',
	    	defaults: {
	    		labelAlign: 'top'
	    	},
	        	items: [{
					xtype: 'customcombobox',
					name:'programId',
					itemId:'programItemId',
					store:Ext.create('Academia.store.examinationcenters.reports.ExaminationRecResultProgramStore'),
					fieldLabel:getCommonTranslation('PROGRAM_CODE_OR_NAME'),
					valueField: 'id',
					displayField: 'code',
					queryParam:'name',
					minChars:3,
					width:226,
					typeAhead:false,
					allowBlank:false,
					triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
					enableKeyEvents  : 'true',
					hideTrigger:false,
					forceSelection:true,
					emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
					listConfig: {
						listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
							}
						},
						loadingText: getCommonTranslation('SEARCHING'),
						emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
						getInnerTpl: function() {
							return '<div class="search-item">' +
							'{value}' +
							'</div>';
						}
					}
				},{
					xtype: 'customcombobox',
					name:'batchId',
					itemId:'batchItemId',
					store:'examinationcenters.reports.ExaminationResultBatchStore',
					fieldLabel:getExaminationTranslation('BATCH'),
					valueField: 'id',
					displayField: 'value',
					queryParam:'batchName',
					minChars:3,
					width:226,
					disabled:true,
					typeAhead:false,
					triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
					enableKeyEvents  : 'true',
					hideTrigger:false,
					forceSelection:true,
					emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
					listConfig: {
						listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
							}
						},
						loadingText: getCommonTranslation('SEARCHING'),
						emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
						getInnerTpl: function() {
							return '<div class="search-item">' +
							'{value}' +
							'</div>';
						}
					}
				},{
    				xtype: 'customcombobox',
    				name: 'periodId',
    				itemId: 'periodItemId',
    				store:'examinationcenters.reports.ExaminationResultPeriodStore',
    				fieldLabel:getExaminationTranslation('PERIOD'),
    				valueField: 'id',
    				displayField: 'value',
    				disabled:true,
    				queryParam:'name',
    				minChars:3,
    				width:240,
    				typeAhead:false,
    				triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
    				enableKeyEvents  : 'true',
    				hideTrigger:false,
    				forceSelection:true,
    				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
    				listConfig: {
    					listeners: {
    						beforeshow: function(picker) {
    							picker.minWidth = picker.up('combobox').getSize().width;
    						}
    					},
    					loadingText: getCommonTranslation('SEARCHING'),
    					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    					getInnerTpl: function() {
    						return '<div class="search-item">' +
    						'{value}' +
    						'</div>';
    					}
    				}
    			}]
	   },{
	        xtype: 'fieldcontainer',
        	layout: 'hbox',
        	defaults: {
        		width: 226,
        		labelAlign: 'top'
        	},
            	items: [{
    				xtype: 'customcombobox',
    				name: 'evaluationPlanId',
    				itemId: 'evaluationPlanItemId',
    				store:'examinationcenters.reports.ExaminationPlanStore',
    				fieldLabel:getExaminationTranslation('EVALUATION_PLAN'),
    				valueField: 'id',
    				displayField: 'valueCode',
    				queryParam:'name',
    				minChars:3,
    				width:226,
//    				disabled:true,
    				typeAhead:false,
    				triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
    				enableKeyEvents  : 'true',
    				hideTrigger:false,
    				forceSelection:true,
    				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
    				listConfig: {
    					listeners: {
    						beforeshow: function(picker) {
    							picker.minWidth = picker.up('combobox').getSize().width;
    						}
    					},
    					loadingText: getCommonTranslation('SEARCHING'),
    					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    					getInnerTpl: function() {
    						return '<div class="search-item">' +
    						'{valueCode}' +
    						'</div>';
    					}
    				}
    			},{
    				xtype: 'customcombobox',
    				name: 'courseId',
    				itemId: 'courseItemId',
    				// store:'examinationcenters.reports.ExaminationReportCourseStore',
					store:'examinationcenters.reports.ExaminationReportCourseUpdatedStore', //V2D-516565
    				fieldLabel:getCommonTranslation('COURSE_CODE_NAME'),
    				valueField: 'id',
    				displayField: 'value',
    				queryParam:'name',
    				minChars:3,
    				width:226,
    				typeAhead:false,
    				triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
    				enableKeyEvents  : 'true',
    				hideTrigger:false,
    				disabled:true,
    				forceSelection:true,
    				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
    				listConfig: {
    					listeners: {
    						beforeshow: function(picker) {
    							picker.minWidth = picker.up('combobox').getSize().width;
								picker.maxWidth = picker.up('combobox').getSize().width;
    						}
    					},
    					loadingText: getCommonTranslation('SEARCHING'),
    					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    					getInnerTpl: function() {
    						return '<div class="search-item">' +
    						'{value}' +
    						'</div>';
    					}
    				}
    			},{
    	        	xtype: 'customcombobox',
    	            name: 'courseVariant',
    	            itemId:'courseVariantItemId',
    	            store:'attendance.CourseVariantFromCourseLevel',
    	            displayField:'value',
    	            valueField:'id',
    	            width:240,
    	            maxLength:9999,
    	  			maxSelections :9999,
    	            forceSelection:true,
    	            typeAhead:true,
    	            editable:false,
    	            fieldLabel:getExaminationTranslation('COURSE_VARIANT'),
    	            disabled:true,  
    	        	listConfig: {
    					listeners: {
    						beforeshow: function(picker) {
    							picker.minWidth = picker.up('combobox').getSize().width;
								picker.maxWidth = picker.up('combobox').getSize().width; 
								
    						}
    					},
    	        	}
    			}]
        },{
	        xtype: 'fieldcontainer',
        	layout: 'hbox',
        	defaults: {
        		width: 226,
        		labelAlign: 'top'
        	},
            	items: [{
            		xtype: 'multiselectcombofield',
            		name: 'sectionsId',
            		itemId: 'sectionsItemId',
            		store : 'examinationcenters.reports.ExaminationReportSectionStore',
            		displayField:'value',
            		valueField:'id',
            		forceSelection:true,
            		cls:'placementProgramMultiselect',
            		fieldLabel:getExaminationTranslation('SECTION'),
            		width: 460,
            		autoloadStore: false,
            		disabled:true
            	},{
    				xtype: 'customcombobox',
    				name: 'studentId',
    				itemId: 'studentItemId',
    				store:'examinationcenters.reports.ExaminationReportStudentStore',
    				fieldLabel:getExaminationTranslation('ADMISSION_CODE_STD_NAME_STD_CODE'),
    				valueField: 'id',
    				displayField: 'valueCode',
    				queryParam:'name',
    				minChars:3,
    				width:240,
    				typeAhead:false,
    				triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
    				enableKeyEvents  : 'true',
    				hideTrigger:false,
    				forceSelection:true,
    				disabled:true,
    				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
    				listConfig: {
    					listeners: {
    						beforeshow: function(picker) {
    							picker.minWidth = picker.up('combobox').getSize().width;
    						}
    					},
    					loadingText: getCommonTranslation('SEARCHING'),
    					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    					getInnerTpl: function() {
    						return '<div class="search-item">' +
    						'{valueCode}' +
    						'</div>';
    					}
    				}
    			}] 
	    },{
	        xtype: 'fieldcontainer',
        	layout: 'hbox',
        	defaults: {
        		width: 226,
        		labelAlign: 'top'
        	},
            	items: [{
            		xtype: 'customcombobox',  
            		name: 'calculationPriority',
            		itemId: 'calculationPriority',
            		store : 'examinationcenters.reports.CalculationProrityStore',  
            		displayField:'value',
            		valueField:'id',
            		forceSelection:true, 
            		cls:'placementProgramMultiselect',
            		fieldLabel:getExaminationTranslation('CALCULATION_PRIORITY'),
            		width: 230,  
            		autoloadStore: false,
            		disabled:false,
					value: 'Medium'
            	}]
	    },{
			xtype: 'fieldcontainer',
			width: 'auto',
			items: [{
				xtype: 'button',
				text: getExaminationTranslation('CALCULATE_RESULT'),
				itemId: 'submitBtn',
				buttonAlign: 'left',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE,
				formBind:true
			},{
				xtype: 'button',
				text: getCommonTranslation('RESET'),
				itemId: 'resetBtn',
				ui: 'CustomBtnCancel',
				scale: CONSTANTS.BUTTONSIZE   
			}]	
	 }]
});
