/**
 * sumit.meena
 */
Ext.define('Academia.view.examinationcenters.dashboard.ProgramWiseDashboardGrid', {
   // extend: 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias: 'widget.programwisedashboardgrid',
    store: 'examinationcenters.dashboard.ProgramWiseDashboard',
    title:getExaminationTranslation('PROGRAM_WISE'),
    border: true,
    frame:false,
    viewConfig: {
        stripeRows: true
    },
    dockedItems: [{
        xtype: 'toolbar',
        dock: 'bottom',
        items: [{
        	xtype: 'custompagingtoolbar',
            plugins:['pagesize'],
            store : 'examinationcenters.dashboard.ProgramWiseDashboard',
		    emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
		    displayInfo : true
        }]
    }],
    initComponent: function() {
        var grid=this;                   
        grid.addExportToolBarItems(grid);
        this.callParent(arguments);     
 },
    columns: [{
        header: getExaminationTranslation('PROGRAM'),
        dataIndex: 'programName',
        flex:.1,
        sortable:true
    },{
        header: getExaminationTranslation('COURSE'),
        dataIndex: 'courseCode',
        flex:.1,
        sortable:true
    },{
        header: getExaminationTranslation('BATCH'),
        dataIndex: 'batchName',
        flex:.1,
        sortable: true
    },{
        header: getExaminationTranslation('ADMISSION_ID'),
        dataIndex: 'admissionCode',
        flex:.1,
        sortable: true
    },{
        header: getExaminationTranslation('STUDENT_ID'),
        dataIndex: 'studentCode',
        flex:.1,
        sortable: true
    },{
        header: getExaminationTranslation('STUDENT_NAME'),
        dataIndex: 'studentName',
        flex:.1,
        sortable: true
    },{
        header: getExaminationTranslation('RANK'),
        dataIndex: 'rank',
        flex:.1,
        sortable: true
    },{
        header: getExaminationTranslation('MARK_GRADE'),
        dataIndex: 'obtainedMarks',
        flex:.1,
        sortable: true,
        renderer:function(value,rec){
        	var data=rec.record.data;
        	if(!isNullOrEmpty(data.obtainedMarks)){
        		return data.obtainedMarks;
        	}else if(!isNullOrEmpty(data.gradePoint)){
        		return data.gradePoint;
        	}
        }
    },{
        header: getExaminationTranslation('MARK_OBTAINED_FROM'),
        dataIndex: 'marksObtainedFrom',
        flex:.1,
        sortable: true
   /* },{
        header: getExaminationTranslation('GRADE_POINT'),
        dataIndex: 'gradePoint',
        flex:.1,
        sortable: true*/
    },{
        header: getExaminationTranslation('GRADE'),
        dataIndex: 'grade',
        flex:.1,
        sortable: true
    }]
});