/**
 * sumit.meena
 */
Ext.define('Academia.view.examinationcenters.evaluationgroup.CourseCoveredGridWin', {
    extend: 'Ext.window.Window',
    alias: 'widget.coursecoveredgridwin',
    modal: true,
    autoScroll:false,
    title: getExaminationTranslation('DETAILED_SEQUENCE_COVERED'),
    width: '70%',
    maxHeight:'33%',
    items: [{
        xtype: 'grid',
        autoScroll:true,
        frame:false,
        border:true,
        store:'examinationcenters.evaluationgroup.EvalGroupCourseCovered',
        height:193,
         viewConfig: {
             stripeRows: CONSTANTS.STRIPEROWS
         },
         columns: [{
             header: getExaminationTranslation('PERIOD'),
             dataIndex: 'periodName',
             flex:.1,
             sortable:true
         },{
             header: getExaminationTranslation('SECTION'),
             dataIndex: 'sectionName',
             flex:.1,
             sortable:true
         },{
             header: getExaminationTranslation('COURSE_NAME'),
             dataIndex: 'courseName',
             flex:.1,
             sortable:true
         }, {
             header: getExaminationTranslation('COURSE_VARIANT'),
             dataIndex: 'courseVariantName',
             flex:.1,
             sortable:true
         }, {
             header: getExaminationTranslation('EVALUATION_PLAN'),
             dataIndex: 'evaluationPlanNumber',
             flex:.1,
             sortable: true
         }, {
             header: getExaminationTranslation('EVAL_DETAILED_SEQ'),
             dataIndex: 'detailSequenceNumber',
             flex:.1,
             sortable: true
         }, {
             header: getExaminationTranslation('CENTER'),
             dataIndex: 'center',
             flex:.1,
             sortable: true,
             renderer:function(value,meta,record){
     			if(!isNullOrEmpty(value)) {
     				 return value;
     			}  else {
     					 return record.data.internalCenter;
     			}                     
     		}
         }, {
             header: getExaminationTranslation('PLANNED_DATE'),
             dataIndex: 'examdateFrom',
             flex:.1,
             sortable: true,
     		 renderer:function(date) {
    			return dateRender(date);
    		 }
         }]
    }]
});