Ext.define('Academia.view.examinationcenters.evaluationgrouplisting.ResgisterForGroupFilter', {
    extend: 'Ext.form.FormPanel',
    alias: 'widget.resgisterforgroupfilter',

    cls: 'customSearchPanel',
    frame: false,
    method: 'POST',
    standardSubmit: false,
    plugins: 'formlabelrequired',

    /**
     * 🔹 Shared listConfig helper (SAFE)
     */
    getListConfig: function (displayField) {
        return {
            loadingText: getCommonTranslation('SEARCHING'),
            emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
            minWidth: 226,
            getInnerTpl: function () {
                return '<div class="search-item">{' + displayField + '}</div>';
            },
			listeners: {
				expand: function (combo) {
				        var picker = combo.getPicker();
				        picker.setMinWidth(combo.getWidth());
				        picker.setMaxWidth(combo.getWidth());
				    }
			}
        };
    },

    initComponent: function () {
        var me = this;

        Ext.apply(me, {
            items: [

                /** 🔹 Row 1 */
                {
                    xtype: 'fieldcontainer',
                    layout: 'hbox',
                    defaults: {
                        width: 226,
                        labelAlign: 'top',
                        margin: '0 10 0 0',
                        allowBlank: false
                    },
                    items: [{
                        xtype: 'customcombobox',
                        itemId: 'programItemId',
                        name: 'programId',
                        fieldLabel: getCommonTranslation('PROGRAM_CODE_OR_NAME'),
                        store: 'RegEGStores.RegEGProgramStore',
                        displayField: 'programName',
                        valueField: 'programId',
                        minChars: 2,
                        forceSelection: true,
                        listConfig: me.getListConfig('programName'),
                        width: 460
                    }, {
                        xtype: 'customcombobox',
                        itemId: 'batchIdItemId',
                        name: 'batchId',
                        fieldLabel: getExaminationTranslation('BATCH'),
                        store: 'RegEGStores.RegEGBatchStore',
                        displayField: 'batchName',
                        valueField: 'batchId',
                        disabled: true,
						forceSelection: true,
                        listConfig: me.getListConfig('batchName')
                    }]
                },

                /** 🔹 Row 2 */
                {
                    xtype: 'fieldcontainer',
                    layout: 'hbox',
                    defaults: {
                        width: 226,
                        labelAlign: 'top',
                        margin: '0 10 0 0'
                    },
                    items: [{
                        xtype: 'customcombobox',
                        itemId: 'periodId',
                        name: 'periodId',
                        fieldLabel: getExaminationTranslation('PERIOD'),
                        store: 'RegEGStores.RegEGPeriodStore',
                        displayField: 'periodName',
                        valueField: 'periodId',
                        disabled: true,
						forceSelection: true,
                        listConfig: me.getListConfig('periodName')
                    }, {
                        xtype: 'customcombobox',
                        itemId: 'evalGroupId',
                        name: 'evalGroupId',
                        fieldLabel: getExaminationTranslation('EVALUATION_GROUP'),
                        store: 'RegEGStores.RegEGCourseStore',
                        displayField: 'evaluationGroupCode',
                        valueField: 'evaluationGroupId',
                        minChars: 2,
                        allowBlank: true,
						forceSelection: true,
                        listConfig: me.getListConfig('evaluationGroupCode')
                    }]
                },

                /** 🔹 Buttons */
                {
                    xtype: 'fieldcontainer',
                    cls: 'windowBtnPos',
                    layout: 'hbox',
                    items: [{
                        xtype: 'button',
                        text: getCommonTranslation('SEARCH'),
                        itemId: 'searchBtn',
                        ui: 'CustomBtnSubmit',
                        scale: CONSTANTS.BUTTONSIZE,
                        formBind: true
                    }, {
                        xtype: 'button',
                        text: getCommonTranslation('RESET'),
                        itemId: 'resetBtn',
                        ui: 'CustomBtnCancel',
                        scale: CONSTANTS.BUTTONSIZE
                    }]
                }
            ]
        });

        me.callParent(arguments); 
    }
}); 