/**
 * @author sumit.meena
 */
var evaluationPlanGridStore = Ext.create('Academia.store.examinationcenters.evaluation.coverageDetails.CourseCoverageStore');
Ext.define('Academia.view.examinationcenters.evaluationplanstatus.PlanFieldCountDetailWin',{
	extend: 'Ext.window.Window',
	alias: 'widget.planfieldcountdetailwin',
	title:getExaminationTranslation('FIELD_DETAILS'),
	frame: true,
	autoScroll:true,
	modal:true,
	id:'countWinItemId',
	method: 'POST',
	overflowY: 'auto',
	overflowX: 'hidden',
	maxHeight: window.innerHeight - 20,
	width: 880,
	layout: 'fit',
	items: [{
			 xtype: 'grid',
		     //autoScroll:true,
		     name:'courseGrid',
		     itemId:'courseGridItemId',
		     frame:false,
		     border:true,
		     viewConfig: {
		 		stripeRows: CONSTANTS.STRIPEROWS
		 	},
		     store: 'examinationcenters.evaluation.coverageDetails.EvaluationPlanCourseStore',
	         hideHeaders :false,
	         //width: '96%',
//	     	 height:'60%',
	         style:{
	        	marginBottom:'5px',
	         },
	         selModel: {
	        	 checkOnly : true, 
	        	 allowDeselect: false
	         },
	         dockedItems: [{
	     		xtype : 'toolbar',
	     		dock : 'bottom',
	     		items : [ {
	     			xtype : 'custompagingtoolbar',
	     			plugins:['pagesize'],
	     			store : 'examinationcenters.evaluation.coverageDetails.EvaluationPlanCourseStore',
	     			emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
	     			displayInfo : true
	     		} ]
	     	}],
	         columns: [{
		        header: getExaminationTranslation('COURSE_NAME'),
		        dataIndex: 'courseName',
		        flex: 2,
		        sortable: true,
		        renderer:function(value,meta,record){
					if(!isNullOrEmpty(value)) {
							return record.data.courseCode+"-"+record.data.courseName; 
					}                        
				} 
		    }, {
		         header: getExaminationTranslation('MARKING_TYPE'),
		         dataIndex: 'markingType',
		         flex: 1,
		          sortable: true,
		          renderer:function(value,meta,record){
						if(!isNullOrEmpty(value)) {
							if(value=="M"){
								return "Marks"; 
							}else if(value=="G") {
								return "Grade"; 
							}
						}                        
					} 
		      }]
	    },{
			 xtype: 'grid',
		     //autoScroll:true,
		     name:'typeGrid',
		     itemId:'typeGridItemId',
		     frame:false,
		     border:true,
		     viewConfig: {
		 		stripeRows: CONSTANTS.STRIPEROWS
		 	},
		     store: 'examinationcenters.remark.EvaluationPlanLevelOneByEvaluationPlanId',
		     maxHeight:300,
	         hideHeaders :false,
	         //width: '95%',
//	     	 height:'100%',
	         selModel: {
	        	 checkOnly : true, 
	        	 allowDeselect: false
	         },
	         columns: [{
		        header: getExaminationTranslation('EVALUATION_TYPE'),
		        dataIndex: 'value',
		        flex:.1,
		        sortable:true,
		    }]
	    },{
			 xtype: 'grid',
		     //autoScroll:true,
		     name:'subtypeGrid',
		     itemId:'subtypeGridItemId',
		     frame:false,
		     border:true,
		     viewConfig: {
		    	 stripeRows: CONSTANTS.STRIPEROWS
		     	},
		     store: 'examinationcenters.remark.EvaluationPlanLevelTwoByEvaluationPlanId',
		     maxHeight:300,
	         hideHeaders :false,
	         //width: '95%',
//	     	 height:'100%',
	         selModel: {
	    	     checkOnly : true, 
	    	     allowDeselect: false
	        },
	        dockedItems: [{
	     		xtype : 'toolbar',
	     		dock : 'bottom',
	     		items : [ {
	     			xtype : 'custompagingtoolbar',
	     			plugins:['pagesize'],
	     			store : 'examinationcenters.remark.EvaluationPlanLevelTwoByEvaluationPlanId',
	     			emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
	     			displayInfo : true
	     		} ]
	     	}],
	     	
	         columns: [{
		        header: getExaminationTranslation('EVALUATION_SUB_TYPE'),
		        dataIndex: 'value',
		        flex:.1,
		        sortable:true,
		    }],
	    },{
			 xtype: 'grid',
		     //autoScroll:true,
		     name:'methodGrid',
		     itemId:'methodGridItemId',
		     frame:false,
		     border:true,
		     viewConfig: {
		    	 stripeRows: CONSTANTS.STRIPEROWS
		     },
		     store: 'examinationcenters.evaluation.coverageDetails.MethodByEvaluationPlan',
		     maxHeight:300,
	         hideHeaders :false,
	         //width: '95%',
//	     	 height:'100%',
	         selModel: {
	    	     checkOnly : true, 
	    	     allowDeselect: false
	        },
	         columns: [{
		        header: getExaminationTranslation('EVALUATION_SEQUENCE'),
		        dataIndex: 'value',
		        flex:.1,
		        sortable:true,
		    }],
	    },{
			 xtype: 'grid',
		     //autoScroll:true,
		     name:'eventGrid',
		     itemId:'eventGridItemId',
		     frame:false,
		     border:true,
		     viewConfig: {
		    	 stripeRows: CONSTANTS.STRIPEROWS
		     },
		     store: 'examinationcenters.manageEvaluation.EvaluationEventByEvalPlanStore',
		     maxHeight:300,
	         hideHeaders :false,
	         //width: '95%',
//	     	 height:'100%',
	         selModel: {
	    	     checkOnly : true, 
	    	     allowDeselect: false
	        },
	        dockedItems: [{
	     		xtype : 'toolbar',
	     		dock : 'bottom',
	     		items : [ {
	     			xtype : 'custompagingtoolbar',
	     			plugins:['pagesize'],
	     			store : 'examinationcenters.manageEvaluation.EvaluationEventByEvalPlanStore',
	     			emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
	     			displayInfo : true
	     		} ]
	     	}],
	         columns: [{
		        header: getExaminationTranslation('DETAILED_SEQUENCE'),
		        dataIndex: 'value',
		        flex:.1,
		        sortable:true
		    }]
	    },{
			 xtype: 'grid',
		     //autoScroll:true,
		     name:'locationGrid',
		     itemId:'locationGridItemId',
		     frame:false,
		     border:true,
		     viewConfig: {
		    	 stripeRows: CONSTANTS.STRIPEROWS
		     },
		     store: 'examinationcenters.evaluation.coverageDetails.AcademyLocationByEvaluationPlan',
		     maxHeight:300,
	         hideHeaders :false,
	         //width: '96%',
//	     	 height:'100%',
	         selModel: {
	    	     checkOnly : true, 
	    	     allowDeselect: false
	        },
	         columns: [{
		        header: getExaminationTranslation('ACADEMY_LOCATION'),
		        dataIndex: 'academyLocationName',
		        flex:.1,
		        sortable:true,
		        /*renderer:function(value,meta,record){
					if(record.data.isMapped) {
						return value;
					} else{
						record.hide();
					}                       
				} */
		    }],
			listeners:{
				afterrender: function(grd){
					var gridStore = grd.getStore();
					gridStore.on('load',function(){
						setTimeout(function(){
							var gridDom = grd.el ? grd.el.dom : null;
							if(!isNullOrEmpty(gridDom)){
								var newTotalCount = 0;
								Ext.each(gridStore.data.items, function(currentItem){
										newTotalCount = newTotalCount + 1;
								});
								Ext.query('#'+gridDom.parentElement.id+' .gridTotalDivCls')[0].children[0].innerText = getCommonTranslation('TOTAL_RECORDS')+": "+ newTotalCount;
							}
						},300);
					});
				}
			}
	    },{
			 xtype: 'grid',
		     //autoScroll:true,
		     name:'variantGrid',
		     itemId:'variantGridItemId',
		     frame:false,
		     border:true,
		     store: 'examinationcenters.evaluation.coverageDetails.EvaluationPlanMappedCourseVariantGridStore',
		     maxHeight:300,
	         hideHeaders :false,
	         viewConfig: {
	             stripeRows: CONSTANTS.STRIPEROWS
	         },
	         selModel: {
	    	     checkOnly : true, 
	    	     allowDeselect: false
	        },
	        dockedItems: [{
	            xtype: "toolbar",
	            dock: "bottom",
	            items: [{
	                xtype: "custompagingtoolbar",
	                plugins: ["pagesize"],
	                store: "examinationcenters.evaluation.coverageDetails.EvaluationPlanMappedCourseVariantGridStore",
	                emptyMsg: getCommonTranslation("NORESULTSNMESSAGE"),
	                displayInfo: true
	            }]
	        }],
	         columns: [{
		        header: getExaminationTranslation('COURSE_VARIANT'),
		        dataIndex: 'courseVariantName',
		        flex:.1,
		        sortable:true
		    },{
		        header: getExaminationTranslation('COURSE_NAME'),
		        dataIndex: 'courseName',
		        flex:.1,
		        sortable:true
		    },{
		        header: getExaminationTranslation('PROGRAM'),
		        dataIndex: 'programName',
		        flex:.1,
		        sortable:true
		    },{
		        header: getExaminationTranslation('BATCH'),
		        dataIndex: 'batchName',
		        flex:.1,
		        sortable:true
		    },{
		        header: getExaminationTranslation('PERIOD'),
		        dataIndex: 'periodName',
		        flex:.1,
		        sortable:true
		    },{
		        header: getExaminationTranslation('SECTION'),
		        dataIndex: 'sectionName',
		        flex:.1,
		        sortable:true
		    },{
		        header: getExaminationTranslation('EXAM_STATUS'),
		        dataIndex: 'whetherExamCompleted',
		        flex:.13,
		        sortable:true,
		        renderer:function(value,meta,record){
					if(value) {
						return "Completed";
					} else {
						return "Pending";
					}
		        }
		    }]
	    },{
			 xtype: 'grid',
		     //autoScroll:true,
		     name:'programGrid',
		     itemId:'programGridItemId',
		     frame:false,
		     border:true,
		     store: 'examinationcenters.evaluation.evaluationPlanHeirarchy.EvaluationProgramStore',
		     maxHeight:300,
	         hideHeaders :false,
	         //width: '95%',
//	     	 height:'100%',
	         viewConfig: {
	             stripeRows: CONSTANTS.STRIPEROWS
	         },
	         selModel: {
	    	     checkOnly : true, 
	    	     allowDeselect: false
	        },
	         columns: [{
		        header: getExaminationTranslation('PROGRAM'),
		        dataIndex: 'value',
		        flex:.1,
		        sortable:true
		    }]
	    },{
			 xtype: 'grid',
		     //autoScroll:true,
		     name:'sectionGrid',
		     itemId:'sectionGridItemId',
		     frame:false,
		     border:true,
		     store: 'examinationcenters.evaluation.coverageDetails.ProgramBatchSectionGrid',
		     maxHeight:300,
	         hideHeaders :false,
	         //width: '95%',
//	     	 height:'100%',
	         viewConfig: {
	             stripeRows: CONSTANTS.STRIPEROWS
	         },
	         selModel: {
	    	     checkOnly : true, 
	    	     allowDeselect: false
	        },
	         columns: [{
	             header: getExaminationTranslation('PROGRAM'),
	             dataIndex: 'programName',
	             flex:.2,
	             sortable:true
	         },{
	             header: getExaminationTranslation('BATCH'),
	             dataIndex: 'batchName',
	             flex:.2,
	             sortable:true
	         },{
	             header: getExaminationTranslation('PERIOD'),
	             dataIndex: 'programPeriodName',
	             flex:.2,
	             sortable:true
	         }, {
	             header: getExaminationTranslation('SECTION'),
	             dataIndex: 'sectionCode',
	             flex:.2,
	             sortable: true
	         }]
	    }]	
});