/**
 * sumit.meena
 */
Ext.define('Academia.view.examinationcenters.evalution.EvaluationPlanMasterGrid', {
    extend: 'Ext.grid.Panel',
    alias: 'widget.evaluationplanmastergrid',
    store: 'examinationcenters.evaluation.EvaluationPlanMasterList',
    border: true,
    autoScroll: false,
    frame:false,
    viewConfig: {
    	stripeRows: CONSTANTS.STRIPEROWS
    },
	dockedItems : [ {
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
		        xtype: 'custompagingtoolbar',
	            plugins:['pagesize'],
			    store : 'examinationcenters.evaluation.EvaluationPlanMasterList',
			    emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			    displayInfo : true
		} ]
	}
	],
    tbar: [{
        xtype: 'button',
        itemId: 'btnAdd',
        tooltip: getCommonTranslation('ADD'),
        glyph: ICONGLYPH.ADDGLYPH
    }, {
        xtype: 'button',
        itemId: 'btnEdit',
        tooltip: getCommonTranslation('EDIT'),
        glyph: ICONGLYPH.EDITGLYPH
    /*}, {
        xtype: 'button',
        itemId: 'btnView',
        tooltip: getCommonTranslation('VIEW'),
        iconCls: 'view-icon'
    }, {
        xtype: 'button',
        itemId: 'btnDelete',
        cls: 'CustomToolbarBtnReject',
        tooltip: getCommonTranslation('DELETE'),
        glyph: ICONGLYPH.DELETEGLYPH*/
    }],
    columns: [{
        header: getExaminationTranslation('EVALUATION_PLAN_TYPE'),
        dataIndex: 'evaluationPlanType',
        flex:.4,
        sortable:true
    }, {
        header: getExaminationTranslation('EVALUATION_STAGE'),
        dataIndex: 'evaluationStage',
        flex:.3,
        sortable: true
    }, {
        header: getExaminationTranslation('EVALUATION_PLAN_NO'),
        dataIndex: 'evaluationPlanNumber',
        flex:.3,
        sortable: true
    }, {
        header: getExaminationTranslation('COURSE_NAME'),
        dataIndex: 'courseName',
        flex:.3,
        sortable: true
    }, {
        header: getExaminationTranslation('SEQUENCE_NAME'),
        dataIndex: 'sequenceName',
        flex:.3,
        sortable: true
    }, {
        header: getExaminationTranslation('PLANNED_DATE'),
        dataIndex: 'plannedDate',
        flex:.3,
        sortable: true,
		renderer:function(date) {
			return dateRender(date);
		}
    }]
});