/*
 * Kamlesh
 */

Ext.define('Academia.view.examinationcenters.evalution.evaluationPlanHierarchy.EvaluationPlanSequenceDetailForm', {
	//extend: 'Ext.form.FormPanel',
	extend: 'Academia.view.common.DynamicFieldForm',
	alias: 'widget.evaluationplansequencedetailform',
	title: '',
	autoScroll: false,
	frame: true,
	items:[{
		xtype:'form',
		itemId:'evaluationplansequencedetailformItemId',
		method: 'POST',
		layout: {
			type: 'vbox'
		},
		standardSubmit: false,
		defaults: {
			labelAlign: 'top',
			width: 226
		},
		plugins:"formlabelrequired",
		items: [{
    	        xtype: 'hidden',
    	        itemId: 'addEdit'
    	    }, {
			xtype: 'hidden',
			name: 'id'
		},{
			xtype: 'hidden',
			name: 'evaluationSequenceId'
		},{
			xtype: 'hidden',
			name: 'version'
		},{
			xtype: 'hidden',
			name: 'maxMarkLastValue'
		},{
			xtype: 'textfield',
			fieldLabel:getExaminationTranslation('SEQUENCE'),
			name: 'evaluationSequence',
			readOnly:true,
			hidden:true
		},{
			xtype:'fieldset',
			title: getCommonTranslation('BASIC_CONFIGURATION'),
			frame:true,	
			collapsible:true,
			collapsed:false,
			border:true,
			width:'100%',
			style:{
				marginTop:'0px !important',
			},
			items: [{
				xtype: 'fieldcontainer',
				width:'100%',
				layout: {
					type: 'vbox'
				},
				style:{
					marginLeft:'20px !important',
				},
				items: [{
					xtype: 'fieldcontainer',
					width:'100%',
					layout: {
						type: 'hbox'
					},
					defaults :{
						width: 226,
						labelAlign:'top'
					},
					items: [ {
						xtype: 'textfield',
						name: 'detailSequenceNumber',
						itemId:'detailSequenceNumberItemId',
						fieldLabel:getExaminationTranslation('DETAILED_SEQUENCE'),
						allowBlank: false,
					},{
						xtype: 'numberfield',
						name: 'weightage',
						itemId:'weightage',
						fieldLabel:getExaminationTranslation('WEIGHTAGE'),
						minValue : 0,
						maxValue : 100,
						allowBlank: false,
						allowDecimals:true,
					}]

				},{
					xtype: 'fieldcontainer',
					width:'100%',
					layout: {
						type: 'hbox'
					},
					defaults :{
						width: 226,
						labelAlign:'top'
					},
					items: [ {
						xtype: 'customcombobox',
						store:'examinationcenters.evaluation.evaluationPlanHeirarchy.GradeAndMarkData',
						name: 'evalInMarksOrGrade',
						itemId:'markGradeComboItemId',
						displayField:'value',
						valueField:'id',
						forceSelection:true,
						typeAhead:true,
						minChars:3,
						fieldLabel:getExaminationTranslation('GRADEMARKS'),
						allowBlank: false
					}, {
						xtype: 'customcombobox',
						store:'gradeMaster.GradeTypeNameValueStore',
						name: 'gradeType',
						itemId:'gradeTypeItemId',
						fieldLabel:getExaminationTranslation('GRADE'),
						displayField:'value',
						valueField:'value',
						forceSelection:true,
						typeAhead:true,
						minChars:3,
						allowBlank: false,
						hidden:true
					}]
				},{

					//START :These fields for shows when select grade/ Marks combo Grade//
					xtype: 'fieldcontainer',
					width:'100%',
					layout: {
						type: 'hbox'
					},
					defaults :{
						width: 226,
						labelAlign:'top'
					},
					items: [{
						xtype: 'customcombobox',
						name: 'minGrade',
						store:'examinationcenters.evaluation.evaluationPlanHeirarchy.EvaluationFormOneGrades',
						displayField:'gradeName',
						valueField:'gradeName',
						forceSelection:true,
						typeAhead:true,
						fieldLabel:getExaminationTranslation('MINIMUM_PASSING_GRADES'),
						hidden:true,
						allowBlank:false
					},{
						xtype: 'customcombobox',
						name: 'maxGrade',
						store:'examinationcenters.evaluation.evaluationPlanHeirarchy.EvaluationFormOneGrades',
						displayField:'gradeName',
						valueField:'gradeName',
						forceSelection:true,
						typeAhead:true,
						fieldLabel:getExaminationTranslation('MAXIMUM_PASSING_GRADES'),
						hidden:true,
						allowBlank:false
					}]
				},{
					xtype: 'fieldcontainer',
					width:'100%',
					layout: {
						type: 'hbox'
					},
					defaults :{
						width: 226,
						labelAlign:'top'
					},
					items: []
					//END :These fields for shows when select grade/ Marks combo Grade//
				},{
					//START :These fields for shows when select grade/ Marks combo Marks//
					xtype: 'fieldcontainer',
					width:'100%',
					layout: {
						type: 'hbox'
					},
					defaults :{
						width: 226,
						labelAlign:'top'
					},
					items: [{
						xtype: 'numberfield',
						name: 'minMarks',
						allowDecimals:true,
			            decimalPrecision: 2,
						itemId:'minMarksItemId',
						fieldLabel:getExaminationTranslation('MINIMUM_PASSING_MARKS'),
						minValue : 0,
						allowBlank:false,
						validator : function(val) {
							var maxValuefield = this.nextSibling();
							var maxValue = maxValuefield.getValue();
							if (maxValue != null) {
								if (val < maxValue) {
									maxValuefield
									.clearInvalid();
									return true;
								} else {
									return getCommonTranslation('LESS_THAN_MAX_VALUE');
								}
							} else {
								return true;
							}
						}
					}, {
						xtype: 'numberfield',
						name: 'maxMarks',//maxMarks
						itemId:'maxMarksItemId',
						fieldLabel:getExaminationTranslation('MAXIMUM_PASSING_MARKS'),
						minValue : 0,
						allowBlank:true,
						decimalPrecision: 2,
						validator : function(val) {
							var minValueField =this.previousSibling();
							var minValue = minValueField
							.getValue();
							if (minValue != null) {
								if (val > minValue) {
									minValueField
									.clearInvalid();
									return true;
								} else {
									return getCommonTranslation('MORE_THAN_MIN_VALUE');
								}
							} else {
								return true;
							}
						}
					}]
				},{
					xtype : 'fieldcontainer',
					width : '100%',
					layout : {
						type : 'hbox'
					},
					defaults : {
						width : 226,
						labelAlign : 'top'
					},
					items : [{
						xtype: 'customcombobox',
						store:'examinationcenters.evaluation.RoundingModeForLevelTwo',
						name: 'roundingMode',
						itemId:'roundingModeItemId',
						displayField:'value',
						valueField:'id',
						forceSelection:true,
						typeAhead:true,
						hidden:false,
						fieldLabel:getExaminationTranslation('ROUNDING_MODE'),
						allowBlank: false
					},{
						xtype: 'numberfield',
						name: 'roundingCount',
						minValue:0,
						maxValue:4,
						fieldLabel: getExaminationTranslation('ROUNDING_POINT')
					}]
				},{
					xtype: 'fieldcontainer',
					width:'100%',
					layout: {
						type: 'hbox'
					},
					defaults :{
						width: 226,
						labelAlign:'top'
					},
					items: []
					//END :These fields for shows when select grade/ Marks combo Marks//
				},{
					xtype: 'fieldcontainer',
					width: 'auto',
					layout: {
						type: 'hbox'
					},
					defaults: {
						labelAlign: 'top',
						width:226
					},
					layout: 'hbox',
					items:[{
						xtype      : 'radiogroup',
						fieldLabel : getExaminationTranslation('WHETHER_PASSING_CRITICAL'),
						name:'passingCritical',
						itemId:'passingCritical',
//						disabled:true,
						defaults: {
							flex: 1
						},
						layout: 'hbox',
						items:[{ 
							boxLabel: getCommonTranslation('YES'), 
							name: 'whetherPassesCritical', 
							inputValue: true
						},{ 
							boxLabel: getCommonTranslation('NO'), 
							name: 'whetherPassesCritical', 
								inputValue: false,
								checked: true
							}]
					}, {
							xtype: 'radiogroup',
							fieldLabel: getExaminationTranslation('ROUNDED_MARK_ENRTY_CHECK'), 
							name: 'roudnedMarkEntry',
							itemId: 'roudnedMarkEntry', 
							//disabled:true,
							defaults: {
								flex: 1
							},
							layout: 'hbox',
							items: [{
								boxLabel: getCommonTranslation('YES'),
								name: 'whetherRoundedMark',
								inputValue: true
							}, {
								boxLabel: getCommonTranslation('NO'),
								name: 'whetherRoundedMark',
								inputValue: false,
								checked: true
							}]
						}, {
							xtype: 'numberfield',
							name: 'failMarksToBeAwarded',
							fieldLabel: getExaminationTranslation('FAIL_MARKS_TO_BE_AWARDED'),
							minValue: 0,
							allowDecimals: false,
						allowBlank: false,
						hidden:true,
						disabled:true
					},{
						xtype: 'customcombobox',
						name: 'failGradeToBeAwarded',
						store:'examinationcenters.evaluation.evaluationPlanHeirarchy.EvaluationFormOneGrades',
						displayField:'gradeName',
						valueField:'gradeName',
						forceSelection:true,
						typeAhead:true,
						allowBlank: false,
						fieldLabel:getExaminationTranslation('FAIL_GRADE_TO_BE_AWARDED'),
						hidden:true
					},{
			              xtype: 'customcombobox',
			              name: 'supplementaryDrool',
			              itemId:'supplementaryDroolItemId',
			              store:'examinationcenters.evaluation.evaluationPlanHeirarchy.SuppplementaryDroolStore',
			              displayField:'value',
			              valueField:'id',
			              forceSelection:true,
			              typeAhead:true,
//			              allowBlank: false,
			              fieldLabel:getExaminationTranslation('SUPPLEMENTARY_DROOL'),
			              hidden:true,
			      }]
				},{
					xtype: 'fieldcontainer',
					width:'100%',
					layout: {
						type: 'hbox'
					},
					defaults :{
						width: 226,
						labelAlign:'top'
					},
					items: [{
						xtype: 'customcombobox',
						name: 'repetitionType',
						itemId: 'repetitionTypeId',
						store:'examinationcenters.evaluation.evaluationPlanHeirarchy.RepetitionTypeEnumStore',
						fieldLabel : getExaminationTranslation('REPETITION_TYPE'),
						displayField:'value',
						valueField:'id',
						forceSelection:true,
						typeAhead:true,
						hidden:true
					},{
						xtype: 'customcombobox',
						name: 'eventTobeRepeated',
						itemId: 'eventTobeRepeatedId',
						store:'examinationcenters.evaluation.evaluationPlanHeirarchy.EvaluationEventsByLevelIdStore',
						fieldLabel : getExaminationTranslation('EVENT_TO_BE_REPEAT'),
						displayField:'value',
						valueField:'levelId',
						hidden:true,
						readOnly:true
					}]
				},{
					xtype: 'fieldcontainer',
					width: 'auto',
					layout: {
						type: 'hbox'
					},
					defaults: {
						labelAlign: 'top',
						width:226
					},
					layout: 'hbox',
					items:[{
						xtype      : 'radiogroup',
						fieldLabel : getExaminationTranslation('PART_OF_EVALUATION_GROUP'),
						name:'partOfEvaluationGroup',
						itemId:'partOfEvaluationGroupItemId',
						defaults: {
							flex: 1
						},
						layout: 'hbox',
						items:[{ 
							boxLabel: getCommonTranslation('YES'), 
							name: 'partOfEvaluationGroup', 
							inputValue: true
						},{ 
							boxLabel: getCommonTranslation('NO'), 
							name: 'partOfEvaluationGroup', 
							inputValue: false,
							checked:true
						}]
					},{
						xtype      : 'radiogroup',
						fieldLabel : getExaminationTranslation('ASSIGNMENT_EVALUATION'),
						name:'isAssignmentEvaluation',
						itemId:'isAssignmentEvaluationItemId',
						defaults: {
							flex: 1
						},
						layout: 'hbox',
						items:[{ 
							boxLabel: getCommonTranslation('YES'), 
							name: 'isAssignmentEvaluation', 
							inputValue: true
						},{ 
							boxLabel: getCommonTranslation('NO'), 
							name: 'isAssignmentEvaluation', 
							inputValue: false,
							checked:true
						}]
					},{
						xtype      : 'textfield',// didn,t find in model TODO
						fieldLabel : getExaminationTranslation('FEE_PLAN_REFERENCE'),
						itemId: 'feePlanReferenceItemId',
						name:'feePlanId',
						hidden:true
					}]
				},{
					xtype: 'fieldcontainer',
					width: 'auto',
					layout: {
						type: 'hbox'
					},
					defaults: {
						labelAlign: 'top',
						width:226
					},
					layout: 'hbox',
					items:[,{
						xtype  : 'radiogroup',
						fieldLabel : getExaminationTranslation('WHETHER_AUTO_ENROLL'),
						name:'whetherAutoEnrollRadioGroup',
						itemId:'whetherAutoEnrollGroupItemId',
						defaults: {
							flex: 1
						},
						layout: 'hbox',
						items:[{ 
							boxLabel: getCommonTranslation('YES'), 
							name: 'whetherAutoEnroll', 
							inputValue: true,
							checked:true
						},{ 
							boxLabel: getCommonTranslation('NO'), 
							name: 'whetherAutoEnroll', 
							inputValue: false
						}]
					},{
						/**
						 * as written test is set by default to false and disabled ,So, on the bases these fields are hidden
						 * "objectiveType,answerPaperAvailable,revaluationType,modeOfAdministration,evaluationAnonymous,timeInMinutes,
						 * noOfQPRequired,rndmSlctnAplcble,resultExceptionToTime,exceptionRuleAgendaDescription"
						 */
						xtype      : 'radiogroup',
						fieldLabel : getExaminationTranslation('ANONYMOUS_EVALUATION'),
						name:'evaluationAnonymous',
						itemId:'evaluationAnonymous',
						defaults: {
							flex: 1
						},
						layout: 'hbox',
						items:[{ 
							boxLabel: getCommonTranslation('YES'), 
							name: 'whetherEvalAnonymous', 
							inputValue: true
						},{ 
							boxLabel: getCommonTranslation('NO'), 
							name: 'whetherEvalAnonymous', 
							inputValue: false,
							checked:true
						}]
					}]
				},{
					xtype: 'fieldcontainer',
					width: 'auto',
					layout: {
						type: 'hbox'
					},
					defaults: {
						labelAlign: 'top',
						width:226
					},
					layout: 'hbox',
					items:[{
						xtype      : 'radiogroup',
						fieldLabel : getExaminationTranslation('ATTENDANCE_BASED_DETENTENTION'),
						name:'attendanceBasedDetention',
						itemId:'attendanceBasedDetentionItemId',
						defaults: {
							flex: 1
						},
						layout: 'hbox',
						items:[{ 
							boxLabel: getCommonTranslation('YES'), 
							name: 'attendanceBasedDetention', 
							inputValue: true
						},{ 
							boxLabel: getCommonTranslation('NO'), 
							name: 'attendanceBasedDetention', 
							inputValue: false,
							checked:true
						}]
					},{
						xtype      : 'radiogroup',
						fieldLabel : getExaminationTranslation('EVALUATION_BASED_DETENTENTION'),
						name:'evaluationBasedDetention',
						itemId:'evaluationBasedDetentionItemId',
						defaults: {
							flex: 1
						},
						layout: 'hbox',
						items:[{ 
							boxLabel: getCommonTranslation('YES'), 
							name: 'evaluationBasedDetention', 
							inputValue: true
						},{ 
							boxLabel: getCommonTranslation('NO'), 
							name: 'evaluationBasedDetention', 
							inputValue: false,
							checked:true
						}]}]
				},{
					xtype: 'fieldcontainer',
					width: 'auto',
					layout: {
						type: 'hbox'
					},
					defaults: {
						//labelAlign: 'top',
						width:226
					},
					layout: 'hbox',
					items:[,
							{
						xtype: 'groupingcombobox',
						name: 'evalPlanLevelId',
						itemId:'evalPlanLevelItemId',
						labelAlign:'top',
						queryMode: 'local',
						groupField: 'code',
						groupDisplayField: 'code',
						store: 'examinationcenters.evaluation.evaluationPlanHeirarchy.EvaluationLevelNameStore',
						fieldLabel: getExaminationTranslation('EVALUATION_PLAN_LEVEL'),
						displayField: 'value',
						valueField: 'levelId' ,
						minChar : 3,
						allowBlank: true,
						editable:false,
						hidden:true,
						listeners:{
							select:function(obj,rec){
								var data=rec[0].data.code;
							}
						}
					},{
						xtype : 'customcombobox',
						name:'status',
						labelAlign: 'top',
						itemId:'eventStatus',
						fieldLabel : getExaminationTranslation('STATUS'),
						store:'examinationcenters.evaluation.evaluationPlanHeirarchy.EvaluationPlanLevelFourStatus',
						displayField:'value',
						valueField:'id',
						disabled:true,
						forceSelection:true,
						typeAhead:true,
						minChars:3,
					},{
						style:{'margin-top':'25px'},
			            xtype: 'checkboxfield',
			            labelAlign: 'right',
			            itemId:'whetherShowHallTicketNo',
			            boxLabel: getExaminationTranslation('SHOW_HALL_TICKET_NO_COLUMN'),
			            name: 'whetherShowHallTicketNo',
			           // inputValue : true,
			            uncheckedValue: true, 
			            hidden:true,
			            width:300
			            
			            }]
				},{
					xtype: 'fieldcontainer',
					width: 'auto',
					layout: {
						type: 'hbox'
					},
					defaults: {
						labelAlign: 'top',
						width:226
					},
					layout: 'hbox',
					items:[{
						xtype : 'radiogroup',
						itemId:'resultPublish',
						name:'resultPublish',
						fieldLabel : getExaminationTranslation('RESULT_PUBLISH'),
						defaults: {
							flex: 1
						},
						layout: 'hbox',
						items : [{
							boxLabel : getExaminationTranslation('YES'),
							name : 'isResultPublish',
							inputValue : true,
							checked : true
						}, {
							boxLabel : getExaminationTranslation('NO'),
							name : 'isResultPublish',
							inputValue : false,
						} ]
					},{
						xtype : 'customcombobox',
						name : 'resultPublishMode',
						itemId:'resultPublishMode',
						fieldLabel : getExaminationTranslation('RESULT_PUBLISH_MODE'),
						store : 'examinationcenters.evaluation.evaluationPlanHeirarchy.ExamResultPublishModeEventEnumStore',
						valueField : 'id',
						displayField : 'value',
						width:226,
					}]
				},
				{
					xtype: 'fieldcontainer',
					width: 'auto',
					layout: {
						type: 'hbox'
					},
					defaults: {
						labelAlign: 'top',
						width:226
					},
					layout: 'hbox',
					items:[{
						xtype : 'radiogroup',
						itemId:'visibleForFacultyId',
						name:'visibleForFaculty',
						fieldLabel : getExaminationTranslation('VISIBLE_FOR_FACULTY'),
						defaults: {
							flex: 1
						},
						layout: 'hbox',
						items : [{
							boxLabel : getExaminationTranslation('YES'),
							name : 'isVisibleForFaculty',
							inputValue : true,
							checked : true
						}, {
							boxLabel : getExaminationTranslation('NO'),
							name : 'isVisibleForFaculty',
							inputValue : false,
						} ]
					},]
				},{

					xtype: 'fieldcontainer',
					width: 'auto',
					layout: {
						type: 'hbox'
					},
					defaults: {
						labelAlign: 'top',
						width:226
					},
					layout: 'hbox',
					items:[{
						xtype : 'radiogroup',
						itemId:'attendanceRuleApplicableRadio',
						name:'attendanceRuleApplicableRadio',
						fieldLabel : getExaminationTranslation('ATTENDANCE_RULE_APPLICABLE'),
						defaults: {
							flex: 1
						},
						layout: 'hbox',
						items : [{
							boxLabel : getExaminationTranslation('YES'),
							name : 'isAttendanceRuleApplicable',
							inputValue : true,
							
						}, {
							boxLabel : getExaminationTranslation('NO'),
							name : 'isAttendanceRuleApplicable',
							inputValue : false,
							checked : true
						} ]
					},{
							xtype : 'customcombobox',
							name : 'attendanceRuleCombo',
							itemId:'attendanceRuleCombo',
							fieldLabel : getExaminationTranslation('ATTENDANCE_RULE'),
							store : 'attendancerulestores.AttendanceRuleGridStore',
							valueField : 'id',
							displayField : 'attendanceRule',
							width:226,
							hidden:true
						
					}]
				
				}
				
				/*{
					xtype: 'fieldcontainer',
					width: 'auto',
					layout: {
						type: 'hbox'
					},
					defaults: {
						labelAlign: 'top',
						width:226
					},
					layout: 'hbox',
					items:[{
						xtype : 'radiogroup',
						itemId:'attendanceRuleApp',
						name:'attendanceRuleApp',
						fieldLabel : getExaminationTranslation('ATTENDANCE_RULE_APPLICABLE'),
						defaults: {
							flex: 1
						},
						layout: 'hbox',
						items : [{
							boxLabel : getExaminationTranslation('YES'),
							name : 'isAttendanceRuleApplicable',
							inputValue : true,
							
						}, {
							boxLabel : getExaminationTranslation('NO'),
							name : 'isAttendanceRuleApplicable',
							inputValue : false,
							checked:true
						} ]
					},
					{
						xtype: 'customcombobox',
						store:'attendancerulestores.AttendanceRuleGridStore',
						name: 'attendanceRule',
						itemId:'attendanceRuleId',
						displayField:'attendanceRule',
						valueField:'id',
						forceSelection:true,
						typeAhead:true,
						hidden:true,
						fieldLabel:getExaminationTranslation('ATTENDANCE_RULE') + ': <span class="required" style="color:red"> *</span>',
						//allowBlank: false

					}
					
					]
					
					
				}*/
				
				]
			}],
			listeners:{
				render: function(myfieldset){
					myfieldset.setMargin('-10px');
				}
			}
		},{
			xtype:'fieldset',
			title: getCommonTranslation('ADVANCE_CONFIGURATION'),
			layout:'vbox',
			frame:true,	
			collapsible:true,
			collapsed:true,
			border:true,
			width:'100%',
			style:{
				marginTop:'0px !important',
				width:'226px !important',
			},
			items: [{
				xtype: 'fieldcontainer',
				width:'225px',
				layout: {
					type: 'vbox'
				},
				style:{
					marginLeft:'20px !important',
					width:'226px !important',
				},
				items: [{
					xtype: 'fieldcontainer',
					width: '226px',
					style:{
						width:'226px !important',
					},
					layout: {
						type: 'hbox'
					},
					defaults: {
						labelAlign: 'top',
						width:226
					},
					layout: 'hbox',
					items:[{
						/**
						 * This field is shown at the time of edit only and while creating sequence false value is sending.
						 */
						xtype      : 'radiogroup',
						fieldLabel : getExaminationTranslation('DETAILED_SEQUENCE_EQUIVALENT'),
						name:'detailSequenceEqvlnt',
						itemId:'detailSequenceEqvlntItemId',
						//hidden:true,
						defaults: {
							flex: 1
						},
						layout: 'hbox',
						items:[{ 
							boxLabel: getCommonTranslation('YES'), 
							name: 'whetherDetailSeqEquivalent', 
							inputValue: true
						},{ 
							boxLabel: getCommonTranslation('NO'), 
							name: 'whetherDetailSeqEquivalent', 
							inputValue: false,
							checked:true
						}]
					},
					{
						xtype      : 'customcombobox',
						fieldLabel : getExaminationTranslation('DETAILED_SEQUENCE_EQUIVALENT_NO'),
						name:'evalDetailSeqEquivalentId',
						itemId:'evalDetailSeqEquivalentId',
						store:'examinationcenters.evaluation.evaluationPlanHeirarchy.DetailSequenceEquivalentNo',
						valueField:'id',
						displayField:'value',
						forceSelection:true,
						typeAhead:true,
						minChars:3,
						allowBlank:false,
						queryMode:'local',
						hidden:true,
						width:240,
					},
					{
			            xtype: 'checkboxfield',
			            itemId:'appliedExamMarkEntry',
			            boxLabel: getExaminationTranslation('APPLIED_EXAM_MARK_ENTRY'),
			            name: 'appliedExamMarkEntry',
			            inputValue : true,
			            uncheckedValue: false,
			            hidden: true
			        }]
				},{
					xtype: 'fieldcontainer',
					width: 'auto',
					layout: {
						type: 'hbox'
					},
					defaults: {
						labelAlign: 'top',
						width:226
					},
					layout: 'hbox',
					items:[{
						xtype      : 'customcombobox',
						fieldLabel : getExaminationTranslation('RULE_FOR_ABSENTS'),
						name:'ruleForAbsents',
						itemId:'ruleForAbsentsId',
						store:'examinationcenters.evaluation.evaluationPlanHeirarchy.RuleForAbsentEnumStore',
						displayField:'value',
						valueField:'id',
						forceSelection:true,
						typeAhead:true,
						minChars:3,
						allowBlank:true,
						hidden:false
					},{
						xtype: 'numberfield',
						name: 'minMarksForRuleAbsent',
						itemId:'minMarksForRuleAbsentItemId',
						fieldLabel:getExaminationTranslation('MINIMUM_MARKS'),
						minValue : 0,
						value: 0,
						allowBlank:true,
//						validator : function(val) {
//							var maxValuefield = this.nextSibling();
//							var maxValue = maxValuefield.getValue();
//							if (maxValue != null) {
//								if (val < maxValue) {
//									maxValuefield
//									.clearInvalid();
//									return true;
//								} else {
//									return getCommonTranslation('LESS_THAN_MAX_VALUE');
//								}
//							} else {
//								return true;
//							}
//						}
					},{
						xtype: 'customcombobox',
						name: 'minGradeForRuleAbsent',
						store:'examinationcenters.evaluation.evaluationPlanHeirarchy.EvaluationEventFormMinGradeComboStore',
						displayField:'gradeName',
						valueField:'gradePoint',
						forceSelection:true,
						typeAhead:true,
						fieldLabel:getExaminationTranslation('MINIMUM_GRADES'),
						hidden:true,
						allowBlank:true
					}]
				},{
					xtype: 'fieldcontainer',
					width: 'auto',
					layout: {
						type: 'hbox'
					},
					defaults: {
						labelAlign: 'top',
						width:226
					},
					layout: 'hbox',
					items:[{
						xtype      : 'radiogroup',
						fieldLabel : getExaminationTranslation('IS_REVALUATION_POSSIBLE'),
						name:'revaluationPossible',
						itemId:'revaluationPossibleItemId',
						defaults: {
							flex: 1
						},
						layout: 'hbox',
						items:[{ 
							boxLabel: getCommonTranslation('YES'), 
							name: 'isRevaluationPossible', 
							inputValue: true
						},{ 
							boxLabel: getCommonTranslation('NO'), 
							name: 'isRevaluationPossible', 
							inputValue: false,
							checked:true
						}]
					},{
						xtype      : 'customcombobox',
						fieldLabel : getExaminationTranslation('EQUIVALENT_EVENT_RULE'),
						name:'ruleForEquivalentEvent',
						store:'examinationcenters.evaluation.evaluationPlanHeirarchy.EquivalentEventRuleCombo',
						valueField:'id',
						displayField:'value',
						forceSelection:true,
						typeAhead:true,	
						minChars:3,
						value:'BEST',
						queryMode:'local'
					}]
				},{
					xtype: 'fieldcontainer',
					width: 'auto',
					layout: {
						type: 'hbox'
					},
					defaults: {
						labelAlign: 'top',
						width:226
					},
					layout: 'hbox',
					items:[{
						xtype: 'textfield',
						name: 'detailSequenceDesc',
						fieldLabel:getExaminationTranslation('DETAILED_SEQUENCE_DESCRIPTION'),
						allowBlank: true,
					},{
						xtype : 'datefield',
						anchor : '100%',
						fieldLabel : getExaminationTranslation('PLANNED_ON'),
						name : 'plannedOn',
						itemId : 'plannedOnItemId',
						listeners: {
							render: function(obj) {
								obj = dateFormatRender(obj);
								obj.setValue(new Date());
							}
						}
					}]
				},
				
				{
					xtype: 'fieldcontainer',
					width: 'auto',
					layout: {
						type: 'hbox'
					},
					defaults: {
						labelAlign: 'top',
						width:226
					},
					layout: 'hbox',
					items:[{
						/**
						 * as written test is set by default to false and disabled ,So, on the bases these fields are hidden
						 * "objectiveType,answerPaperAvailable,revaluationType,modeOfAdministration,evaluationAnonymous,timeInMinutes,
						 * noOfQPRequired,rndmSlctnAplcble,resultExceptionToTime,exceptionRuleAgendaDescription"
						 */
						xtype: 'customcombobox',
						name: 'modeOfAdministration',
						itemId:'modeOfAdministrationItemId',
						fieldLabel:getExaminationTranslation('MODE_OF_ADMINISTRATION'),
						store:'examinationcenters.evaluation.evaluationPlanHeirarchy.ModeOfAdministration',
						displayField:'value',
						valueField:'id',
						forceSelection:true,
						typeAhead:true,
						minChars:3,
						allowBlank: false
					},{
						xtype      : 'customcombobox',
						fieldLabel : getExaminationTranslation('TEST_ADMINISTRATOR_MODE'),
						store:'examinationcenters.evaluation.evaluationPlanHeirarchy.TestAdministrationMode',
						itemId: 'testAdministratorModeItemId',
						displayField:'value',
						valueField:'id',
						forceSelection:true,
						typeAhead:true,
						minChars:3,
						allowBlank:false,
						name:'testAdministrationMode'
					}]
				},
				{
					 xtype: 'fieldcontainer',
		            width: 700,
		            layout: 'hbox',
		            defaults: {
		                width: '235px !important',
		                labelAlign: 'top',
		                cls:'checkBoxCstmAddressLabel',
		                height: 50
		            },
 					items: [{
						xtype: 'numberfield',
						fieldLabel:getExaminationTranslation('MAX_CAP_MARK'),
						name: 'maxCappingMark',
						itemId:'maxCappingMarkId',
						minValue : 0,
						hidden:true,
						maxValue : 100,
					}, {
						xtype: 'checkboxfield',
					    itemId: 'autoConfigureATKTEvent',
					    boxLabel: getExaminationTranslation('AUTO_CONFIGURE_THE_ATKT_EVENT'),
					    name: 'autoConfigureATKTEvent',
					    inputValue: true,
					    uncheckedValue: false,
					    margin: '25 0 0 13'
					},{
						xtype: 'checkboxfield',
						itemId: 'autoDetainTheStudent',
						boxLabel: getExaminationTranslation('AUTO_DETAIN_THE_STUDENT_CHECK'),
						name: 'autoDetainTheStudent',
						inputValue: true,
						hidden:true,        
						uncheckedValue: false,
						margin: '25 0 0 0' 
										}]
				}
				,{
		            xtype: 'fieldcontainer',
		            width: 'auto',
		            layout: 'hbox',
		            defaults: {
		            	width:'235px !important',
		                labelAlign: 'top',
		                cls:'checkBoxCstmAddressLabel',
		                height: 50
		            },
		            items: [{
				            xtype: 'checkboxfield',
				            itemId:'whether_penaltymarks',
				            boxLabel: getExaminationTranslation('SHOW_PENALTY_MARKS'),
				            name: 'whetherShowPenaltyMarks',
				            inputValue : true,
				            uncheckedValue: false 
				        },{      
				    		 xtype: 'checkboxfield',         
				    		 itemId:'requireacademicStanding', /*Require Academic Standing filter*/       
				    		 boxLabel:getCommonTranslation('REQUIRE_ACADEMICS_STANDING'),            
				    		 name: 'requireacademicStanding',   
				    		 inputValue : true,     
				    		 uncheckedValue:false,    
				    		 hidden:false       
			            },{
	    		            xtype: 'checkboxfield',
	    		            itemId:'whether_gracemarks',
	    		            boxLabel: getExaminationTranslation('SHOW_GRACE_MARKS'),
	    		            name: 'whetherShowGraceMarks',
	    		            inputValue : true,
	    		            uncheckedValue: false      
	    		        }]
		        	},
		        /** 
		         * Adding two field Copy Marks/Grade From Method: & Copy Marks/Grade From Event: (V2D-378519) 	
		         */
					{
					xtype: 'fieldcontainer',
					width: 'auto',
					layout: {
						type: 'hbox'
					},
					defaults: {
						labelAlign: 'top',
						width:226
					},
					layout: 'hbox',
					items:[{
						xtype: 'customcombobox',
						name: 'copyMarksGradeMethod',
						itemId:'copyMarksGradeMethodId',
						fieldLabel:getExaminationTranslation('COPY_MARKS_GRADE_METHOD'),
						store:'sunsuccess.CopyMarksGradeMethodStore',
						displayField:'value',
						valueField:'id',
						forceSelection:true,
						typeAhead:true,
						minChars:3,
						allowBlank: true,
						hidden:true
					},{
						xtype: 'customcombobox',
						name:'copyMarksGradeEvent',
						fieldLabel : getExaminationTranslation('COPY_MARKS_GRADE_EVENT'),
						store:'sunsuccess.CopyMarksGradeEventStore',
						itemId: 'copyMarksGradeEventId',
						displayField:'value',
						valueField:'id',
						forceSelection:true,
						typeAhead:true,
						minChars:3,
						allowBlank:true,
						hidden:true,
						disabled:true,

					}]
				},
		        	{
					xtype: 'fieldcontainer',
					width: 'auto',
					layout: {
						type: 'hbox'
					},
					defaults: {
						labelAlign: 'top',
						width:226
					},
					layout: 'vbox',  
					items:[
						/*{
						xtype      : 'customcombobox',
						fieldLabel : getExaminationTranslation('EQUIVALENT_EVENT_RULE'),
						name:'ruleForEquivalentEvent',
						store:'examinationcenters.evaluation.evaluationPlanHeirarchy.EquivalentEventRuleCombo',
						valueField:'id',
						displayField:'value',
						forceSelection:true,
						typeAhead:true,	
						minChars:3,
						value:'BEST',
						queryMode:'local'
					}*/
						{
							xtype      : 'radiogroup',
							fieldLabel : getExaminationTranslation('ATKT_REQUIRED'),
							name:'whetherATKTRequired',
							itemId:'whetherATKTRequiredItemId',
							defaults: {
								flex: 1
							},
							layout: 'hbox',
							items:[{
								boxLabel: getCommonTranslation('YES'), 
								name: 'isATKTRequired', 
								inputValue: true
							},{
								boxLabel: getCommonTranslation('NO'), 
								name: 'isATKTRequired', 
								inputValue: false,
								checked:true
							}]
						}]
				}]
			}],
			listeners:{
				render: function(myfieldset){
					myfieldset.setMargin('-10px');
				},
				expand: function(myfieldset) {
					Ext.defer(function() {
						var arr = ['whether_penaltymarks', 'requireacademicStanding', 'whether_gracemarks'];
						for(var i=0;i<arr.length;i++) {
							var cb = myfieldset.down('#'+arr[i]);
							var newWidth = 226;//(cb.up().getWidth() / 3);
							cb.setWidth(newWidth);
							cb.boxLabelEl.setWidth(newWidth - 19);
						}
					}, 100);
				}
			}
		},{
			xtype: 'fieldcontainer',
			width: 'auto',
			hidden:true,
			layout: {
				type: 'hbox'
			},
			defaults: {
				labelAlign: 'top',
				width:226
			},
			layout: 'hbox',
			items:[{
				/**
				 * This field is disabled and set by default to false 
				 */
				xtype      : 'radiogroup',
				fieldLabel : getExaminationTranslation('PRIMARY_DETAILED_SEQUENCE'),
				itemId: 'primaryDetailSequenceItemId',
				name:'primaryDetailSequence',
				disabled:true,
				defaults: {
					flex: 1
				},
				layout: 'hbox',
				items:[{ 
					boxLabel: getCommonTranslation('YES'), 
					name: 'whetherPrimaryDetailSequence', 
					inputValue: true
				},{ 
					boxLabel: getCommonTranslation('NO'), 
					name: 'whetherPrimaryDetailSequence', 
					inputValue: false,
					checked:true
				}]
			},{
				xtype: 'customcombobox',
				name: 'secondaryDetailSequenceId',
				fieldLabel: getExaminationTranslation('SECONDARY_DETAILED_SEQUENCE'),
				store:'examinationcenters.evaluation.evaluationPlanHeirarchy.SecondryDetailSequence',
				displayField:'value',
				valueField:'id',
				forceSelection:true,
				typeAhead:true,
				minChars:3,
				queryMode:'local'
			}]
		},{
			xtype: 'fieldcontainer',
			width: 'auto',
			hidden:true,
			layout: {
				type: 'hbox'
			},
			defaults: {
				labelAlign: 'top',
				width:226
			},
			items:[{
				/**
				 * As discussed with pushpendra sir this field is disabled and set by default to false.
				 */
				xtype      : 'radiogroup',
				fieldLabel : getExaminationTranslation('WRITTEN_TEST'),
				itemId: 'writtenTestItemId',
				name:'writtenTest',
				defaults: {
					flex: 1
				},
				layout: 'hbox',
				disabled:true,
				items:[{ 
					boxLabel: getCommonTranslation('YES'), 
					name: 'whetherWrittenTest', 
					inputValue: true,
					checked:true
				},{ 
					boxLabel: getCommonTranslation('NO'), 
					name: 'whetherWrittenTest', 
					inputValue: false
				}]
			},{
				/**
				 * This field is hidden as discussed with pushpendra sir and set by default to to false
				 */
				xtype      : 'radiogroup',
				fieldLabel : getExaminationTranslation('SURPRISE_TEST'),
				itemId: 'surpriseTestItemId',
				name:'surpriseTest',
				hidden:true,
				defaults: {
					flex: 1
				},
				layout: 'hbox',
				items:[{ 
					boxLabel: getCommonTranslation('YES'), 
					name: 'whetherSurpriseTest', 
					inputValue: true
				},{ 
					boxLabel: getCommonTranslation('NO'), 
					name: 'whetherSurpriseTest', 
					inputValue: false,
					checked:true
				}]}]
		},{
			xtype: 'fieldcontainer',
			width: 'auto',
			hidden:true,
			layout: {
				type: 'hbox'
			},
			defaults: {
				labelAlign: 'top',
				width:226
			},
			items: [{
				xtype : 'datefield',
				anchor : '100%',
				fieldLabel : getExaminationTranslation('PLANNED_TILL'),
				name : 'plannedTill',
				//--submitFormat : CONSTANTS.SUBMIT_DATE_FORMAT,
//				value:new Date(),
				hidden:true,
				listeners: {
					render: function(obj) {
						obj = dateFormatRender(obj);						
						obj.setValue(new Date());
					}
				}
			}]

		},{
			xtype: 'fieldcontainer',
			width: 'auto',
			layout: {
				type: 'hbox'
			},
			hidden:true,
			defaults: {
				labelAlign: 'top',
				width:226
			},
			layout: 'hbox',
			items:[{
				/**
				 * this field is set by default to true and disabled 
				 */
				xtype      : 'radiogroup',
				fieldLabel : getExaminationTranslation('MANDATORY_FOR_EVALUATION'),
				itemId: 'mandatoryForEvaluationItemId',
				name:'evaluationMandatory',
				disabled:true,
				defaults: {
					flex: 1
				},
				layout: 'hbox',
				items:[{ 
					boxLabel: getCommonTranslation('YES'), 
					name: 'mandatoryForEvaluation', 
					inputValue: true,
					checked:true
				},{ 
					boxLabel: getCommonTranslation('NO'), 
					name: 'mandatoryForEvaluation', 
					inputValue: false
				}]},{
					/**
					 * this field is set by default to true and disabled 
					 */
					xtype      : 'radiogroup',
					fieldLabel : getExaminationTranslation('ATTENDANCE_TO_BE_MARKED'),
					itemId: 'attendanceMandatoryId',
					name:'attendanceMandatory',
					disabled:true,
					defaults: {
						flex: 1
					},
					layout: 'hbox',
					items:[{ 
						boxLabel: getCommonTranslation('YES'), 
						name: 'mandatoryForAttendance', 
						inputValue: true,
						checked:true
					},{ 
						boxLabel: getCommonTranslation('NO'), 
						name: 'mandatoryForAttendance', 
						inputValue: false
					}]

				}]
		},{
			xtype: 'fieldcontainer',
			width: 'auto',
			hidden:true,
			layout: {
				type: 'hbox'
			},
			defaults: {
				labelAlign: 'top',
				width:226
			},
			items: [{
				/**
				 * as written test is set by default to false and disabled ,So, on the bases these fields are hidden
				 * "objectiveType,answerPaperAvailable,revaluationType,modeOfAdministration,evaluationAnonymous,timeInMinutes,
				 * noOfQPRequired,rndmSlctnAplcble,resultExceptionToTime,exceptionRuleAgendaDescription"
				 */
				xtype: 'numberfield',
				name: 'noOfQPRequired',
				itemId:'noOfAssessment1',
				fieldLabel:getExaminationTranslation('NO_OF_QUES_PAPER_SETS_REQUIRED'),
				minValue : 0,
				hidden:true
				// allowBlank: false
			}]

		}, {
			xtype: 'fieldcontainer',
			width: 'auto',
			hidden:true,
			layout: {
				type: 'hbox'
			},
			defaults: {
				labelAlign: 'top',
				width:226
			},
			layout: 'hbox',
			items:[{
				/**
				 * as written test is set by default to false and disabled ,So, on the bases these fields are hidden
				 * "objectiveType,answerPaperAvailable,revaluationType,modeOfAdministration,evaluationAnonymous,timeInMinutes,
				 * noOfQPRequired,rndmSlctnAplcble,resultExceptionToTime,exceptionRuleAgendaDescription"
				 */
				xtype      : 'radiogroup',
				fieldLabel : getExaminationTranslation('OBJECTIVE_TYPE'),
				itemId: 'isAttendanceRelevantId2',
				name:'objectiveType',
				hidden:true,
				defaults: {
					flex: 1
				},
				layout: 'hbox',
				items:[{ 
					boxLabel: getExaminationTranslation('OBJECTIVE'), 
					name: 'whetherObjectTypeQuestions', 
					inputValue: true
				},{ 
					boxLabel: getExaminationTranslation('MIXED'),
					name: 'whetherObjectTypeQuestions', 
					inputValue: false,
					checked:true
				}]},{
					/**
					 * as written test is set by default to false and disabled ,So, on the bases these fields are hidden
					 * "objectiveType,answerPaperAvailable,revaluationType,modeOfAdministration,evaluationAnonymous,timeInMinutes,
					 * noOfQPRequired,rndmSlctnAplcble,resultExceptionToTime,exceptionRuleAgendaDescription"
					 */
					xtype      : 'radiogroup',
					fieldLabel : getExaminationTranslation('RAMDOM_SELECTION_OF_QUESTION'),
					itemId: 'whetherPassesCriticalId3',
					name:'rndmSlctnAplcble',
					defaults: {
						flex: 1
					},
					layout: 'hbox',
					hidden:true,
					items:[{ 
						boxLabel: getCommonTranslation('YES'), 
						name: 'randomSelectionApplicable', 
						inputValue: true
					},{ 
						boxLabel: getCommonTranslation('NO'), 
						name: 'randomSelectionApplicable', 
						inputValue: false,
						checked:true
					}]

				}]
		},{
			xtype: 'fieldcontainer',
			width: 'auto',
			hidden:true,
			layout: {
				type: 'hbox'
			},
			defaults: {
				labelAlign: 'top',
				width:226
			},
			layout: 'hbox',
			items:[{
				/***
				 * This field hidden permanently as per discussion and set default to false
				 */
				xtype      : 'radiogroup',
				fieldLabel : getExaminationTranslation('GROUPS'),
				name:'groups',
				itemId:'groupsID',
				hidden:true,
				defaults: {
					flex: 1
				},
				layout: 'hbox',
				items:[{ 
					boxLabel: getCommonTranslation('YES'), 
					name: 'whetherBatches', 
					inputValue: true
				},{ 
					boxLabel: getCommonTranslation('NO'), 
					name: 'whetherBatches', 
					inputValue: false,
					checked:true
				}]},{
					/***
					 * This field hidden permanently as per discussion and set default to false
					 */
					xtype      : 'radiogroup',
					fieldLabel : getExaminationTranslation('LIMITED_SET_OF_STUDENTS'),
					name:'limitedSetOfStudents',
					itemId:'limitedSetOfStudents',
					hidden:true,
					defaults: {
						flex: 1
					},
					layout: 'hbox',
					items:[{ 
						boxLabel: getCommonTranslation('YES'), 
						name: 'whetherLimitedSetOfStudent', 
						inputValue: true
					},{ 
						boxLabel: getCommonTranslation('NO'), 
						name: 'whetherLimitedSetOfStudent', 
						inputValue: false,
						checked:true
					}]
				}]
		},{
			xtype: 'fieldcontainer',
			width: 'auto',
			hidden:true,
			layout: {
				type: 'hbox'
			},
			defaults: {
				labelAlign: 'top',
				width:226
			},
			layout: 'hbox',
			items:[{
				/**
				 * as written test is set by default to false and disabled ,So, on the bases these fields are hidden
				 * "objectiveType,answerPaperAvailable,revaluationType,modeOfAdministration,evaluationAnonymous,timeInMinutes,
				 * noOfQPRequired,rndmSlctnAplcble,resultExceptionToTime,exceptionRuleAgendaDescription"
				 */
				xtype      : 'radiogroup',
				fieldLabel : getExaminationTranslation('ANSWER_PAPER_AVAILABLE_FOR_REVIEW'),
				name:'answerPaperAvailable',
				itemId:'answerPaperAvailable',
				defaults: {
					flex: 1
				},
				layout: 'hbox',
				hidden:true,
				items:[{ 
					boxLabel: getCommonTranslation('YES'), 
					name: 'whetherAnsAvailableForReview', 
					inputValue: true
				},{ 
					boxLabel: getCommonTranslation('NO'), 
					name: 'whetherAnsAvailableForReview', 
					inputValue: false,
					checked:true
				}]}]
		},{
			xtype: 'fieldcontainer',
			width:'100%',
			hidden:true,
			layout: {
				type: 'hbox'
			},
			defaults :{
				width: 226,
				labelAlign:'top'
			},
			items: [ {
				/**
				 * as written test is set by default to false and disabled ,So, on the bases these fields are hidden
				 * "objectiveType,answerPaperAvailable,revaluationType,modeOfAdministration,evaluationAnonymous,timeInMinutes,
				 * noOfQPRequired,rndmSlctnAplcble,resultExceptionToTime,exceptionRuleAgendaDescription"
				 */
				xtype: 'customcombobox',
				store:'examinationcenters.evaluation.evaluationPlanHeirarchy.RevaluationType',
				name: 'revaluationType',
				itemId:'revaluationType',
				fieldLabel:getExaminationTranslation('REVALUATION_TYPE'),
				displayField:'value',
				valueField:'id',
				typeAhead:true,
				minChars:3,
				hidden:true
			}, {
				xtype: 'customcombobox',
				store:'examinationcenters.evaluation.evaluationPlanHeirarchy.NotificationType',
				name: 'notificationType',
				itemId:'notificationType',
				fieldLabel:getExaminationTranslation('NOTIFICATION_TYPE'),
				displayField:'value',
				valueField:'id',
				forceSelection:true,
				typeAhead:true,
				minChars:3
				//allowBlank: false
			}]
		},

			{
			xtype: 'fieldcontainer',
			width:'100%',
			//hidden:true,
			layout: {
				type: 'hbox'
			},
			defaults :{
				width: 226,
				labelAlign:'top'
			},
			items: [ {
				xtype: 'numberfield',
				name: 'notificationNoOfDays',
				itemId:'notificationNoOfDays',
				fieldLabel:getExaminationTranslation('NOTIFICATION_NO_OF_DAYS'),
				minValue : 0,
				maxValue:365,
				//value:1,
				allowBlank:true,
				enableKeyEvents:true,
				listeners: {
					change: function(cmp, nval) {
						if(!Ext.isEmpty(nval)) {
							this.up('form').isValid();
						}
					},
        			keyup:function(opt){
        				var val = opt.rawValue;
        				var form = opt.up().up('form');
        				if(val.toString().match(/[+-]/)){
        					opt.up().up('form').isValid();
        				}else if(!form.form.wasValid){
        					opt.up().up('form').isValid();
        				}
        			}
				}
			}]
		},{
			xtype: 'fieldcontainer',
			width: 'auto',
			hidden:true,
			layout: {
				type: 'hbox'
			},
			defaults: {
				labelAlign: 'top',
				width:226
			},
			layout: 'hbox',
			items:[{
				xtype      : 'radiogroup',
				fieldLabel : getExaminationTranslation('RESULT_APPROVED'),
				itemId: 'resultApprovedId',
				name:'resultApproved',
				hidden:true,
				defaults: {
					flex: 1
				},
				layout: 'hbox',
				items:[{ 
					boxLabel: getCommonTranslation('YES'), 
					name: 'whetherResultApproved', 
					inputValue: true
				},{ 
					boxLabel: getCommonTranslation('NO'), 
					name: 'whetherResultApproved', 
					inputValue: false,
					checked:true
				}]},{
					xtype:'customcombobox',
					name:'approvedById',
					store:'common.UsersCodeComboStore',
					displayField:'value',
					valueField:'id',
					forceSelection:true,
					typeAhead:true,
					fieldLabel : getExaminationTranslation('RESULT_APPROVER_NAME'),
					allowBlank:true,
					hidden:true
				}]
		},{
			xtype: 'fieldcontainer',
			width: 'auto',
			hidden:true,
			layout: {
				type: 'hbox'
			},
			defaults: {
				labelAlign: 'top',
				width:226
			},
			layout: 'hbox',
			items:[{
				/**
				 * as written test is set by default to false and disabled ,So, on the bases these fields are hidden
				 * "objectiveType,answerPaperAvailable,revaluationType,modeOfAdministration,evaluationAnonymous,timeInMinutes,
				 * noOfQPRequired,rndmSlctnAplcble,resultExceptionToTime,exceptionRuleAgendaDescription"
				 */
				xtype:'numberfield',
				fieldLabel:getExaminationTranslation('TIME_IN_MIN'),
				name:'timeInMinutes',
				itemId:'timeInMin',
				hidden:true,
				minValue:0
			},{
				xtype      : 'timefield',
				fieldLabel : getExaminationTranslation('START_TIME_IN_HOUR_MIN'),
				increment: 1,
				itemId: 'resultApproverName',
				name:'starttime',
				hidden:true
			}]
		},{
			xtype: 'fieldcontainer',
			width: 'auto',
			hidden:true,
			layout: {
				type: 'hbox'
			},
			defaults: {
				labelAlign: 'top',
				width:226
			},
			layout: 'hbox',
			items:[{
				/**
				 * as written test is set by default to false and disabled ,So, on the bases these fields are hidden
				 * "objectiveType,answerPaperAvailable,revaluationType,modeOfAdministration,evaluationAnonymous,timeInMinutes,
				 * noOfQPRequired,rndmSlctnAplcble,resultExceptionToTime,exceptionRuleAgendaDescription"
				 */
				xtype      : 'radiogroup',
				fieldLabel : getExaminationTranslation('RESULTS_EXCEPTION_TO_TIME'),
				name:'resultExceptionToTime',
				itemId:'resultExceptionToTimeItemId',
				disabled:true,
				defaults: {
					flex: 1
				},
				layout: 'hbox',
				items:[{ 
					boxLabel: getCommonTranslation('YES'), 
					name: 'whetherExceptionToTime', 
					inputValue: true
				},{ 
					boxLabel: getCommonTranslation('NO'), 
					name: 'whetherExceptionToTime', 
					inputValue: false,
					checked:true
				}]}]
		},{
			xtype: 'fieldcontainer',
			width:'100%',
			hidden:true,
			layout: {
				type: 'hbox'
			},
			defaults :{
				width: 226,
				labelAlign:'top'
			},
			items: [{
				xtype      : 'textfield',
				fieldLabel : getExaminationTranslation('RESULTS_EXCEPTION_RULE_AGENDA'),
				itemId: 'resultExceptionRuleAgenda',
				name:'exceptionRuleAgenda',
				hidden:true
			},{
				xtype: 'textfield',
				name: 'exceptionRuleAgendaDescription',
				itemId:'resultExceptionRuleAgendaDesc',
				fieldLabel:getExaminationTranslation('RESULTS_EXCEPTION_RULE_AGENGA_DESC'),
				maxvalue : 0,
				hidden:true
				// allowBlank: false
			}]
		},{
			xtype: 'fieldcontainer',
			width: 'auto',
			hidden:true,
			layout: {
				type: 'hbox'
			},
			defaults: {
				labelAlign: 'top',
				width:226
			},
			layout: 'hbox',
			items:[{
				xtype : 'datefield',
				anchor : '100%',
				fieldLabel : getExaminationTranslation('FEE_BILLING_DATE'),
				name : 'feeBillingDate',
				itemId : 'feeBillingDate',
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				},
				//--submitFormat : CONSTANTS.SUBMIT_DATE_FORMAT,
				vtype : 'daterange'
			}]
		},{
			xtype: 'fieldcontainer',
			width: 'auto',
			hidden:true,
			layout: {
				type: 'hbox'
			},
			defaults: {
				labelAlign: 'top',
				width:226
			},
			layout: 'hbox',
			items:[{
				/**
				 * This field is depend on other it implement further
				 */
				/*xtype      : 'customcombobox',
        fieldLabel : getExaminationTranslation('FEEDBACK_QUESTIONARIES'),
        store:'',
        itemId: 'feedbackQuestionaries',
        name:'feedbackQuestionnaire'
	},{*/
				xtype      : 'textfield',// didn,t find in model
				fieldLabel : getExaminationTranslation('FEEDBACK_QUESTIONARIES'),
				name:'feedbackQuestionnaire',
				value:'Depend on other Field',//TODO
				readOnly:true
			}]
		},{
			xtype: 'fieldcontainer',
			width: 'auto',
			hidden:true,
			layout: {
				type: 'hbox'
			},
			defaults: {
				labelAlign: 'top',
				width:226
			},
			layout: 'hbox',
			items:[{
				xtype      : 'radiogroup',
				fieldLabel : getExaminationTranslation('WHETHER_SHOWN_IN_MARKSHEET'),
				name:'showInMarksheet',
				itemId:'showInMarksheet',
				defaults: {
					flex: 1
				},
				layout: 'hbox',
				items:[{ 
					boxLabel: getCommonTranslation('YES'), 
					name: 'whetherShowInMarksheet', 
					inputValue: true
				},{ 
					boxLabel: getCommonTranslation('NO'), 
					name: 'whetherShowInMarksheet', 
					inputValue: false,
					checked:true
				}]
			}]
		},{
			layout: {
				type: 'hbox'
			},
			style:{
				marginLeft:'0px'
			},
			items: [{
				xtype: 'button',
				text: getExaminationTranslation('SAVE'),
				itemId: 'evaluationDetailFormAddButtonId',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE,
				formBind: true
			}, {
				xtype: 'button',
				text: getExaminationTranslation('CANCEL'),
				ui: 'CustomBtnCancel',
				scale: CONSTANTS.BUTTONSIZE,
				handler: function() {
					var form = this.up('form').getForm();
					var roundingMode=form.findField('roundingMode');
	            	var roundingCount=form.findField('roundingCount');
	            	var roundingCountVal = roundingCount.getValue();
	            	var roundingModeVal = roundingMode.getValue();
					var evalInMarksOrGrade = this.up('form').getValues()['evalInMarksOrGrade'];
					this.up('form').getForm().reset();
					this.up('form').down('#markGradeComboItemId').setValue(evalInMarksOrGrade);
					roundingMode.setValue(roundingModeVal);
	                roundingCount.setValue(roundingCountVal);
	                var copyMarksGradeEvent =form.findField('copyMarksGradeEvent');
    			    copyMarksGradeEvent.setDisabled(true);
				}
			}]
		}]
	}]
});
