/**
 * @author Anand Verma
 * @author Bhanu PS
 */
Ext.define('Academia.view.examinationcenters.examlogistic.ExamLogisticFilter', {
	extend: 'Ext.form.Panel',
    alias: 'widget.examlogisticfilter',
    autoScroll: false,   
    frame: false,
	cls:'customSearchPanel',
    plugins : "formlabelrequired",
    items: [{
            	xtype: 'fieldcontainer',
            	layout: 'hbox',
            	defaults: {
            		width: 226,
            		labelAlign: 'top'
            	},
            	items: [{
            		xtype: 'customcombobox',
            		name: 'evalGroup',
            		itemId:'evalGroupItemId',
            		fieldLabel: getExaminationTranslation('EVALUATION_GROUP'),
            		store: 'examinationcenters.examlogistic.EvaluationGroupStore',
            		displayField: 'value',
            		valueField: 'id',
            		allowBlank:false,
            		typeAhead: true,
            		queryParam:'textSearch',
          			minChars:3,
          			typeAhead:false,
          			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
          			enableKeyEvents  : 'true',
          			hideTrigger:false,
          			forceSelection:true,
          			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            		listConfig: {
          				listeners: {
        					beforeshow: function(picker) {
        						picker.minWidth = picker.up('combobox').getSize().width;
        					}
        				},
          				loadingText: getCommonTranslation('SEARCHING'),
          				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
          				getInnerTpl: function() {
          					return '<div class="search-item">' +
          					'{value}' +
          					'</div>';
          				}
          			}  
//            		disabled:true
            	},,{
            		xtype: 'customcombobox',
            		name: 'centerName',
            		itemId:'centerItemId',
            		store:'examinationcenters.examlogistic.ExamCenterStore',
            		displayField:'valueCode',
            		valueField:'id',
            		queryParam:'textSearch',
          			minChars:3,
          			typeAhead:false,
          			allowBlank:false,
          			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
          			enableKeyEvents  : 'true',
          			hideTrigger:false,
          			forceSelection:true,
          			disabled:true,
          			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            		fieldLabel:getExaminationTranslation('CENTER_NAME'),
            		listConfig: {
          				listeners: {
        					beforeshow: function(picker) {
        						picker.minWidth = picker.up('combobox').getSize().width;
        					}
        				},
          				loadingText: getCommonTranslation('SEARCHING'),
          				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
          				getInnerTpl: function() {
          					return '<div class="search-item">' +
          					'{valueCode}' +
          					'</div>';
          				}
          			}  
            	},{
        			xtype: 'customcombobox',
        			name: 'roomNo',
        			itemId:'roomItemId',
        			fieldLabel:getExaminationTranslation('ROOM_NO'),
        			store:'examinationcenters.examstaffallocation.commonFilter.FindAllRoomNo',
        			displayField:'value',
        			valueField:'id',
        			disabled:true,
        			queryParam:'textSearch',
          			minChars:3,
          			typeAhead:false,
          			allowBlank:false,
          			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
          			enableKeyEvents  : 'true',
          			hideTrigger:false,
          			forceSelection:true,
          			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
        			listConfig: {
          				listeners: {
        					beforeshow: function(picker) {
        						picker.minWidth = picker.up('combobox').getSize().width;
        					}
        				},
          				loadingText: getCommonTranslation('SEARCHING'),
          				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
          				getInnerTpl: function() {
          					return '<div class="search-item">' +
          					'{value}' +
          					'</div>';
          				}
          			}  
        		}]
            },{
    	xtype: 'fieldcontainer',
    	layout: 'hbox',
    	defaults: {
    		width: 226,
    		labelAlign: 'top'
    	},
    	items: [{
			xtype: 'customcombobox',
			name: 'date',
			itemId:'dateItemId',
			fieldLabel:getExaminationTranslation('DATE'),
			store:'examinationcenters.examlogistic.ExamDateStore',
			valueField: 'value',
  			displayField: 'dateValue',
  			queryParam:'textSearch',
  			disabled:true,
  			minChars:3,
  			allowBlank:false,
  			typeAhead:false,
  			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
  			enableKeyEvents  : 'true',
  			hideTrigger:false,
  			forceSelection:true,
  			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
  			listConfig: {
  				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
  				loadingText: getCommonTranslation('SEARCHING'),
  				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
  				getInnerTpl: function() {
  					return '<div class="search-item">' +
  					'{value}' +
  					'</div>';
  				}
  			}
		},{
			xtype: 'customcombobox',
			name: 'timeSlot',
			itemId:'timeSlotItemId',
			fieldLabel:getExaminationTranslation('TIME_SLOT'),
			store:'examinationcenters.examlogistic.ExamTimeSlotStore',
			valueField: 'id',
  			displayField: 'value',
  			queryParam:'textSearch',
  			minChars:3,
  			disabled:true,
  			allowBlank:false,
  			typeAhead:false,
  			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
  			enableKeyEvents  : 'true',
  			hideTrigger:false,
  			forceSelection:true,
  			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
  			listConfig: {
  				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
  				loadingText: getCommonTranslation('SEARCHING'),
  				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
  				getInnerTpl: function() {
  					return '<div class="search-item">' +
  					'{value}' +
  					'</div>';
  				}
  			}
		}]
    },{
	xtype:'fieldset',
	title: getTransportTranslation('MORE_FILTERS'),
	layout:'vbox',
	frame:true,	
	collapsible:true,
	collapsed:true,
	style:{marginTop: '33px!important',
	paddingTop:'25px!important'},  
	width:'100%',
	items: [{
            xtype: 'fieldcontainer',
            width: 'auto',
            layout: 'hbox',
            defaults: {
                width: 226,
                labelAlign: 'top'
            },
            items: [{
            	xtype: 'customcombobox',
      			name:'programId',
      			itemId:'programIdQuickFiltr',
      			store:'examinationcenters.reports.ExaminationReportProgramStore',
      			fieldLabel:getCommonTranslation('PROGRAM_CODE_OR_NAME'),
      			valueField: 'id',
      			disabled:true,
      			displayField: 'valueSecondValue',
      			queryParam:'name',
      			minChars:3,
//      			width:460,
      			typeAhead:false,
      			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
      			enableKeyEvents  : 'true',
      			hideTrigger:false,
      			forceSelection:true,
      			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
      			listConfig: {
      				listeners: {
    					beforeshow: function(picker) {
    						picker.minWidth = picker.up('combobox').getSize().width;
    					}
    				},
      				loadingText: getCommonTranslation('SEARCHING'),
      				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
      				getInnerTpl: function() {
      					return '<div class="search-item">' +
      					'{value}' +
      					'</div>';
      				}
      			}  
              },{
              		xtype: 'customcombobox',
              		name: 'batchId',
                 	itemId:'batchIdQuickFiltr',
        			store:'examinationcenters.reports.SpecialGradeBatchStore',
        			fieldLabel:getExaminationTranslation('BATCH'),
        			valueField: 'id',
        			displayField: 'value',
        			queryParam:'name',
        			minChars:3,
        			typeAhead:false,
        			disabled:true,
        			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
        			enableKeyEvents  : 'true',
        			hideTrigger:false,
        			forceSelection:true,
//        			hidden:true,
        			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
        			listConfig: {
        				listeners: {
      					beforeshow: function(picker) {
      						picker.minWidth = picker.up('combobox').getSize().width;
      					}
      				 },
        				loadingText: getCommonTranslation('SEARCHING'),
        				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
        				getInnerTpl: function() {
        					return '<div class="search-item">' +
        					'{value}' +
        					'</div>';
        				}
        			} 
              },{
              	xtype: 'customcombobox',
        		name: 'periodId',
        		itemId: 'periodItemId',
    			store:'program.programDetails.programBatches.courseParameter.ProgramCoursePeriod',
    			fieldLabel:getExaminationTranslation('PERIOD'),
    			valueField: 'id',
    			disabled:true,
    			displayField: 'value',
    			queryParam:'name',
    			minChars:3,
    			typeAhead:false,
    			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
    			enableKeyEvents  : 'true',
    			hideTrigger:false,
    			forceSelection:true,
//    			hidden:true,
    			
          }]
	},{
        xtype: 'fieldcontainer',
        width: 'auto',
        layout: 'hbox',
        defaults: {
            width: 226,
            labelAlign: 'top'
        },
        items: [{
        	xtype: 'customcombobox',
            name: 'section',
            itemId:'sectionItemId',
            store:'coursetransaction.sectionmanagement.SectionsStore',
            displayField:'value',
            valueField:'id',
            forceSelection:true,
            disabled:true,
        	queryParam:'name',
  			minChars:3,
  			typeAhead:false,
  			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
  			enableKeyEvents  : 'true',
  			hideTrigger:false,
  			forceSelection:true,
  			//emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            fieldLabel:getExaminationTranslation('SECTION'),
           /* listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				 },
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			} */
        },{
      	xtype: 'customcombobox',
		name: 'courseId',
		itemId: 'courseItemId',
		store:'examinationcenters.examlogistic.ExamCourseStore',
		fieldLabel:getCommonTranslation('COURSE_CODE_NAME'),
		valueField: 'id',
		displayField: 'value',
		disabled:true,
		queryParam:'textSearch',
		minChars:3,
		typeAhead:false,
//		width:460,
		triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
		enableKeyEvents  : 'true',
		hideTrigger:false,
		forceSelection:true,
//		hidden:true,
		emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
		listConfig: {
			listeners: {
				beforeshow: function(picker) {
					picker.minWidth = picker.up('combobox').getSize().width;
				}
			 },
			loadingText: getCommonTranslation('SEARCHING'),
			emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
			getInnerTpl: function() {
				return '<div class="search-item">' +
				'{value}' +
				'</div>';
			}
		} 
     },{
     	xtype: 'customcombobox',
        name: 'courseVariant',
        itemId:'courseVariantItemId',
        store:'examinationcenters.examlogistic.ExamCourseVariantStore',
        valueField: 'id',
//        allowBlank:false,
		displayField: 'value',
		fieldLabel:getExaminationTranslation('COURSE_VARIANT'),
		queryParam:'textSearch',
		minChars:3,
		typeAhead:false,
		disabled:true,
		triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
		enableKeyEvents  : 'true',
		hideTrigger:false,
		forceSelection:true,
		emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
		listConfig: {
			listeners: {
				beforeshow: function(picker) {
					picker.minWidth = picker.up('combobox').getSize().width;
				}
			 },
			loadingText: getCommonTranslation('SEARCHING'),
			emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
			getInnerTpl: function() {
				return '<div class="search-item">' +
				'{value}' +
				'</div>';
			}
		}
    }]
    }],
    	listeners:{
    		render: function(myfieldset){
    			myfieldset.setMargin('-10px');
    		}
    	}
	},{
		xtype: 'fieldcontainer',
		width: 'auto',
		items: [{
			xtype: 'button',
			text: getCommonTranslation('SEARCH'),
			itemId: 'searchBtn',
			buttonAlign: 'left',
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE,
			formBind:true
		},{
			xtype: 'button',
			text: getCommonTranslation('RESET'),
			itemId: 'resetBtn',
			// buttonAlign: 'left',
			ui: 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE   
		},{
            xtype: 'button',
            text: getExaminationTranslation('GENERATE_REPORT'),
            itemId:'generateReport',
            ui: 'CustomBtnThird',
            scale: CONSTANTS.BUTTONSIZE,
            formBind:true
		}]	
	}]
});