/**
 * @author sumit.meena
 */
Ext.define('Academia.view.examinationcenters.marksheet.MarksheetGenerationGrid', {
    //extend: 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport', 
	alias: 'widget.marksheetgenerationgrid',
    store : 'examinationcenters.marksheet.MarksheetGenerationStore',
    border: true,
    autoScroll: false,
    frame:false,
    title:getExaminationTranslation('JOB_LIST'),
    viewConfig: {
        stripeRows: true
    },
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
		        xtype: 'custompagingtoolbar',
	            plugins:['pagesize'],
	            store : 'examinationcenters.marksheet.MarksheetGenerationStore',
			    emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			    displayInfo : true
		}]
	}],
	initComponent: function() {

        var grid=this;                   

        grid.addExportToolBarItems(grid);

        this.callParent(arguments);     

 },
    tbar: [{
    	xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getExaminationTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH
	},{
		xtype: 'button',
		itemId: 'btnEdit',
		tooltip: getExaminationTranslation('EDIT'),
		glyph: ICONGLYPH.EDITGLYPH
	},{
		xtype: 'button',
		itemId: 'btnView',
		tooltip: getExaminationTranslation('VIEW'),
		iconCls: 'view-icon'
	},{
		xtype: 'button',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip: getExaminationTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH
	},{	
		xtype : 'splitbutton',
        itemId:'spBtnMoreActions',
        text : getCommonTranslation('MOREACTIONS'),
        menu:[{
            text:getExaminationTranslation('MAP_STUDENTS'),
            itemId:'mapStudentItemId'
        },{
            text:getExaminationTranslation('GENARATE_AND_DOWNLOAD_MARKSHEET'),
            itemId:'generateNDownloadItemId'
        }],
        listeners: { click: function() { this.showMenu(); } }
    }],
    columns: [{
		  	header : getExaminationTranslation('JOB_ID'),
		  	dataIndex : 'jobId',
		  	flex:1
       },{
            header : getExaminationTranslation('JOB_NAME'),
	        dataIndex : 'marksheetJob',
	        flex:1
       },{
           header : getExaminationTranslation('JOB_STATUS'),
	        dataIndex : 'jobStatus',
	        flex:1,
	        renderer: function(value){
	        	return capitaliseEnumValue(value);
	        }
       }]
});
