''/**
 * @author Amit G
 */
Ext.define('Academia.view.examinationcenters.questionPaperBank.VWExmQuestionTemplateFilter', {
	extend: 'Ext.form.Panel',
	alias: 'widget.vwexmquestiontemplatefilter',
	autoScroll: false,
	frame: false,
	cls:'customSearchPanel',
	plugins : "formlabelrequired",
	items: [{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			width: 226,
			labelAlign: 'top'
		},
		items: [{
			xtype : 'customcombobox',
			fieldLabel : getCommonTranslation('ACADEMIC_TERM'),		
			name : 'academicTerm',
			itemId : 'academicTermId',
			displayField : 'value',
			valueField : 'id',
			width: 226,
			typeAhead : true,
			forceSelection : true,
			listeners  :{
				render : function(combo){
					var store=Ext.create('Academia.store.common.AcademicTermStore');
					combo.bindStore(store)
				}
			}
		},{
			xtype: 'customcombobox',
			name: 'department',
			itemId:'courseDepartment',
			fieldLabel: getCommonTranslation('COURSE_DEPARTMENT'),
			store:Ext.create('Academia.store.department.DepartmentAcademyLocationWiseStore'),
//			editable: true,
			valueField: 'id',
			displayField: 'value',
			queryParam:'name',
			minChars:3,
			typeAhead:false,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code}' +
					'</div>';
				}
			}
		},{
			xtype: 'customcombobox',
			name:'courseId',
			itemId:'courseItemId',
			store:Ext.create('Academia.store.attendance.CoursesForVariantMapping'),
			fieldLabel: getCommonTranslation('COURSE_CODE_NAME'),
			valueField: 'id',
			displayField: 'value',
			queryParam:'courseName',
			minChars:3,
			typeAhead:false,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code}' +
					'</div>';
				}
			}
		}]
	},{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			labelAlign: 'top',
			width: 226
		},
		items: [{
			xtype: 'customcombobox',
			name:'evaluationplanno',
			itemId:'evalautionPlanId',
			store:Ext.create('Academia.store.examinationcenters.evaluation.EvaluationPlanByCriteria'),
			fieldLabel:getExaminationTranslation('EVALUATION_PLAN'),
			valueField: 'id',
			displayField: 'value',
			queryParam:'evaluationPlanNumber',
			minChars:3,
			typeAhead:false,
			queryMode: 'local',
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
		},{
			xtype: 'customcombobox',
			name: 'detailSequence',
			itemId:'detailSequenceItemId',
			store:Ext.create('Academia.store.examinationcenters.manageEvaluation.EvaluationEventByEvalPlan'),
			displayField:'value',
			valueField:'id',
			editable:false,
			queryMode: 'local',
			fieldLabel:getExaminationTranslation('DETAILED_SEQUENCE'),
			//allowBlank: false,
			disabled:true
		}] 
	}, {
		xtype: 'fieldcontainer',
		width: 'auto',
		items: [{
			xtype: 'button',
			text: getExaminationTranslation('SEARCH'),
			itemId: 'searchBtn',
			buttonAlign: 'left',
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE
		},{
			xtype: 'button',
			text: getCommonTranslation('RESET'),
			itemId: 'resetBtn',
			ui: 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE   
		}]	
	}]
});
