/**
 * @author Bhartendu Bhaskar
 */
Ext.define('Academia.view.examinationcenters.remark.uploaddownload.AssignRemarkUploadForm', {
	extend:'Academia.view.common.DynamicFieldForm',
    alias: 'widget.assignremarkuploadform',
    autoScroll: false,
    frame: false,
    standardSubmit: false,
    defaults: {
        width: 226,
        labelAlign: 'top'
    },
    items: [{
		xtype:'uploadoptionradiogroup',
		width: 300,
        margin: 0,
		itemId:'assignremarkUploadOptionRadioGroupItemId',
    }, {
    	xtype: 'fieldcontainer',
    	layout: 'hbox',
    	width: '100%',
    	items: [{
    		xtype: 'customcombobox',
    		name: 'importUtilityMasterId',
    		itemId: 'moduleName',
    		store: 'importutility.ModuleName',
    		fieldLabel: getCommonTranslation('TEMPLATE_NAME'),
    		valueField: 'id',
    		displayField: 'value',
    		typeAhead: true,
    		forceSelection: true,
    		allowBlank: false,
    		width: 226,
            labelAlign: 'top'
    	}, {
			xtype:'checkbox',
			boxLabel: getCommonTranslation('IMPORT_EVEDENCE_IMG'),
			name:'importImageCheck',
			itemId:'importImageCheck',
			inputValue:true,
			uncheckedValue:false,
			margin: '26 0 0 8'
		}]
    }, {
        xtype: 'filefield',
        ui: 'CustomBtnThird',
        width: 460,
        fieldLabel: getCommonTranslation('UPLOAD_FILE'),
        buttonText: getCommonTranslation('BROWSE_FILE'),
        itemId: 'uploadFileField',
        name: 'file',
        allowBlank: false,
        validateOnChange: true,
        listeners: {
            change: function(fileField, value) {
                value = value.replace('C:\\fakepath\\', '');
                var newValue = value.replace(/ +/g, " ").split(' ').join('_');
                fileField.setRawValue(newValue);
                if (!isNullOrEmpty(newValue)) {
                    var extension = newValue.substring(newValue.lastIndexOf('.') + 1).toLowerCase();
                    var baseController = Academia.getApplication().getController('Academia.controller.base.BaseController');
                    if (!baseController.isValidFileExtensionForLoader(extension)) {
                        fileField.reset();
                        showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('BDU_PLEASE_UPLOAD_CSV_FILE'));
                    }
                }
            }
        }
    }, {
        xtype: 'filefield',
        ui: 'CustomBtnThird',
        width: 460,
        fieldLabel: getCommonTranslation('BDU_UPLOAD_ZIP_FILE'),
        buttonText: getCommonTranslation('BROWSE_FILE'),
        itemId: 'uploadZipFileField',
        name: 'zipFile',
        allowBlank: false,
        validateOnChange: true,
        hidden: true,
        disabled: true,
        listeners: {
            change: function(fileField, value) {
            	value = value.replace('C:\\fakepath\\', '');
                var newValue = value.replace(/ +/g, " ").split(' ').join('_');
                fileField.setRawValue(newValue);
                if (!isNullOrEmpty(newValue)) {
                    var extension = newValue.substring(newValue.lastIndexOf('.') + 1).toLowerCase();
                    if (!isNullOrEmpty(extension) && extension.toLowerCase() == 'zip') {
                        var file = fileField.fileInputEl.dom.files[0];
                    } else {
                        fileField.reset();
                        showWarningMessage(getCommonTranslation('BDU_UPLOAD_ZIP_FILE'), getCommonTranslation('BDU_PLEASE_UPLOAD_ZIP_FILE'));
                    }
                }
            }
        }
    }, {
        xtype: 'fieldcontainer',
        width: 'auto',
        items: [{
            xtype: 'button',
            action: 'Submit',
            text: getTranslation('UPLOAD_DATA'),
            formBind: true,
            itemId: 'uploadAssignRemarkUploadFormItemId',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE
        }, {
            xtype: 'button',
            text: getCommonTranslation('RESET'),
            ui: 'CustomBtnCancel',
            itemId: 'resetBtnAssignRemarkUploadFormItemId',
            scale: CONSTANTS.BUTTONSIZE
        }]
    }]
});