/**
 * @author sumit.meena
 */
Ext.define('Academia.view.examinationcenters.repetitioncompletion.RepetitionCompletionFilter', {
	extend: 'Ext.form.Panel',
    alias: 'widget.repetitioncompletionfilter',
    autoScroll: false,
    frame: false,
	cls:'customSearchPanel',
    plugins : "formlabelrequired",
    items: [{
	        xtype: 'fieldcontainer',
        	layout: 'hbox',
        	defaults: {
        		width: 226,
        		labelAlign: 'top'
        	},
            	items: [{
            		xtype: 'customcombobox',
            		name: 'evalGroupId',
            		itemId:'evalGroupItemId',
            		store:'examinationcenters.repetitioncompletion.RnCEvaluationGroup',
            		displayField:'code',
            		valueField:'id',
            		forceSelection:true,
            		typeAhead:true,
            		minChars:3,
            		fieldLabel:getExaminationTranslation('EVALUATION_GROUP')
            	},{
            		/*xtype: 'customcombobox',
            		name: 'courseId',
            		itemId:'courseItemId',
            		store:'examinationcenters.roomallocation.RoomAllocationCourses',
            		displayField:'value',
            		valueField:'id',
            		width:460,
            		forceSelection:true,
            		typeAhead:true,
            		minChars:3,
            		fieldLabel:getExaminationTranslation('COURSE'),
            		disabled:true*/
            		
            		xtype: 'customcombobox',
         			name:'courseId',
         			itemId:'courseItemId',
         			store: 'examinationcenters.roomallocation.RoomAllocationCourses',
         			fieldLabel: getCommonTranslation('COURSE_CODE_NAME'),
         			valueField: 'id',
         			displayField: 'value',
         			queryParam:'name',
         			minChars:3,
         			typeAhead:false,
         			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
         			enableKeyEvents  : 'true',
         			hideTrigger:false,
         			forceSelection:true,
         			disabled:true,
         			width:460,
         			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
         			listConfig: {
         				listeners: {
        					beforeshow: function(picker) {
        						picker.minWidth = picker.up('combobox').getSize().width;
        					}
        				},
         				loadingText: getCommonTranslation('SEARCHING'),
         				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
         				getInnerTpl: function() {
         					return '<div class="search-item">' +
         					'{value}' +
         					'</div>';
         				}
         			}
            		
            	}]
        },{
    	xtype: 'fieldcontainer',
    	layout: 'hbox',
    	defaults: {
    		width: 226,
    		labelAlign: 'top'
    	},
    	items: [{
    		xtype: 'customcombobox',
    		name: 'componentId',
    		itemId:'componentItemId',
    	    store:'course.courseequivalence.CourseComponentEquivalenceStore',
    		displayField:'value',
    		valueField:'id',
    		forceSelection:true,
    		typeAhead:true,
    		minChars:3,
    		fieldLabel:getExaminationTranslation('COURSE_COMPONENT'),
    		disabled:true
    	},{
    		xtype: 'multiselectcombofield',
			name: 'courseVariantId',
			itemId:'courseVariantItemId',
			store:'examinationcenters.repetitioncompletion.RnCCoureVariantByCourseIds',
			fieldLabel: getExaminationTranslation('COURSE_VARIANT'),
			displayField:'value',
			valueField:'id',
			width: 460,
			typeAhead:true,
			forceSelection:true,
			autoloadStore: false,
			disabled:true,
			cls:'multiBrandCampusCls'
    	}]
    },{
    	xtype: 'fieldcontainer',
    	layout: 'hbox',
    	defaults: {
    		width: 226,
    		labelAlign: 'top'
    	},
    	items: [{
    		
    		xtype: 'customcombobox',
 			name:'programId',
 			itemId:'programItemId',
 			store:'examinationcenters.repetitioncompletion.RnCProgramsByCourseNComponent',
 			fieldLabel:getExaminationTranslation('PROGRAM'),
 			valueField: 'programName',
 			displayField: 'programId',
 			queryParam:'programNameValue',
 			minChars:3,
 			width:460,
 			typeAhead:false,
 			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
 			enableKeyEvents  : 'true',
 			hideTrigger:false,
 			forceSelection:true,
 			//allowBlank:false,
 			//hidden:true,
 			disabled:true,
 			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
 			listConfig: {
 				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
 				loadingText: getCommonTranslation('SEARCHING'),
 				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
 				getInnerTpl: function() {
 					return '<div class="search-item">' +
 					'{programName}' +
 					'</div>';
 				}
 			}  
    		/*
    		xtype: 'customcombobox',
    		name: 'programId',
    		itemId:'programItemId',
    		store:'examinationcenters.repetitioncompletion.RnCProgramsByCourseNComponent',
    		displayField:'programName',
    		valueField:'programId',
    		width:460,
    		forceSelection:true,
    		typeAhead:true,
    		minChars:3,
    		fieldLabel:getExaminationTranslation('PROGRAM'),
    		disabled:true*/
    	}]
    },{
    	xtype: 'fieldcontainer',
    	layout: 'hbox',
    	defaults: {
    		width: 226,
    		labelAlign: 'top'
    	},
    	items: [{
    		xtype: 'multiselectcombofield',
			name: 'batchId',
			itemId:'batchItemId',
			store:'common.BatchesByProgramId',
			fieldLabel: getExaminationTranslation('BATCH'),
			displayField:'value',
			valueField:'id',
			width: 460,
			typeAhead:true,
			forceSelection:true,
			autoloadStore: false,
			disabled:true,
			cls:'multiBrandCampusCls'
    	}]
    },{
    	xtype: 'fieldcontainer',
    	layout: 'hbox',
    	defaults: {
    		width: 226,
    		labelAlign: 'top'
    	},
    	items: [{
    		xtype: 'multiselectcombofield',
			name: 'sectionId',
			store:'coursetransaction.sectionmanagement.SectionMultiSelect',
			fieldLabel: getExaminationTranslation('SECTION'),
			displayField:'value',
			valueField:'id',
			width: 460,
			typeAhead:true,
			forceSelection:true,
			autoloadStore: false,
			disabled:true,
			cls:'multiBrandCampusCls'
    	}]
    },{
    	xtype: 'fieldcontainer',
    	layout: 'hbox',
    	defaults: {
    		width: 226,
    		labelAlign: 'top'
    	},
    	items: [{
    		xtype: 'customcombobox',
    		name: 'courseCompletionStatus',
    		itemId:'courseCompletionStatusId',
    	    store:'examinationcenters.repetitioncompletion.CourseCompletionStatus',
    		displayField:'value',
    		valueField:'id',
    		forceSelection:true,
    		typeAhead:true,
    		fieldLabel:getExaminationTranslation('COURSE_COMPLETION_STATUS')
    	},{
    		xtype: 'customcombobox',
    		name: 'evalSeqId',
    		store:'examinationcenters.evaluationgroup.detailsequencecovered.EvalGroupDetailSequenceConflicts',
    		displayField:'code',
    		valueField:'id',
    		forceSelection:true,
    		typeAhead:true,
    		minChars:3,
    		fieldLabel:getExaminationTranslation('EVALUATION_SEQUENCE'),
    		disabled:true,
    		maxLength: 1076,
    	}]
    	 },{
    	xtype: 'fieldcontainer',
    	layout: 'hbox',
    	defaults: {
    		width: 226,
    		labelAlign: 'top'
    	},
    	items: [{
    		xtype: 'customcombobox',
    		name: 'repetitionFor',
    		fieldLabel: getExaminationTranslation('REPETITION_FOR'),
    		store: 'examinationcenters.repetitioncompletion.RepetitionFor',
    		displayField: 'value',
    		valueField: 'id',
    		typeAhead: true	            
    	},{
    		xtype: 'customcombobox',
    		name: 'repetitionType',
    		fieldLabel: getExaminationTranslation('REPETITION_TYPE'),
    		store: 'examinationcenters.repetitioncompletion.RepetitionType',
    		displayField: 'value',
    		valueField: 'id',
    		typeAhead: true	            
    	},{
    		xtype: 'customcombobox',
    		name: 'repetitionCompletion',
    		fieldLabel: getExaminationTranslation('REPETITION_COMPLETION_STATUS'),
    		store: 'feeandpayment.feerequest.ApprovalStatus',
    		displayField: 'value',
    		valueField: 'id',
    		hidden:true,
    		typeAhead: true	            
    	}]
    },{
		xtype: 'fieldcontainer',
		width: 'auto',
		
		items: [{
			xtype: 'button',
			text: getCommonTranslation('SEARCH'),
			itemId: 'searchBtn',
			buttonAlign: 'left',
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE,
			formBind:true
		},{
			xtype: 'button',
			text: getCommonTranslation('RESET'),
			itemId: 'resetBtn',
			ui: 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE   
		}]	
	}]
});
