/**
 * @author Deepak.Nigam
 */
Ext.define('Academia.view.examinationcenters.roomallocation.ExamTimeTableQuickFilter', {
	extend : 'Ext.form.FormPanel',
	alias: 'widget.examtimetablequickfilter',
	autoScroll: false,
	frame: false,
	//cls:'customSearchPanel',
	method : 'POST',
	standardSubmit : false,
	items:[{
		xtype: 'fieldcontainer',
		itemId:'evalCoursePanelId',
		layout: 'hbox',
		defaults: {
			width: 226,
			labelAlign: 'top'
		},
		items: [{
			xtype: 'customcombobox',
			name: 'evalGroup',
			itemId: 'evalGroupId',
			fieldLabel:getExaminationTranslation('EVALUATION_GROUP'),
			store:'examinationcenters.reports.EvaluationGroupStore',
			valueField: 'id',
  			displayField: 'value',
  			queryParam:'textSearch',
  			allowBlank:false,
  			minChars:3,
  			typeAhead:false,
  			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
  			enableKeyEvents  : 'true',
  			hideTrigger:false,
  			forceSelection:true,
  			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
  			listConfig: {
  				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
  				loadingText: getCommonTranslation('SEARCHING'),
  				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
  				getInnerTpl: function() {
  					return '<div class="search-item">' +
  					'{value}' +
  					'</div>';
  				}
  			}  
		}]
	},{
    	xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            width: 226,
            labelAlign: 'top'
        },
        items: [{
            	xtype: 'customcombobox',
                name: 'studentProgram',
                itemId: 'studentProgramId',
                fieldLabel: getCommonTranslation('PROGRAM_CODE_OR_NAME'),
                store:'servicerequest.programcoursesectiontransfer.FindAllBatchsWithOutCurrentCheck',
                valueField: 'programId',
                displayField: 'programCodeValue',               
                typeAhead:true,
            	forceSelection:true,
				queryParam:'name',
				minChars:3,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
						loadingText: getCommonTranslation('SEARCHING'),
						emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
						getInnerTpl: function() {
							return '<div class="search-item">' +
							'{value}' +
							'</div>';
						},
						listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
							}
						},
					}
           },{
        	   xtype: 'customcombobox',
        	   name: 'studentBatch',
        	   itemId: 'studentBatchId',
        	   store:'servicerequest.programcoursesectiontransfer.FindAllBatchsWithOutCurrentCheck',
        	   valueField: 'batchId',
        	   displayField: 'batchName',
        	   queryMode: 'local',
        	   editable: false,
        	   fieldLabel: getExaminationTranslation('BATCH')	
            }]
    },{
		xtype: 'fieldcontainer',
		width:'100%',
		cls:'windowBtnPos',
		items: [{
			xtype: 'button',
			itemId:'searchBtn',
			text: getCommonTranslation('SEARCH'),
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE,
			formBind:true
		},{
			xtype: 'button',
			text: getCommonTranslation('RESET'),
			itemId:'resetBtn',
			ui: 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE
		}]
	}]
});