/**
 * @author sumit.meena
 */
Ext.define('Academia.view.examinationcenters.roomallocation.RoomAllocationRoomCapacityGrid', {
  //  extend: 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias: 'widget.roomallocationroomcapacitygrid',
    store : 'examinationcenters.roomallocation.RoomAllocationRoomCapacity',
    border: true,
    autoScroll: false,
    title:getExaminationTranslation('ROOM_CAPACITY_LIST'),
    frame:false,
    viewConfig: {
        stripeRows: true
    },
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
		        xtype: 'custompagingtoolbar',
	            plugins:['pagesize'],
	            store : 'examinationcenters.roomallocation.RoomAllocationRoomCapacity',
			    emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			    displayInfo : true
		}]
	}],
	initComponent: function() {
        var grid=this;                   
        grid.addExportToolBarItems(grid);
        this.callParent(arguments);     
 },
    tbar: [{
    	xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getExaminationTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH
	},{
		xtype: 'button',
		itemId: 'btnEdit',
		tooltip: getExaminationTranslation('EDIT'),
		glyph: ICONGLYPH.EDITGLYPH
	},{
		xtype: 'button',
		itemId: 'btnView',
		tooltip: getExaminationTranslation('VIEW'),
		iconCls: 'view-icon'
	},{
		xtype: 'button',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip: getExaminationTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH
	}],
    columns: [{
		  	header : getExaminationTranslation('CENTER_TYPE'),
		  	dataIndex : 'centerType',
		  	flex:1,
		  	 renderer:function(value){

				 if(value=='EXTERNAL'){
					 return 'External';  
				 }else{
					 return 'Internal';
				 }
			 }
       },{
            header : getExaminationTranslation('CENTER_NAME'),
	        dataIndex : 'centerName',
	        flex:1
       },{
           header : getExaminationTranslation('DATE'),
	        dataIndex : 'scheduleDate',
	        flex:1,
			renderer:function(date) {
				return dateRender(date);
			}
       },{
           header : getExaminationTranslation('TIME_SLOT'),
	        dataIndex : 'groupScheduleBatch',
	        flex:1,
	        renderer:function(value, record){
	        	return timeRender(value);
	        }
       },{
           header : getExaminationTranslation('ROOM_LOCATION'),
	        dataIndex : 'roomLocation',
	        flex:1
       },{
           header : getExaminationTranslation('ROOM_NO'),
	       dataIndex : 'roomNo',
	       flex:1
       },{
           header : getExaminationTranslation('ROOM_CAPACITY'),
	       dataIndex : 'roomCapacity',
	       flex:1
       },{
           header : getExaminationTranslation('BALANCE'),
	       dataIndex : 'balance',
	       flex:1
	   },{
           header : getExaminationTranslation('BOOKED'),
	       dataIndex : 'booked',
	       flex:1
		}]
});