/**
 * @author Rajkumar.Patidar
 */

Ext.define('Academia.view.examinationcenters.roomallocation.studentallocation.AssignInvigilatorWin',{
	extend: 'Ext.window.Window',
	alias: 'widget.assigninvigilatorwin',
	title:getExaminationTranslation('ASSIGN_INVIGILATOR'),
	frame: true,
	autoScroll:true,
	modal:true,
	method: 'POST',
	items: [{
		xtype: 'form',
		itemId:'assigninvigilatorform',
		plugins : "formlabelrequired",
		layout: {
			type: 'vbox'
		},
		defaults: {
			labelAlign: 'top',
			width:226
		},
		standardSubmit: false,
		items: [{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			width:'auto',
			defaults: {
				labelAlign: 'top',
				width: 226,
				xtype:'displayfield'
			},
			items: [{
				name: 'centerName',
				fieldLabel:getExaminationTranslation('CENTER_NAME'),
				labelAlign: 'top'
			},{
				name: 'date',
				fieldLabel:getExaminationTranslation('DATE'),
				labelAlign: 'top'
			},{
				name: 'timeSlot',
				fieldLabel: getExaminationTranslation('TIME_SLOT'),
				labelAlign: 'top'
			}]
		},{
			xtype: 'customcombobox',
    		name: 'invigilatorName',
			fieldLabel:getExaminationTranslation('INVIGILATOR'),
			store:'examinationcenters.roomallocation.RoomAllocationAssignInvigilator',
			valueField: 'id',
			displayField: 'value',
			queryParam:'name',
			minChars:3,
			typeAhead:false,
			forceSelection:true,
            allowBlank: false,
            triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
            enableKeyEvents  : 'true',
            hideTrigger:false,
            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            triggerAction: '',
		    listConfig: {
		    	listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
                loadingText: getCommonTranslation('SEARCHING'),
                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                getInnerTpl: function() {
                    return '<div class="search-item">' +
                        '{value}' +
                    '</div>';
                }
            }
		},{
			  xtype:'fieldcontainer',
        	  width:'auto',
			  items: [{
			    	 xtype: 'button',
					 action: 'Submit',
					 text: getFeeAndPaymentCommonTranslation('SAVE'),
					 formBind: true,
					 itemId: 'submitBtn',
					 ui: 'CustomBtnSubmit',
					 scale: CONSTANTS.BUTTONSIZE
			      },{
					 xtype: 'button',
					 text: getFeeAndPaymentCommonTranslation('CANCEL'),
					 ui: 'CustomBtnCancel',
					 itemId: 'CancelBtn',
					 scale: CONSTANTS.BUTTONSIZE
			      }]
	       }]
		}]	
});