Ext.define('Academia.view.examinationcenters.thesisManagement.ThesisManagementStatusGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.thesismanagementstatusgrid',
	store : 'examinationcenters.thesisManagement.ThesisManagementStatusGridStore',
	title:getProgramandcourseTranslation('THESIS_STATUS'),
	border: true,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	dockedItems : [ {
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
		      xtype: 'custompagingtoolbar',
	            plugins:['pagesize'],
			store : 'examinationcenters.thesisManagement.ThesisManagementStatusGridStore',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		} ]
	}
	],
	/*initComponent: function() {
        var grid=this;                   
        grid.addExportToolBarItems(grid);
        this.callParent(arguments);     
 },*/
 columns : [{
		header : getCommonTranslation('THESIS_STATUS'),
		dataIndex : 'thesisStatus',
		flex : 1,
		sortable: true
	}, {
		header : getCommonTranslation('DATE'),
		dataIndex : 'statusDate',
		flex : 1,
		sortable: true,
		renderer:function(date,value) {
			if(date!=null&&!isNullOrEmpty(date)){
			return dateFormatRender(date);
			}
			else{
				return "-";
			}
		}
	}, {
		header : getCommonTranslation('ACTION_PERFORMED_BY'),
		dataIndex : 'actionPerformedBy',
		flex : 1,
		sortable: true
	}, {
		header : getCommonTranslation('REMARKS'),
		dataIndex : 'remarks',
		flex : 1,
		sortable: true,
		renderer:function(val,rec,record,rowIndex,colIndex,store,view){
			if(!isNullOrEmpty(val)){
				rec.tdAttr = 'data-qtip="' + Ext.htmlEncode(val) + '"';
			}
			//rec.tdAttr = 'data-qtip="' + Ext.htmlEncode(val) + '"';
			rec.style = 'text-align: left;overflow: hidden;display: -webkit-box;-webkit-line-clamp: 4;-webkit-box-orient: vertical;line-height: 15px;max-height: 103px;min-width: 16ch;max-width: 17ch;';
			return val;
		}
	},
	 {
		header : getProgramandcourseTranslation('ACCESS_MODE'),
		dataIndex : 'accessMode',
		flex : 1,
		sortable: true
	},
	 {
		header : getCommonTranslation('DATE'),
		dataIndex : 'accessModeDate',
		flex : 1,
		sortable: true,
		renderer:function(date,value) {
			if(date!=null&&!isNullOrEmpty(date)){
			return dateFormatRender(date);
			}
			else{
				return "-";
			}
		}
	},
	 {
		header : getCommonTranslation('DOCUMENTS'),
		dataIndex : 'document',
		flex : 1,
		sortable: true,
		 renderer: function(value, meta, record) {
	        	
	        		 if (!isNullOrEmpty(record.raw.acceptedDocCount) && record.raw.acceptedDocCount > 0) {
	     	        	return "<a href='#'>"+"View Details"+"</a>";
	     	       }else{
	     	    	   return "-"; 
	     	       }
	            	}
	            
	}
	]
});
