/**
 *  @author Harshit Satya
 */

Ext.define('Academia.view.facilitiesresources.resourcebooking.ResourceBookingAlumniAvailableGrid', {
    extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias: 'widget.resourcebookingalumniavailablegrid',
    store: 'facilitiesresources.resourcebooking.ResourceBookingAlumniAvailableStore',
    title: getAlumni('ALUMNI_AVAILABLE'),
    //padding: '0 4 0 0',
    selType:'checkboxmodel',
	selModel: {
		mode:'MULTI',
		showHeaderCheckbox: true,
		allowDeselect: true,
		checkOnly : true,
	},
//	style: {
//	    borderBottom: '1px solid #D3D3D3 !important',
//	    borderBottomRadius: "5px"
//	},
	autoScroll: false,
	overflow: 'auto',
	cls:"alumniRSBMappingGrid",
    border: true,
    scrollable: 'y',   
    overflowX: 'hidden',
    listeners: {
        afterrender: function (grid) {
            grid.getView().on('viewready', function (view) {
                // Listen for the store load event
                grid.getStore().on('load', function (store, records, successful) {
                    if (successful) {
                        var gridBody = grid.getView().getEl();
                        if (gridBody) {
                            var gridBodyHeight = gridBody.dom.scrollHeight; // Ensure DOM element is ready
                            var maxHeight = 500; // Maximum height for the grid

                            if (gridBodyHeight > maxHeight) {
                                grid.setHeight(maxHeight); // Set max height if content exceeds
                                grid.body.setStyle('overflow-y', 'auto'); // Enable vertical scroll
                            } else {
                                grid.setHeight(maxHeight);
                            }
                        }
                    }
                });
            });
        }
	},
    refreshStoreData: true,
    isGridConfigurable: true, 
    enableColumnHide: false,
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS,
    },
    headerFix: {
    	headerFix: true,
    	portalIdsWithStructure: {
			'resourcebookingalumniavailablestructure':1
		}
    },
    dockedItems: [{
        xtype: 'toolbar',
        dock: 'bottom',
        items: [{
            xtype: 'custompagingtoolbar',
            plugins: ['pagesize'],
            store: 'facilitiesresources.resourcebooking.ResourceBookingAlumniAvailableStore',
            emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
            displayInfo: true,
        }]
    }],
    initComponent: function () {
        var grid = this;
        grid.addExportToolBarItems(grid, false);
        this.callParent(arguments);
    },
    columns: [{
        header: getAlumni('ALUMNI_ID'), //Alumni ID
        dataIndex: 'alumniUser',
        flex: .2
    },{
        header: getAlumni('NAME'), //Alumni Name
        dataIndex: 'alumniPrintName',
        flex: .2,
    },
    {
        header: getAlumni('ACADEMY_LOCATION'), //Alumni AcademyLocationName
        dataIndex: 'academyLocationName',
        flex: .2
    }, 
    {
        header: getAlumni('PROGRAM'), //Alumni Program
        dataIndex: 'programName',
        flex: .2
    },
    {
        header: getAlumni('BATCH'), //Alumni Batch
        dataIndex: 'batchName',
        flex: .2
    }]
});
