/**
 *  @author Harshit Satya
 * 
 */
Ext.define('Academia.view.facilitiesresources.resourcebooking.ResourceBookingAlumniMappedFilter',{
	extend: 'Ext.form.Panel',
	alias : 'widget.resourcebookingalumnimappedfilter',
	autoScroll: false,
	bodyPadding:'10 10 10 11',
	frame:false,
	cls:'customSearchPanel rbAlumniAvailablefilter',
	plugins:"formlabelrequired",
	style:{
		marginLeft:CONSTANTS.MARGIN_LEFT_FOR_FORM
	},
	defaults: {
		labelAlign: 'top',
	},
	items:[{
        xtype: 'fieldcontainer',
        width : '100%',
		layout: {
			type : 'hbox'
		},
		defaults: {
			width: 226,
			labelAlign: 'top'
		},		
        items: [{
            xtype: 'customcombobox',
            fieldLabel: getAlumni('ACADEMY_LOCATION'),
            name: 'cmbAcademyLocation',
            itemId: 'cmbAcademyLocation',
            store: Ext.create('Academia.store.alumni.alumniList.AlumniALStore'),
            valueField: 'id',
            displayField: 'value',
    		matchFieldWidth : false,
    		listConfig : {
    			width:260
    		},
            editable: false,
//            queryMode: 'local',
            triggerAcation: 'all',
            fourceSelection: true,
            autoScroll:false,
            labelAlign: "top",
            listConfig: {
				listeners: {
                    beforeshow: function (picker) {
                        picker.minWidth = picker.up('combobox').getSize().width;
                        picker.maxWidth = picker.up('combobox').getSize().width;
                    }
                },
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
        },{
            xtype: 'customcombobox',
            fieldLabel: getAlumni('PROGRAM_NAME'),
            name: 'cmbAlumniProgram',
            itemId: 'cmbAlumniProgram',
            store: Ext.create("Academia.store.common.ProgramStore"),
            valueField: 'id',
            displayField: 'value',
            disabled: true,
    		matchFieldWidth : false,
    		listConfig : {
    			width:260
    		},
            editable: false,
//            queryMode: 'local',
            triggerAcation: 'all',
            fourceSelection: true,
            labelAlign: "top",
            listConfig: {
				listeners: {
                    beforeshow: function (picker) {
                        picker.minWidth = picker.up('combobox').getSize().width;
                        picker.maxWidth = picker.up('combobox').getSize().width;
                    }
                },
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
        },{
            xtype: 'customcombobox',
            fieldLabel: getAlumni('BATCH'),
            name: 'cmbAlumniBatch',
            itemId: 'cmbAlumniBatch',
            store: Ext.create('Academia.store.alumni.alumniList.AlumniBatchStore'),
            valueField: 'id',
            displayField: 'value',
            disabled: true,
    		matchFieldWidth : false,
    		listConfig : {
    			width:260
    		},
            editable: false,
//            queryMode: 'local',
            triggerAcation: 'all',
            fourceSelection: true,
            labelAlign: "top",
            listConfig: {
				listeners: {
                    beforeshow: function (picker) {
                        picker.minWidth = picker.up('combobox').getSize().width;
                        picker.maxWidth = picker.up('combobox').getSize().width;
                    }
                },
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
        }],			
    	},{
    		xtype: 'fieldcontainer',    
    		layout: {
    			type : 'hbox'
    		},
    		defaults: {
    			width: 226,
    			labelAlign: 'top'
    		},	
    		items: [{
                xtype: 'customcombobox',
                fieldLabel: getAlumni('ALUMNI_NAME'),
                name: 'cmbAlumniName',
                itemId: 'alumniNameItemId',
                minChars:3,
                triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
                forceSelection:true,
                valueField: 'alumniUserId',
                displayField: 'alumniName',
                store: 'facilitiesresources.resourcebooking.AlumniResourceListStore',
                emptyText: getCommonTranslation('PLACE_HOLDER_EMPTY_TEXT'), //Alumni Name
                queryParam:"searchText",
                listConfig: {
                	listeners: {
    					beforeshow: function(picker) {
    						picker.minWidth = picker.up('combobox').getSize().width;
    					}
    				},
    				loadingText: getCommonTranslation('SEARCHING'),
    				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    			}
            }]		
    	},{
    		xtype: 'fieldcontainer',    
    		layout : {
    			type : 'hbox'
    		},
    		width:'auto',
    		items : [{
    			xtype : 'button',
    			text : getCommonTranslation("SEARCH") ,
    			name : 'submitBtn',
    			itemId : 'submitBtn',
    			ui : 'CustomBtnSubmit',
    			scale : CONSTANTS.BUTTONSIZE,
//    			formBind : true
    		},{
    			xtype: 'button',
    			itemId: 'btnResetItemId',
    			name: 'btnReset',
    			text: getCommonTranslation("RESET"),
    			ui:'CustomBtnCancel',
    			scale: CONSTANTS.BUTTONSIZE,
    		}] 	
    	}]
});

