Ext.define('Academia.view.facilitiesresources.resourcemaster.OtherAcademyLocationGrid',{
	extend:'Ext.grid.Panel',
	alias:'widget.otheracadloc',
	border:true,
	store:'facilitiesresources.resourcemaster.OtherAcademyLocationStore',
	resourceAcademyLocationPrograms: null,
	courses: null,
	columns:[{ 
		header:getCommonTranslation('ACADLOCTT'),
		dataIndex:'name',
		flex:1
	},{
		header:getCommonTranslation('PROGRAM_ACCESS'),
		dataIndex:'isProgramsRestricted',
		itemId:'isProgramsRestricted',
		flex:1,
		renderer:function(val){
			if(val){
				return "Restricted access";
			}else{
				return "All Programs access";
			} 
		}			
	},{
		header:getCommonTranslation('COURSE_ACCESS'),
		dataIndex:'isCoursesRestricted',
		itemId:'isCoursesRestricted',
		flex:1,
		renderer:function(val){
			if(val){
				return "Restricted access";
			}else{
				return "All Courses access";
			}			 
		}
	}],
	dockedItems : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'facilitiesresources.resourcemaster.OtherAcademyLocationStore',
			dock : 'bottom',
			emptyMsg : getCommonTranslation('EMPTY_OTHER_ACADEMY_LOCATION_MESSAGE'),  //No other academy locations to display
			displayInfo : true		
	}],
	tbar:[{
		xtype:'customcombobox',
		itemId:'othAcadLocCombo',
		store:'facilitiesresources.resourcemaster.OtherAcademyLocationComboStore',
		displayField:'value',
		valueField:'id',		
		fieldLabel:getCommonTranslation('ACADEMY_LOCATION'),
		editable:false,		
		queryMode:'local',
		triggerAction: 'all',
		forceSelection: false,
		emptyText:getCommonTranslation('SELECT_ACADEMY_LOCATION')
	},{
		xtype:'button',
		itemId:'othAcadLocAddButton',
		text:getCommonTranslation('ADD')
	},{
		xtype:'button',
		itemId:'othAcadLocDeleteButton',
		text:getCommonTranslation('DELETE')
	},{
		xtype:'splitbutton',
		itemId:'restrictionSplitButton',
		text:getCommonTranslation('MOREACTIONS'),
		menu:[{
			text:getCommonTranslation('VIEW_PROGRAMS'),
			itemId:'menuViewProgram'
		},{
			text:getCommonTranslation('VIEW_COURSES'),
			itemId:'menuViewCourses'
		},{
			text:getCommonTranslation('CHANGE_PROGRAMS'),
			itemId:'menuChangeProgram'
		},{
			text:getCommonTranslation('CHANGE_COURSES'),
			itemId:'menuChangeCourses'
		}],
		listeners: { click: function() { this.showMenu(); } }
		
	}]
});