/**
 * kamlesh kumar chilhate
 * 
 */
Ext.define('Academia.view.facultyCourseInterest.FacultyInterestReportSearch', {   
	extend : 'Ext.form.FormPanel',
	alias : 'widget.facultyinterestreportsearch',  
	plugins : "formlabelrequired",
	autoScroll: true,
	frame: false,
	cls:'customSearchPanel',
	layout: 'vbox',
	method: 'POST',
	standardSubmit: false,
	items: [{
		xtype: 'fieldcontainer',
		width: 'auto',
		layout: 'hbox',
		defaults: {
			width: 226,
			labelAlign: 'top'
		},
		items: [{
    		    	 xtype: 'customcombobox',
    		    	 name: 'facultyId',
    		    	 itemId:'facultyNameItemId',
    		    	 store: 'coursetransaction.sectionmanagement.AssignClassTeacherSmartSearch',
    		    	 fieldLabel: getCommonTranslation('FACULTY_ID_OR_NAME'),
    		    	 valueField: 'id',
    		    	 displayField: 'value',
    		    	 queryParam:'nameOrCode',
    		    	 minChars:3,
    		    	 typeAhead:false,
    		    	 hideTrigger:true,
    		    	 emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
    		    	 triggerAction: '',
    		    	 forceSelection:true,
    		    	 listConfig: {
    		    		 listeners: {
    							beforeshow: function(picker) {
    								picker.minWidth = picker.up('combobox').getSize().width;
    							}
    						},
    		    		 loadingText: getCommonTranslation('SEARCHING'),
    		    		 emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    		    		 getInnerTpl: function() {
    		    			 return '<div class="search-item">' +
    		    			 '{value}' +
    		    			 '</div>';
    		    		 }
    		    	 }
    		     },{
    					xtype: 'customcombobox',
    					name: 'programCesm',
    					itemId: 'programCESMCodeId',
    					fieldLabel:getCommonTranslation('PROGRAM_CESM_CODE'),
    					autoloadStore: false,
    					store: Ext.create('Academia.store.common.ProgramCesmClassificationStore'),
    					//cls:'multiBrandCampusCls',
    					displayField : 'value',
    					valueField : 'id',
    					//allowBlank : false,
    					queryParam:'nameOrCode',
    					minChars:3,
    					typeAhead:true,
    					triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
    					enableKeyEvents  : 'true',
    					emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
    					hideTrigger:false,
    					forceSelection:true,
    					listConfig: {
    						listeners: {
    							beforeshow: function(picker) {
    								picker.minWidth = picker.up('combobox').getSize().width;
    							},/*
    							afterRender: function(combo){
    								combo.getStore().on("load", function(store, items){
    									if(items.length==0)
    										Ext.select('.x-boundlist-item').elements[0].hidden = true;
    									else
    										Ext.select('.x-boundlist-item').elements[0].hidden = false;
    								});
    							}*/
    						},
    						loadingText: getCommonTranslation('SEARCHING'),
    						emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    						getInnerTpl: function() {
    							return '<div class="search-item">' +
    							'{code}' +
    							'</div>';
    						}
    					}
    				},{
			xtype: 'multiselectcombofield',
			name: 'courseCesm',
			itemId: 'courseCESMCodeId',
			fieldLabel:getCommonTranslation('COURSE_CESM_CODE'),
			autoloadStore: false,
			store: Ext.create('Academia.store.course.CourseCESMCodeStoreFromCSM'),
			//cls:'multiBrandCampusCls',
			displayField : 'value',
			valueField : 'id',
			//allowBlank : false,
			queryParam:'nameOrCode',
			minChars:3,
			typeAhead:true,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					},/*
					afterRender: function(combo){
						combo.getStore().on("load", function(store, items){
							if(items.length==0)
								Ext.select('.x-boundlist-item').elements[0].hidden = true;
							else
								Ext.select('.x-boundlist-item').elements[0].hidden = false;
						});
					}*/
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code}' +
					'</div>';
				}
			}
		},{
			xtype: 'multiselectcombofield',
			name: 'courses',
			itemId: 'coursesId',
			fieldLabel:getCommonTranslation('COURSE'),
			autoloadStore: false,
			store: Ext.create('Academia.store.personinfo.common.course.CourseListExceptCurrentEquivalenceStore'),
			//cls:'multiBrandCampusCls',
			displayField : 'value',
			valueField : 'id',
			//allowBlank : false,
			queryParam:'courseName',
			minChars:3,
			typeAhead:true,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					},
					/*afterRender: function(combo){
						combo.getStore().on("load", function(store, items){
							if(items.length==0)
								Ext.select('.x-boundlist-item').elements[0].hidden = true;
							else
								Ext.select('.x-boundlist-item').elements[0].hidden = false;
						});
					}*/
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code}' +
					'</div>';
				}
			}
		}]
	},{
		xtype: 'fieldcontainer',
		width: 'auto',
		layout: 'hbox',
		defaults: {
			width: 226,
			labelAlign: 'top'
		},
		items: [{
						xtype : 'customcombobox',
						name: 'approvalStatus',
						itemId: 'approvalStatusId',
						fieldLabel: getCommonTranslation('APPROVAL_STATUS'),
						store: Ext.create('Ext.data.Store', {
				    fields: ['id', 'value'],
				    data : [
				        {"id":"Approved", "value":"Approved"},
				        {"id":"Pending", "value":"Pending"},
				        {"id":"Declined", "value":"Declined"}
				    ]
				}),
				value: "Pending",
						allowBlank:true,
						valueField: 'id',
						displayField: 'value',
						editable: false
					}]
	},{
		xtype: 'fieldcontainer',
		width: '100%',

		items: [{
			xtype: 'button',
			text: getCommonTranslation('SEARCH'),
			itemId: 'searchBtn',
			buttonAlign: 'left',
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE,
			formBind: true
		},{
			xtype: 'button',
			text: getCourseTxCommonTranslation('RESET'),
			itemId: 'resetBtn',
			buttonAlign: 'left',
			ui: 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE	        				
		}]
	}
	]
});
