/**
 * @author Abhishek Bais
 * 
 */
Ext.define('Academia.view.facultyPortal.attendance.CourseLevelPendingAttendanceReportSearch', {   
	extend : 'Ext.form.FormPanel',
	alias : 'widget.courselevelpendingattendancereportsearch',  
	plugins : "formlabelrequired",
	autoScroll: false,
	frame: false,
	cls:'customSearchPanel',
	layout: 'vbox',
	method: 'POST',
	standardSubmit: false,
	items: [{
		xtype : 'fieldcontainer',
		width: 'auto',
		defaults : {
			width : 226,
			labelAlign : 'top'
		},
		layout : {
			type : 'hbox'
		},
		items : [{
			xtype : 'customcombobox',
			name : 'academicTerm',
			itemId : 'academicTerm',
			fieldLabel : getCommonTranslation('ACADEMIC_TERM'),
			store :Ext.create('Academia.store.common.AcademicTermStore'),
			valueField : 'id',
			displayField : 'value',
			forceSelection:true,
			typeAhead:false,

		},{
			xtype : 'customcombobox',
			fieldLabel : getCourseTxCommonTranslation('COURSE_VARIANT'),
			name : 'courseVariant',
			itemId : 'courseVariantId',
			store:Ext.create('Academia.store.attendance.facultyportal.AttendanceCourseVariantStore'),
			displayField: 'courseVariantCode',
			valueField: 'id',
			triggerAction: 'all',
			queryParam:'name',
			minChars:3,
			width:460,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			forceSelection:true,
			typeAhead:false,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}'  +
					'</div>';
				}
			}


		}]
	},{
		xtype : 'fieldcontainer',
		width: 'auto',
		layout: 'hbox',
		defaults : {
			width : 226,
			labelAlign : 'top'
		},
		items : [{
			xtype : 'customcombobox',
			fieldLabel : getProgramandcourseTranslation('ATTENDANCE_STATUS'),
			width: 226,
			labelAlign: 'top',
			name : 'pendingAttendanceStatus',
			itemId : 'pendingAttendanceStatusId',
			store:Ext.create('Academia.store.attendance.PendingAttendanceStatusStore'),
			displayField : 'value',
			valueField : 'code',
			typeAhead : true,
			forceSelection : true
		},{
			xtype : 'datefield',
			fieldLabel : getProgramandcourseTranslation('START_DATE'),
			name : 'courseWiseStartDate',
			itemId:'courseWiseStartDate',
			endDateField : 'courseWiseEndDate',
			vtype : 'daterange',
			maxValue:new Date(),
			listeners: {
				render: function(field) {
					return dateFormatRender(field);
				}
			}
		},{
			xtype : 'datefield',
			fieldLabel :getProgramandcourseTranslation('END_DATE'),
			name : 'courseWiseEndDate',
			itemId : 'courseWiseEndDate',
			startDateField : 'courseWiseStartDate',
			vtype : 'daterange',
			maxValue:new Date(),
			listeners: {
				render: function(field) {
					return dateFormatRender(field);
				}
			}
		}]
	},{
		xtype: 'fieldcontainer',
		width: 'auto',
		layout : 'hbox',
		items: [{
			xtype: 'button',
			text: getCommonTranslation('SEARCH'),
			itemId: 'courseLevelSearchBtn',
			buttonAlign: 'left',
			ui: 'CustomBtnSubmit',
			formBind : true,
			scale: CONSTANTS.BUTTONSIZE
		},{
			xtype: 'button',
			text: getCourseTxCommonTranslation('RESET'),
			itemId: 'courseLevelResetBtn',
			buttonAlign: 'left',
			ui: 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE
		}]
	}]
});