/**
 * Akshay Sharma
 */
Ext.define('Academia.view.facultyPortal.attendance.OpenUpdateAttendanceStatusWindow', {
	extend: 'Ext.window.Window',
	alias : 'widget.openupdateattendancestatuswindow',	
	title:getProgramandcourseTranslation('UPDATE_ATTENDANCE'),
	frame: true,
	autoScroll:true,
	modal:true,
	method: 'POST',
	items: [{
		xtype: 'form',
		bodyPadding: '5 5 5 5',
		margin: 0,
		plugins : "formlabelrequired",
		layout: {
			type: 'vbox'
		},
		defaults: {
			labelAlign: 'top',
			width:'auto'
		},
		standardSubmit: false,
		items: [{
			xtype: 'hidden',
			name: 'id'
		},{
			xtype : 'fieldcontainer',
			layout : 'hbox',
			defaults : {
				labelAlign: 'left'
			},
			items:[{
				xtype:'displayfield',
				name : 'StudentCount',
				fieldLabel: getProgramandcourseTranslation('NO_OF_STUDENT_SELECTED')
			}]
		},{
			xtype : 'fieldcontainer',
			layout : 'hbox',
			defaults : {
				labelAlign: 'top',
				width:226
			},
			items:[{
   			 xtype: 'customcombobox',
			 fieldLabel:getProgramandcourseTranslation('ATTENDANCE_STATUS'),
			 itemId:'attendanceStatus',
			 name:'attendanceStatus',
			 store:'attendance.StudentAttendanceStatusStore',
			 valueField : 'id',
			 displayField : 'value',
			 queryMode:'local'
		 }]
		},{
			xtype : 'fieldcontainer',
			layout : 'hbox',
			defaults : {
				labelAlign: 'top',
				width:226
			},
			items:[{
				xtype : 'textarea',
				name: 'commentArea',
				fieldLabel: getProgramandcourseTranslation('REMARKS'),
				enforceMaxLength : true,
				maxLength:225
		}]
		},{	
			xtype : 'fieldcontainer',
			layout : 'hbox',
			defaults : {
				labelAlign: 'top'
			},
			items: [{
				xtype: 'button',
				action: 'Submit',
				text: getCourseTxCommonTranslation('SAVE'),
				formBind: true,
				itemId: 'submitBtn',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE
			},{
				xtype: 'button',
				text: getCourseTxCommonTranslation('CANCEL'),
				ui: 'CustomBtnCancel',
				itemId: 'cancelBtn',
				scale: CONSTANTS.BUTTONSIZE
			}]
		}]	
	}]     
});