/**
 * @author Bhartendu Bhaskar
 */
Ext.define('Academia.view.fdmanagement.FDManagementGrid', {
    extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias: 'widget.fdmanagementgrid',
    store: 'fdmanagement.FDManagementStore',
    title: getServiceRequestTranslation('FD_INWARD_REGISTER'),
    border: true,
	cls: 'gridColumnCls',
    frame: false,
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
    headerFix:{
		headerFix: true,
		portalIdsWithStructure: {
			'fdmanagementtabstructure':1
		}
	},
	isGridConfigurable: true,
	enableColumnHide: false,
    dockedItems: [{
        itemId: 'dockedItemsItemId',
        xtype: 'toolbar',
        dock: 'bottom',
        items: [{
            xtype: 'custompagingtoolbar',
            plugins: ['pagesize'],
            store: 'fdmanagement.FDManagementStore',
            emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
            displayInfo: true
        }]
    }],
    initComponent: function() {
        var grid = this;
        grid.addExportToolBarItems(grid);
        this.callParent(arguments);
    },
    tbar: [{
        xtype: 'button',
        itemId: 'btnAdd',
        tooltip: getCommonTranslation("ADD"),
        glyph: ICONGLYPH.ADDGLYPH
    }, {
        xtype: 'button',
        itemId: 'btnEdit',
        tooltip: getCommonTranslation("EDIT"),
        glyph: ICONGLYPH.EDITGLYPH
    }, {
        xtype: 'button',
        itemId: 'btnView',
        tooltip: getCommonTranslation("VIEW"),
        iconCls: 'view-icon'
    }, {
        xtype: 'button',
        itemId: 'btnDelete',
        cls: 'CustomToolbarBtnReject',
        tooltip: getCommonTranslation("DELETE"),
        glyph: ICONGLYPH.DELETEGLYPH
    },{
        xtype: 'splitbutton',
        itemId: 'spBtnMoreActions',
        text: getFeeAndPaymentCommonTranslation('MOREACTIONS'),
        menu: [{
            text: getServiceRequestTranslation('FD_UPDATE_STATUS'),
            itemId: 'btnUpdateStatusItemId',
        }],
        listeners: {
            click: function() {
                this.showMenu();
            }
        }
    }],
    columns: [{
        header: getServiceRequestTranslation('FD_ENTRY_TYPE'),
        tooltip: getServiceRequestTranslation('FD_ENTRY_TYPE'),
        dataIndex: 'entryType',
        flex: 1,
        sortable: true
    }, {
        header: getServiceRequestTranslation('FD_ITEM_CATEGORY'),
        tooltip:getServiceRequestTranslation('FD_ITEM_CATEGORY'),
        dataIndex: 'itemCategory',
        flex: 1,
        sortable: true,
        renderer: function(value, meta, record) {
            return value.value;
        }
    }, {
        header: getServiceRequestTranslation('FD_INWARD_NO'),
        tooltip:getServiceRequestTranslation('FD_INWARD_NO'),
        dataIndex: 'inwardNo',
        flex: 1,
        sortable: true,
    }, {
        header: getServiceRequestTranslation('FD_SENDER'),
        tooltip:getServiceRequestTranslation('FD_SENDER'),
        dataIndex: 'senderName',
        flex: 1,
        sortable: true,
    }, {
        header: getServiceRequestTranslation('FD_SENDER_CONTACT_NO'),
        tooltip:getServiceRequestTranslation('FD_SENDER_CONTACT_NO'),
        dataIndex: 'senderContactNo',
        flex: 1,
        sortable: true,
    }, {
        header: getServiceRequestTranslation('FD_RECEIVER'),
        tooltip:getServiceRequestTranslation('FD_RECEIVER'),
        dataIndex: 'receiver',
        flex: 1,
        sortable: true,
        renderer: function(value, meta, record) {
            return value.value;
        }
    }, {
        header: getServiceRequestTranslation('FD_RECEIVER_CONTACT_NO'),
        tooltip:getServiceRequestTranslation('FD_RECEIVER_CONTACT_NO'),
        dataIndex: 'receiverContactNo',
        flex: 1,
        sortable: true,
    }, {
        header: getServiceRequestTranslation('FD_DOCKET_NO'),
        tooltip:getServiceRequestTranslation('FD_DOCKET_NO'),
        dataIndex: 'fdItemDetails',
        flex: 1,
        sortable: true,
        renderer: function(value, meta, record) {
            if (!isNullOrEmpty(value)) {
                if (value.length == 1) {
                    return value[0].docketNo;
                } else if (value.length > 1) {
                    return "<a href='#'>" + value.length + "</a>";
                }
            }
            return '0';
        }
    }, {
        header: getServiceRequestTranslation('FD_RECEIVING_DATE'),
        tooltip:getServiceRequestTranslation('FD_RECEIVING_DATE'),
        dataIndex: 'deliveryDate',
        flex: 1,
        sortable: true,
        renderer: function(date) {
            return dateRender(date);
        }
    }, {
        header: getServiceRequestTranslation('FD_BILL_NO'),
        tooltip: getServiceRequestTranslation('FD_BILL_NO'),
        dataIndex: 'billNo',
        flex: 1,
        sortable: true
    }, {
        header: getServiceRequestTranslation('FD_BILL_AMOUNT'),
        tooltip:getServiceRequestTranslation('FD_BILL_AMOUNT'),
        dataIndex: 'billAmount',
        flex: 1,
        sortable: true
    }, {
        header: getServiceRequestTranslation('FD_ACK_STATUS'),
        tooltip:getServiceRequestTranslation('FD_ACK_STATUS'),
        dataIndex: 'acknowledgeStatus',
        flex: 1,
        sortable: true
    }, {
        header: getServiceRequestTranslation('FD_ACK_DATE'),
        tooltip:getServiceRequestTranslation('FD_ACK_DATE'),
        dataIndex: 'acknowledgmentDate',
        flex: 1,
        sortable: true,
        renderer: function(date) {
            return dateRender(date);
        }
    }, {
        header: getServiceRequestTranslation('FD_ATTACHMENTS'),
        tooltip:getServiceRequestTranslation('FD_ATTACHMENTS'),
        dataIndex: 'fdItemDocuments',
        flex: 1,
        sortable: true,
        renderer: function(value, meta, record) {
            if (!isNullOrEmpty(value)) {
                if (value.length > 0) {
                    return "<a href='#'>" + value.length + "</a>";
                }
            }
            return '0';
        }
    }, {
        header: getServiceRequestTranslation('FD_RECEIVER_REMARKS'),
        tooltip:getServiceRequestTranslation('FD_RECEIVER_REMARKS'),
        dataIndex: 'receiverRemarks',
        flex: 1,
        sortable: true,
        hidden: true
    }]
});