/**
 *  @author Pankaj Sisodiya
 */

Ext.define('Academia.view.feeandpayment.AlProgramBatchPeriodTypeGrid', {
	extend : 'Ext.grid.Panel',
	alias : 'widget.alProgramBatchPeriodTypeGrid',
	title : getCommonTranslation('PERIOD'),
	store: 'feeandpayment.ALProgramBatchPeriodTypeStore',
	selType:'checkboxmodel',
	selModel: {
		mode:'MULTI',
		showHeaderCheckbox: true,
		allowDeselect: true,
		checkOnly : true,
		renderer: function(value, metaData, record, rowIndex, colIndex, store, view) {
			var baseCSSPrefix = Ext.baseCSSPrefix;
			metaData.tdCls = baseCSSPrefix + 'grid-cell-special ' + baseCSSPrefix + 'grid-cell-row-checker';
			return '<div class="' + baseCSSPrefix + 'grid-row-checker">&#160;</div>';
		}
	},
	autoScroll: false,
	height:380,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS,
		loadMask: false
	},
	border: true,
	tbar: [{
		xtype: 'button',
		text: getCommonTranslation('SUBMITKYS'),
		itemId: 'submitFeeMappingPeriod',
		buttonAlign: 'left',
		scale: CONSTANTS.BUTTONSIZE
	},{
		xtype: 'button',
		text: getCommonTranslation('RESET'),
		itemId: 'resetBtnPeriod',
		scale: CONSTANTS.BUTTONSIZE
	},{
		xtype: 'customcombobox',
		name: 'academicTerm',
		itemId:'academicTerm',
		fieldLabel:getCommonTranslation('ACADEMIC_TERM') +': <span class="required" style="color:red"> *</span>',
		store:'feeandpayment.AllAcademicTermStore',
		valueField: 'id',
		displayField: 'value',
		triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
		enableKeyEvents  : 'true',
		queryParam:'query',
		queryMode: 'remote',
		width:420,
		labelWidth:140,
		labelSeparator:' ',
		allowBlank:false,
		matchFieldWidth :true,
		typeAhead : true,
		forceSelection:true,
		hideTrigger:false,
		triggerAction: '',
		minChars:3,
		emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
		listConfig: {
			listeners: {
				beforeshow: function(picker) {
					picker.minWidth = 260;
				}
			},
			loadingText: getCommonTranslation('SEARCHING'),
			emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
			getInnerTpl: function() {
				return '<div class="search-item">' +
				'{value}'  +
				'</div>';
			}
		}
	},{
		xtype: 'customcombobox',
		name: 'period',
		itemId:'period',
		fieldLabel:getCommonTranslation('PERIOD'),
		store: 'feeandpayment.AllPeriodStore',
		valueField: 'periodName',
		displayField: 'periodName',
		labelWidth:60,
		margin:'0 0 0 10',
		disabled:true,
		queryMode: 'local',
		width:380,
		matchFieldWidth :true,
		typeAhead:true,
			hideTrigger:false,	    
		triggerAction: 'all',
		minChars:3,
		emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
		listConfig: {
			listeners: {
				beforeshow: function(picker) {
					 picker.minWidth = 260;
				}
			},
			loadingText: getCommonTranslation('SEARCHING'),
			emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
			getInnerTpl: function() {
				return '<div class="search-item">' +
				'{value}'  +
				'</div>';
			}
		}
	}],
	columns: [{
		header : getCommonTranslation('ACADEMY_LOCATION'),
		dataIndex : 'academyLocationName',
		flex : 1	 
	},{
		header : getCommonTranslation('PROGRAM_CODE'),
		dataIndex : 'programCode',
		flex : 1 
	},{
		header : getCommonTranslation('PROGRAM'),
		dataIndex : 'programName',
		flex : 1	 
	},{
		header : getCommonTranslation('PROGRAM_BATCH'),
		dataIndex : 'batchName',
		flex : 1	 
	},{
		header : getCommonTranslation('SEAT_TYPE'),
		dataIndex : 'seatName',
		flex : 1	 
	},{
		header : getCommonTranslation('PERIOD'),
		dataIndex : 'periodName',
		flex : 1	 
	}]
});