/**
 * @author rajkumar.patidar
 */

Ext.define('Academia.view.feeandpayment.AssociateStudentStructureForProgram' ,{
	extend : 'Ext.form.FormPanel',
	alias : 'widget.associatestudentstructureforprogram',
	autoScroll: false,
	bodyStyle:{ margin:CONSTANTS.LEFT_MARGIN_FOR_SEARCH_PANEL} ,
	
	items:[{
		xtype:'panel',
		cls:'customSearchPanel',
		width:'100%',
		defaults: {
			labelAlign: 'top',
			width: 226
		},
		items:[{
			xtype:'fieldcontainer',
			layout:'hbox',
			width: '100%',
			defaults: {
				labelAlign: 'top',
				width: 226
			},
			items:[{
				xtype:'panel',
				cls: 'panelNoSpace',
				items:[{
					xtype: 'radiogroup',
					itemId:'associatestudentforprogram',
					labelAlign: 'top',
					fieldLabel: getFeeAndPaymentCommonTranslation('PROGRAM_FOR'),
					columns: 2,
					vertical: true,
					items: [{ boxLabel: getFeeAndPaymentCommonTranslation('STUDENT'), name: 'whetherProgram', inputValue: true,checked:true},
					        { boxLabel: getFeeAndPaymentCommonTranslation('APPLICANT'), name: 'whetherProgram', inputValue: false}
					]
				}]
			},{
				xtype:'panel',
				cls: 'panelNoSpace',
				width:'100%',
				defaults: {
					labelAlign: 'top',
					width: 226
				},
				items:[{
					xtype: 'customcombobox',
					name: 'student',
					itemId:'student',
					fieldLabel: getFeeAndPaymentCommonTranslation('STUDENT'),
					store: 'feeandpayment.managebill.Student',
					valueField: 'id',
					width:460,
					displayField: 'studentName',
					queryParam:'studentNameOrCode',
					triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
					enableKeyEvents  : 'true',
					minChars:3,
					forceSelection:true,
					typeAhead:false,
					emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
					triggerAction: '',
					hideTrigger:false,
					listConfig: {
						listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
							}
						},
						loadingText: getCommonTranslation('SEARCHING'),
						emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
						getInnerTpl: function() {
							return '<div class="search-item">' +
							'{studentCode}/{studentName}' +
							'</div>';
						}
					}
				},{
					xtype: 'customcombobox',
					name: 'applicant',
					itemId:'applicant',
					hidden:true,
					width:460,
					fieldLabel: getFeeAndPaymentCommonTranslation('APPLICANT'),
					store: 'feeandpayment.managebill.Applicant',
					valueField: 'id',
					displayField: 'printName',
					queryParam:'codeOrName',
					triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
					enableKeyEvents  : 'true',
					minChars:3,
					typeAhead:false,
					emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
					triggerAction: '',
					hideTrigger:false,
					listConfig: {
						listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
							}
						},
						loadingText: getCommonTranslation('SEARCHING'),
						emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
						getInnerTpl: function() {
							return '<div class="search-item">' +
							'{code}/{printName}' +
							'</div>';
						}
					}
				}]
			}]
		},{
			xtype: 'fieldcontainer',
			width: '100%',
			layout:'hbox',
			style:{marginLeft:'10px'},
			items: [{
				xtype: 'button',
				text: getCommonTranslation('SEARCH'),
				itemId: 'searchBtn',
				buttonAlign: 'left',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE               
			},{
				xtype: 'button',
				text: getCommonTranslation('RESET'),
				itemId: 'resetBtn',
				ui: 'CustomBtnCancel',
				scale: CONSTANTS.BUTTONSIZE   
			}]	
		}]
	},{
		xtype:'associatestudentprogramlistforstudent',
		width: '100%',
		itemId:'associatestudentprogramlistforstudent'
	},{
		xtype:'associatestudentprogramlistforapplicant',
		itemId:'associatestudentprogramlistforapplicant',
		hidden:true,
		width: '100%'
	}]
});
