/**
 *  @author Amit G
 */

Ext.define('Academia.view.feeandpayment.FnpPaymentPlanInstalmentConfigGrid', {
	extend : 'Ext.grid.Panel',
	alias : 'widget.fnppaymentplaninstalmentconfiggrid',
	store : 'feeandpayment.stoFnpPaymentPlanInstallmentConfig',
	collapsible: true,
	border: true,
	title:getFeeAndPaymentCommonTranslation('INSTALLMENT_CONFIGURATION'),
	cls: 'scheduleInstallmentGridCls',
	autoScroll: false,
	height:300,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	columns: [/*
	Kush-- Not to show id column
	{
		hidden:true,
		dataIndex:'id'
	},*/{
		header : getFeeAndPaymentCommonTranslation('INSTALLMENT_NO'),
		dataIndex:'sequence',
		align:'center',
		sortable: false,
		flex : .5	  
	},{
		header : getFeeAndPaymentCommonTranslation('INSTALMENT_TYPE'),
		dataIndex : 'amountType',
		sortable: false,
		flex : .5,
		editor : {
			xtype: 'customcombobox',
			name: 'instalmentType',
			itemId:'instalmentTypeItenId',
			store: 'feeandpayment.FeeAmount',
			valueField: 'id',
			displayField: 'value',
			width: 180,
			allowBlank: false,
			typeAhead:true,
			width: 180,
			forceSelection:true,
			listeners:{
				change : function(obj, newValue) {
					/*var grid = obj.up('grid');   commented due to new requirement V2D-312365
					if(newValue=="PERCENTAGE")
					{
						grid.columns[2].getEditor().disable(true);
					}else if(newValue=="FIXED_AMOUNT")
					{
						grid.columns[2].getEditor().enable(true);
					}*/
				}
			}
		},
		renderer:function(value,meta, records, temp){
			if(!isNullOrEmpty(value)) {
				
				if(value=="PERCENTAGE")    
				{
					if(records.data.amount>100){
						records.data.amount='';
					}
				}
				return getCommonTranslation(value);
			} else if(temp!=0){
				records.data.amountType = 'PERCENTAGE';
				return getCommonTranslation('PERCENTAGE');
			}
			else {
				meta.tdCls = 'gridInputCustomStyle'; 
				return getFeeAndPaymentCommonTranslation('CLICK_TO_ENTER');
			}  
		}
	},{ 
		header : getFeeAndPaymentCommonTranslation('AMOUNT_PERCENTAGE'),
		dataIndex : 'amount',
		sortable: false,
		flex : .5,	  
		editor : {
			xtype:'numberfield',
			name: 'amount',
			itemId:'amount',
			width: 180,
			mouseWheelEnabled:false,
			allowDecimals:true,
			regex: /[a-zA-Z0-9]+/,
			enforceMaxLength : true,
			minValue:1,
			width: 180,
			maxLength: 10,
			//disabled:true,
		},    
		renderer:function(value,meta,record, temp){
			if(!isNullOrEmpty(value)) {
				if(record.data.amountType == "FIXED_AMOUNT"){
					return currencyRenderer(value,record.get("currencyId"));
				}else{
					return value;
				}
			}/* else if(temp!=0){   commented due to new requirement V2D-312365
				return '';
			}*/
			else {
				//if(record.data.amountType == "FIXED_AMOUNT"){   commented due to new requirement V2D-312365
					meta.tdCls = 'gridInputCustomStyle'; 
					return getFeeAndPaymentCommonTranslation('CLICK_TO_ENTER');
				//}
			}                        
		} 
	},{ 
		header : getFeeAndPaymentCommonTranslation('PAYMENT_DATE'),
		dataIndex : 'paymentDate',
		sortable: false,
		flex : .5,
		editor: {
			xtype: 'datefield',
			name: 'paymentDate',
			itemId:'paymentDate',
			width: 180,
			//...........................
			minValue:new Date(),
			//...........................
			editable:true,
			//--submitFormat: CONSTANTS.DATE_FORMAT,
		       listeners: {
		    	   render: function(field) {
		    		   return dateFormatRender(field);
		    	   }
		    }
		},    
		renderer:function(value,meta){
			if(!isNullOrEmpty(value)) {
				return dateRender(value);
			} else {
				meta.tdCls = 'gridInputCustomStyle'; 
				return getFeeAndPaymentCommonTranslation('CLICK_TO_ENTER');
			}                        
		}
	},{ 
		header : getFeeAndPaymentCommonTranslation('PAYMENT_MODE'),
		dataIndex : 'schedulePaymentModes',
		sortable: false,
		flex : 1.5,	  
		editor : {
			xtype: 'multiselectcombofield',
			itemId: 'paymentMode',
			name: 'paymentMode',
			width: 135,
			labelAlign: 'top',
			store: 'feeandpayment.FeePaymentMode',
			valueField: 'id',
			displayField: 'value',
		    forceSelection:true
		},
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(value)) {
				var obj = [];
				if(!isNullOrEmpty(record.data.schedulePaymentModes.length) && !isNullOrEmpty(record.data.schedulePaymentModes[0])){
					for(var j=0;j<record.data.schedulePaymentModes.length;j++){
						var mode=record.data.schedulePaymentModes[j];
						if(!isNullOrEmpty(mode.feePaymentMode)){
							obj.push(mode.feePaymentMode.value);
						}else{
							obj.push(mode.data.value);
						}
					}	
					return obj;
				}else{
					meta.tdCls = 'gridInputCustomStyle'; 
					return getFeeAndPaymentCommonTranslation('CLICK_TO_ENTER'); 
				}	
				
			}else{
				meta.tdCls = 'gridInputCustomStyle'; 
				return getFeeAndPaymentCommonTranslation('CLICK_TO_ENTER'); 
			}	
		}
	}],
	plugins: {
		ptype : 'cellediting',
		clicksToEdit: 1
	},
	listeners: {
		beforeedit: function(editor, context) {
			if(editor.context.field=='amount'){
				if(!isNullOrEmpty(context.record.data.amountType)){
					context.grid.columns[3].getEditor().setReadOnly(false);
					context.grid.columns[2].getEditor().setReadOnly(false);
				}else{
					context.grid.columns[3].getEditor().setReadOnly(true);
					context.grid.columns[2].getEditor().setReadOnly(true);
					return context.colIdx !== 3;
				}
				
				if(context.record.data.sequence!=1){
			//		context.record.data=""
					//context.grid.columns[2].getEditor().setReadOnly(true);   commented due to new requirement V2D-312365
					//return context.colIdx !== 2;
				}else{
					//context.grid.columns[2].getEditor().setReadOnly(false);
				}
				
				if(!isNullOrEmpty(context.record.data.id)){/*------Commented due to new requirement--
					context.grid.columns[3].getEditor().setReadOnly(true);
					return context.colIdx !== 0;
				*/}else{
					context.grid.columns[3].getEditor().setReadOnly(false);
				}
				
				
			}/*--Commented due to new requirement ---------else if(editor.context.field=='amountType'){
				if(!isNullOrEmpty(context.record.data.id)){
					context.grid.columns[2].getEditor().setReadOnly(true);
					return context.colIdx !== 0;
				}else{
					context.grid.columns[2].getEditor().setReadOnly(false);
				}
			}*/
////////////////////
			
			if(editor.context.field=='amountType'){
				if(context.record.data.sequence!=1){
					context.grid.columns[1].getEditor().setReadOnly(true);
					return context.colIdx !== 1;
				}else{
					context.grid.columns[1].getEditor().setReadOnly(false);
				}
			}
			
/////////////////////			
			
			if(editor.context.field=='amountType' || editor.context.field=='amount' || editor.context.field=='paymentDate' || editor.context.field=='schedulePaymentModes'){
				/*if(context.record.raw.enrollmentStatus=="ENROLLED")
				{*/
				if(!isNullOrEmpty(context.record.raw.todaysDate)){
					if(context.record.data.paymentDate.length!=context.record.raw.todaysDate.length)
					{
						var localDate = context.record.data.paymentDate.toLocaleDateString().split('/');
						if(localDate[0].length==1)
						{
							localDate[0]=0+localDate[0];
						}
						if(localDate[1].length==1)
						{
							localDate[1]=0+localDate[1];
						}
						var date=localDate[2]+"-"+localDate[0]+"-"+localDate[1];
						if(date<=context.record.raw.todaysDate){
							context.grid.columns[1].getEditor().setReadOnly(true);
							context.grid.columns[2].getEditor().setReadOnly(true);
							context.grid.columns[3].getEditor().setReadOnly(true);
							context.grid.columns[4].getEditor().setReadOnly(true);
							if(editor.context.field=='amountType'){
								return context.colIdx !== 1;
							}else if(editor.context.field=='amount'){
								return context.colIdx !== 2;
							}else if(editor.context.field=='paymentDate'){
								return context.colIdx !== 3;
							}else if(editor.context.field=='schedulePaymentModes'){
								return context.colIdx !== 4;
							}
						}else if(date>=context.record.raw.todaysDate){
							context.grid.columns[1].getEditor().setReadOnly(false);
							context.grid.columns[2].getEditor().setReadOnly(false);
							context.grid.columns[3].getEditor().setReadOnly(false);
							context.grid.columns[4].getEditor().setReadOnly(false);
						}
					}else
					{
						if(context.record.data.paymentDate<=context.record.raw.todaysDate){
							context.grid.columns[1].getEditor().setReadOnly(true);
							context.grid.columns[2].getEditor().setReadOnly(true);
							context.grid.columns[3].getEditor().setReadOnly(true);
							context.grid.columns[4].getEditor().setReadOnly(true);
							if(editor.context.field=='amountType'){
								return context.colIdx !== 1;
							}else if(editor.context.field=='amount'){
								return context.colIdx !== 2;
							}else if(editor.context.field=='paymentDate'){
								return context.colIdx !== 3;
							}else if(editor.context.field=='schedulePaymentModes'){
								return context.colIdx !== 4;
							}
						}else if(context.record.data.paymentDate>=context.record.raw.todaysDate){
							context.grid.columns[1].getEditor().setReadOnly(false);
							context.grid.columns[2].getEditor().setReadOnly(false);
							context.grid.columns[3].getEditor().setReadOnly(false);
							context.grid.columns[4].getEditor().setReadOnly(false);
						}
					}	
				}
					
				//}
			}
		}

	}
});