/**
 * @author Amit G
 * This component is used for document List Grid
 */
Ext.define('Academia.view.feeandpayment.OtherPaymentPlanDocumentSubmittedGrid', {
    extend: 'Ext.grid.Panel',
    alias: 'widget.otherpaymentplandocumentsubmittedgrid',
    collapsible: true,
    title:getFeeAndPaymentCommonTranslation('DOCUMENTS_TO_BE_SUBMITTED'),
    border: true,
    viewConfig: {
        stripeRows: true
    },
    tbar: [{
        xtype: 'button',
        itemId: 'btnAdd',
        disabled:true,
        tooltip: getCommonTranslation('ADD'),
        glyph: ICONGLYPH.ADDGLYPH

    },{
        xtype: 'button',
        itemId: 'btnEdit',
        disabled:true,
        tooltip: getCommonTranslation('EDIT'),
        glyph: ICONGLYPH.EDITGLYPH
    }],
    columns: [{
		text : getAdmissionTranslation('DOCUMENT_NAME'),
		dataIndex: 'documentType',
		sortable : true,
		flex: .4,
		renderer:function(value){
			return '<a href=#>'+value.value+'</a>'
		}
	}, {
		text : getAdmissionTranslation('APPLICABILITY'),
		dataIndex : 'applicability',
		sortable : true,
		flex: .3,
		renderer: function(obj) {
			return getAdmissionTranslation(obj);
		}
	},
	{
		text : getCommonTranslation('STATUS'),
		dataIndex : 'status',
		sortable : true,
		flex: .3,
		renderer : function(value){
			if(value!=null && value=='SUBMITTED'){
				return getCommonTranslation('SUBMITTED');
			}else{
				return getCommonTranslation('PENDING');
			}
		}
	},{
        header: getFeeAndPaymentCommonTranslation('REMARK'),
        dataIndex: 'remark',
        //align: 'center',
        sortable: true,
        flex: .2,
		renderer:function(){
			return "<a href='#'>View</a>";
		}
    }],
    initComponent: function() {
        var this$ = this;
        var store = this$.buildStore();
        Ext.apply(this$, {
            store: store,
            dockedItems: [{
                xtype: 'toolbar',
                dock: 'bottom',
                items: [{
                    xtype: 'custompagingtoolbar',
                    plugins: ['pagesize'],
                    store: store,
                    emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
                    displayInfo: true
                }]
            }]
        });

        this$.callParent(arguments);
    },
    buildStore: function() {
        return Ext.create('Academia.store.feeandpayment.OtherDocumentToBeSubmittedGridStore');
    }
});