/**
 * @author Rajkumar.Patidar
 */

Ext.define('Academia.view.feeandpayment.addsequence.AddSequenceWin',{
	extend : 'Ext.form.Panel',
	alias: 'widget.addsequencewin',
	requires: ['Ext.ux.form.ItemSelector'],
//	title:getFeeAndPaymentCommonTranslation('ADD_SEQUENCE'),
	autoScroll: true,
	bodyStyle:{ margin:CONSTANTS.LEFT_MARGIN_FOR_SEARCH_PANEL} ,
	cls:'horizontalScrollingFixed' ,
	items: [{
		xtype: 'customform',
		customFieldEntity:CONSTANTS.FEE_PLAN_SEQUENCE_CUSTOM_FIELD,
		itemId:'feeplandetailform',
		plugins : "formlabelrequired",
		layout: {
			type: 'vbox'
		},
		defaults: {
			labelAlign: 'top'
			//width:226
		},
		standardSubmit: false,
		items: [{
			xtype: 'hidden',
			name: 'id'
		},{
			xtype:'fieldcontainer',
			layout:'hbox',
			//width: 'auto',
			defaults: {
				//width: 460,
				labelAlign: 'top'
			},
			items:[{
				xtype: 'textfield',
				name: 'feePlanSequence',
				readOnly:true,
				itemId:'feePlanSequence',
				fieldLabel: getFeeAndPaymentCommonTranslation('FEE_PLANE_SEQUENCE'),
				width: 226,
				allowBlank:true
			},{
				xtype: 'checkboxfield',
				width: 460,
				style:{marginTop:'30px'},
				itemId:'documenRequired',
				labelAlign: 'left',
				boxLabel: getFeeAndPaymentCommonTranslation('DOCUMENT_REQUIRED'),
				name: 'documentRequired',
				inputValue : true,
				uncheckedValue: false 
			}]
		},{	
			xtype: 'multiselectcombofield',
			name: 'document',
			hidden:true,
			width:460,
			maxHeight:200,
			itemId: 'documentId',
			autoScroll:true,
			store:'examinationcenters.evaluationgroup.document.EvalGroupDocumentName',
			displayField: 'value',
			valueField: 'id',
			autoloadStore: false,
			fieldLabel: getFeeAndPaymentCommonTranslation('DOCUMENT')
		},{
			xtype:'panel',
			cls: 'panelNoSpace',
			items:[{
				xtype: 'radiogroup',
				itemId:'specificLinkTypeId',
				//width:'auto',
				width:460,
				columns: 3,
				labelAlign:'top',
				vertical: true,
				fieldLabel: getFeeAndPaymentCommonTranslation('RULE_APPLICABLE_ON'),
				items:[
					{ boxLabel:getFeeAndPaymentCommonTranslation('NORMAL_RULE'), name: 'feeSpecificLinkType', inputValue: getFeeAndPaymentCommonTranslation('NOT_APPLICABLES'),checked:true},
					{ boxLabel:getFeeAndPaymentCommonTranslation('SPECIFIC_PERSON'), name: 'feeSpecificLinkType', inputValue: getFeeAndPaymentCommonTranslation('SPECIFIC_PERSONS')},
					{ boxLabel:getFeeAndPaymentCommonTranslation('ADDITIONAL_RULE'), name: 'feeSpecificLinkType', inputValue: getFeeAndPaymentCommonTranslation('RULE_BASEDS')}
                  ]
			}]
		},{
    	    xtype: 'customcombobox',
			name:'drools',
			itemId:'droolsItemId',
			store:'examinationcenters.evaluation.evaluationPlanHeirarchy.DroolCalculationData',
			fieldLabel:getFeeAndPaymentCommonTranslation('SELECT_RULE'),
			valueField: 'code',
			displayField: 'value',
			width:226,
			typeAhead:false,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			queryParam:'droolName',
			minChars:3,
			hidden:true,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
		},{
			xtype: 'textareafield',
			width:460,
			name: 'feeRuleDesc',
			itemId:'ruleDiscription',
			fieldLabel: getFeeAndPaymentCommonTranslation('RULE_DISCRIPTION'),
			enforceMaxLength : true,
			allowBlank: false,
			maxLength:225
		},{
			xtype: 'textareafield',
			width:460,
			name: 'feeRuleDescOtherLanguages',
			itemId:'feeRuleDescOtherLanguagesId',
			fieldLabel: getCommonTranslation('FEE_PLAN_RULE_DESCRIPTION_OTHER_LANGUAGES'),
			enforceMaxLength : true,
			allowBlank: true,
			maxLength:255,
			hidden:true
		},{
			xtype:'fieldcontainer',
			layout:'hbox',
			width: 'auto',
			defaults: {
				width: 226,
				labelAlign: 'top'
			},
			items:[{
				xtype: 'customcombobox',
				name: 'status',
				itemId:'sequenceStatus',
				fieldLabel: getFeeAndPaymentCommonTranslation('SEQUENCE_STATUS'),
				store: 'feeandpayment.SequenceStatus',
				valueField: 'id',
				displayField: 'value',
				allowBlank: false,
				typeAhead:true,
				forceSelection:true
			},{
				xtype: 'customcombobox',
				name: 'feePlanStage',
				itemId:'stages',
				fieldLabel: getFeeAndPaymentCommonTranslation('STAGE'),
				store: 'feeandpayment.FeePlanStageType',
				valueField: 'id',
				displayField: 'value',
				allowBlank: false
				// typeAhead:true,
				//forceSelection:true
			},{
				xtype: 'checkboxfield',
				width: 460,
				style:{marginTop:'30px'},
				itemId:'billingApplicableOnCheckIn',
				labelAlign: 'left',
				boxLabel: getFeeAndPaymentCommonTranslation('BILLING_APPLICABLE_ON_CHECK_IN'),
				name: 'billingApplicableOnCheckIn',
				hidden:true,
				inputValue : true,
				uncheckedValue: false 
			}
			]
		},{
            xtype: 'fieldcontainer',
            layout: {
                type: 'hbox'
            },
            defaults: {
                width: 226,
                labelAlign: 'top'
            },
            items:[{
                xtype: 'checkbox',
                name: 'isCourseWiseExamFee',
                itemId:'courseWiseExamFeesId',
                style: 'margin-top: 17px; margin-left: 3px',
                labelAlign: 'left',
                hidden:true,
                boxLabel: getFeeAndPaymentCommonTranslation('COURSE_WISE_EXAM_FEES'),
            }]
        },{
			xtype: 'customcombobox',
			width: 226,
			name: 'selecetionStage',
			itemId:'selecetionStage',
			fieldLabel: getFeeAndPaymentCommonTranslation('SELECTION_STAGE'),
			store: 'course.CourseStageStore',                 
			valueField: 'id',
			displayField: 'value',
			allowBlank: true,
			hidden:true

		},{
    		xtype: 'fieldcontainer',
    		layout: {
    			type: 'hbox'
    		},
    		defaults: {
    			width: 226,
    			labelAlign: 'top'
    		},
    		items:[{
    				xtype: 'numberfield',
    				name: 'dueDays',
    				itemId:'dueDays',
    				fieldLabel: getFeeAndPaymentCommonTranslation('DUE_DAYS'),
    				minValue : 0,
    				maxLength:3,
    				maxValue:999,
    				allowExponential:false,
    				allowBlank:false,
    				allowDecimals:false
    		},{
	            xtype: 'checkboxfield',
	            width: 460,
	            style:{
	            	marginTop:'25px'
	            },
	            labelAlign: 'right',
	            hidden:true,
	            itemId:'whetherGenerateBillAtStudentCourseEnrollmentId',
	            boxLabel: getCommonTranslation("GENERATE_BILL_AT_STUDENT_COURSE_ENROLLMENT"),
	            name: 'whetherGenerateBillAtStudentCourseEnrollment',
	            inputValue : true,
	            checked:false
	        },{
				xtype: 'numberfield',
				name: 'enrollmentNumber',
				itemId:'enrollmentNumber',
				fieldLabel: getCommonTranslation('ENROLLMENT_NUMBER'),
				minValue : 2,
				allowBlank:true,
				allowDecimal:false,
				maxValue : 10,
				hidden:true,
		}]
		},{
            xtype: 'checkboxfield',
            width: 'auto',
            labelAlign: 'right',
            hidden:true,
            itemId:'whetherConsiderRegAdminDateForDueDate',
            boxLabel: getFeeAndPaymentCommonTranslation("CONSIDER_REG_ADMIN_DATES_FOR_DUE_DATE"),
            name: 'whetherConsiderRegAdminDateForDueDate',
            inputValue : true,
            checked:false
        },{
			xtype:'fieldcontainer',
			layout:'hbox',
			cls:'programCheckBox',
			itemId:'generateBillRadioGroup',
			hidden:true,
			defaults: {
				width: 800,
				labelAlign: 'top'
			},
			items:[{
			xtype: 'radiogroup',
			itemId:'generateBillId',
			layout:'hbox',
			items: [
			        { boxLabel: getFeeAndPaymentCommonTranslation('GENERATE_BILL_PAYMENT_MSSG'), name: 'whetherGenerateBillForPaymentSchedule', inputValue:true,checked:true},
			        { boxLabel: getFeeAndPaymentCommonTranslation('GENERATE_BILL_STUDENT_MSSG'), name: 'whetherGenerateBillForPaymentSchedule', inputValue:false}
			        ]
		}]
		},{
			xtype:'checkboxfield',
			itemId:'whetherGeneratebillsForStdLateAdm',
			name:'whetherGeneratebillsForStdLateAdm',
			boxLabel:getFeeAndPaymentCommonTranslation('GENERATE_BILLS_AT_THE_TIME_OF_STUDENT_LATE_ADMISSION'),
			inputValue:true,
			lableAlign:'right',
			style: 'margin-left: 6px',
			checked:false,
			hidden:true
		},{
			xtype:'fieldcontainer',
			layout:'hbox',
			width: '100%',
			defaults: {
				labelAlign:'top',
				width:240
			},
			items:[{
				xtype: 'checkboxfield',
				width: 'auto',
				itemId:'whetherProrataBilling',
				labelAlign: 'right',
				boxLabel: getFeeAndPaymentCommonTranslation('WHETHER_PRORATA_BILLING'),
				name: 'whetherProrataBilling',
				inputValue : true,
				hidden:true,
				uncheckedValue: false
			},{
				xtype: 'checkboxfield',
//				width: 'auto',
				itemId:'isHostelFee',
				labelAlign: 'right',
				style: 'margin-left: 9px',
				boxLabel: getFeeAndPaymentCommonTranslation('IS_HOSTEL_FEE'),
				name: 'isHostelFee',
				inputValue : true,
				hidden:true,
				uncheckedValue: false
			}]
		},{
			xtype: 'checkboxfield',
			width: 'auto',
			itemId:'forInstrument',
			labelAlign: 'right',
			boxLabel: getFeeAndPaymentCommonTranslation('CONFIGURE_FEE_HEAD_MSSG1'),
			name: 'forInstrument',
			inputValue : true,
			hidden:true,
			uncheckedValue: false
		},{
			xtype: 'checkboxfield',
			width: 'auto',
			itemId:'forSponsor',
			labelAlign: 'right',
			boxLabel: getFeeAndPaymentCommonTranslation('CONFIGURE_FEE_HEAD_MSSG2'),
			name: 'forSponsor',
			hidden:true,
			inputValue : true,
			uncheckedValue: false 
		},{
			xtype: 'hidden',
			name: 'feePlanRuleStages',
			itemId:'feePlanRuleStages'
		},{
			xtype: 'numberfield',
			name: 'noOfCourses',
			itemId: 'noOfCourse',
			fieldLabel: getFeeAndPaymentCommonTranslation('NO_OF_COURSE'),
			hideTrigger:true,
     	    mouseWheelEnabled:false,
     	    allowDecimals:false,
     	    regex: /[a-zA-Z0-9]+/,
     	    width: 226,
     	    hidden:true
		},{

			xtype:'fieldcontainer',
			layout:'hbox',
			width: 'auto',
			defaults: {
				width: 226,
				labelAlign: 'top'
			},
			items:[{
				xtype: 'customcombobox',
				name: 'paymentGroup',
				itemId:'paymentGroupId',
				fieldLabel: getCommonTranslation('PAYMENT_GROUP'),
				store: 'feeandpayment.PaymentGroupStore',
				valueField: 'id',
				displayField: 'name',
				allowBlank: true,
				typeAhead:true,
				editable: false, 
				forceSelection:true,
				hidden : true,
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
							picker.maxWidth = picker.up('combobox').getSize().width;
						}
					}
				}
			},{
				xtype: 'customcombobox',
				name: 'paymentTerm',
				itemId:'paymentTermId',
				fieldLabel: getCommonTranslation('PAYMENT_TERM'),
				store: 'feeandpayment.PaymentGrpTermStore',
				valueField: 'id',
				displayField: 'name',
				allowBlank: true,
				editable: false, 
				hidden :   true,
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
							picker.maxWidth = picker.up('combobox').getSize().width;
						}
					}
				}
				
			}]
		
		},{
    		xtype: 'fieldcontainer',
    		layout: {
    			type: 'hbox'
    		},
    		defaults: {
    			width: 226,
    			labelAlign: 'top'
    		},
    		items:[{
				xtype: 'datefield',
				name: 'selectionTillDate',
				itemId:'selectionTillDate',
				fieldLabel: getFeeAndPaymentCommonTranslation('SELECTION_TILL_DATE'),
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				},
				editable:false
			}]
		},{
    		xtype:'fieldset',
    		title: getFeeAndPaymentCommonTranslation('OL_PAYMENT_CONFIG'),
    		layout:'vbox',
    		frame:true,	
    		collapsible:true,
    		collapsed:true,
    		style:{marginTop: '25px!important'},
    		width:'100%',
    		items: [{
    			xtype:'fieldcontainer',
    			layout:'hbox',
    			width: 'auto',
    			defaults: {
    				width: 226,
    				labelAlign: 'top'
    			},
    			items:[{
    			xtype: 'radiogroup',
    			itemId:'whetherOLPaymentAvailableId',
    			layout:'hbox',
    			fieldLabel:getFeeAndPaymentCommonTranslation('ONLINE_PAYMENT'),
    			items: [
    			        { boxLabel: getFeeAndPaymentCommonTranslation('YES'), name: 'whetherOLPaymentAvailable', inputValue:true,checked:true},
    			        { boxLabel: getFeeAndPaymentCommonTranslation('NO'), name: 'whetherOLPaymentAvailable', inputValue:false}
    			        ]
    			},{
    				xtype: 'radiogroup',
    				itemId:'whetherPaymentAtBillLevelId',
    				fieldLabel:getFeeAndPaymentCommonTranslation('PAYMENT_AT_BILL_LEVEL'),
    				layout:'hbox',
    				items: [
    				        { boxLabel: getFeeAndPaymentCommonTranslation('YES'), name: 'whetherPaymentAtBillLevel', inputValue:true},
    				        { boxLabel: getFeeAndPaymentCommonTranslation('NO'), name: 'whetherPaymentAtBillLevel', inputValue:false,checked:true}
    				        ]
    			},{
    				xtype: 'radiogroup',
    				itemId:'whetherPaymentAtBillLevelIdMobile',
					name:'whetherPaymentAtBillLevelMobile',
    				fieldLabel:getFeeAndPaymentCommonTranslation('PAYMENT_AT_BILL_LEVEL_MOBILE'),
    				layout:'hbox',
    				items: [
    				        { boxLabel: getFeeAndPaymentCommonTranslation('YES'), name: 'whetherPaymentAtBillLevelMobile', inputValue:true},
    				        { boxLabel: getFeeAndPaymentCommonTranslation('NO'), name: 'whetherPaymentAtBillLevelMobile', inputValue:false,checked:true}
    				        ]
    			}]
    		},{
    			xtype:'fieldcontainer',
    			layout:'hbox',
    			width: 'auto',
    			defaults: {
    				width: 226,
    				labelAlign: 'top'
    			},
    			items:[{
    				xtype: 'radiogroup',
    				itemId:'whetherMandatoryToPayId',
    				layout:'hbox',
    				fieldLabel:getFeeAndPaymentCommonTranslation('PAYMENT_MANDATORY'),
    				items: [
    				        { boxLabel: getFeeAndPaymentCommonTranslation('YES'), name: 'whetherMandatoryToPay', inputValue:true},
    				        { boxLabel: getFeeAndPaymentCommonTranslation('NO'), name: 'whetherMandatoryToPay', inputValue:false,checked:true}
    				        ]
    			},{
    			xtype: 'radiogroup',
    			itemId:'allowPartialPaymentId',
    			layout:'hbox',
    			fieldLabel:getFeeAndPaymentCommonTranslation('ALLOW_PARTIAL_PAYMENT'),
    			items: [
    			        { boxLabel: getFeeAndPaymentCommonTranslation('YES'), name: 'allowPartialPayment', inputValue:true},
    			        { boxLabel: getFeeAndPaymentCommonTranslation('NO'), name: 'allowPartialPayment', inputValue:false,checked:true}
    			        ]
    			},{

        			xtype: 'radiogroup',
        			itemId:'allowPartialPaymentMobileAppId',
        			layout:'hbox',
        			width:'100%',
        			fieldLabel:getFeeAndPaymentCommonTranslation('PARTIAL_PAYMENTS_ON_MOBILE_APPLICATION'),
        			items: [
        			        { boxLabel: getFeeAndPaymentCommonTranslation('YES'), name: 'allowPartialPaymentMobileApp', inputValue:true},
        			        { boxLabel: getFeeAndPaymentCommonTranslation('NO'), name: 'allowPartialPaymentMobileApp', inputValue:false,checked:true}
        			        ]
        			
    			}]
    		},{
    			xtype:'fieldcontainer',
    			layout:'hbox',
    			width: 'auto',
    			defaults: {
    				width: 226,
    				labelAlign: 'top'
    			},
    			items:[{
    				xtype: 'checkboxfield',
//    				width: 'auto',
    				style:{
//  					marginLeft:'10px'
    				},
    				labelAlign: 'right centre',
    				itemId:'blockPaymentAferDate',
    				boxLabel: getFeeAndPaymentCommonTranslation('BLOCK_PAYMENT'),
    				name: 'blockPaymentAferDate',
//    				checked:true,
    				inputValue : true
    			},{
    				xtype: 'datefield',
    				name: 'blockDate',
    				itemId:'blockDate',
    				hidden:true,
    				minValue:new Date(),
    				//itemId:'academyIdQuickFiltr',
    				editable:false,
    				//--submitFormat:CONSTANTS.DATE_FORMAT,
    				listeners: {
    					render: function(field) {
    						return dateFormatRender(field);
    					}
    				},
//    				fieldLabel: getFeeAndPaymentCommonTranslation('DATE')
    			}]
    		},{
    			xtype: 'fieldcontainer',
    			width: 'auto',
    			layout: 'hbox',
    			defaults: {
    				width: 226,
    				labelAlign: 'top'
    			},
    			style:{
//    				marginLeft:'10px'
    			},
    			items: [{
    				xtype: 'radiogroup',
    				itemId:'whetherPaymentBlockAtBillDate',
    				layout:'hbox',
//  				hidden:true,
    				fieldLabel:getFeeAndPaymentCommonTranslation('BLOCK_PAYMENT_AT_BILL_DATE'),
    				items: [
    				        { boxLabel: getFeeAndPaymentCommonTranslation('YES'), name: 'whetherPaymentBlockAtBillDate', inputValue:true},
    				        { boxLabel: getFeeAndPaymentCommonTranslation('NO'), name: 'whetherPaymentBlockAtBillDate', inputValue:false,checked:true}
    				        ]
    			},{
    				xtype: 'numberfield',
    				name: 'dueDaysForPaymentBlock',
    				itemId:'dueDaysForPaymentBlock',
    				fieldLabel: getFeeAndPaymentCommonTranslation('DUE_DAYS_FOR_PAYMENT_BLOCK'),
    				minValue : 0,
    				value:15,
    				editable:true,
    				allowDecimal:true
    			}]
    		}],
    		listeners:{
    			render: function(myfieldset){
    				myfieldset.setMargin('-10px');
    			}
    		}
       },{ 	
			xtype:'fieldcontainer',
			width:'auto',
			items: [{
				xtype: 'button',
				action: 'Submit',
				text: getFeeAndPaymentCommonTranslation('SAVE'),
				formBind: true,
				itemId: 'SubmitBtn',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE
			},{
				xtype: 'button',
				text: getFeeAndPaymentCommonTranslation('CANCEL'),
				ui: 'CustomBtnCancel',
				itemId: 'CancelBtn',
				scale: CONSTANTS.BUTTONSIZE
			}]
		}]
	}]	
});