/**
 *  @author Rajkumar.patidar
 */


Ext.define('Academia.view.feeandpayment.adjustment.BillReceivableList', {
	extend : 'Ext.grid.Panel',
	alias : 'widget.billreceivablelist',
	title : getFeeAndPaymentCommonTranslation('BILL_RECEIVABLE_LABEL'),
	store : 'feeandpayment.adjustment.BillReceivable',
	selType:'checkboxmodel',
	isGridConfigurable: true,
	enableColumnHide: false,
	selModel: {
		mode:'MULTI',
		showHeaderCheckbox: false,
		allowDeselect: true,
		checkOnly : true,
		 renderer: function(value, metaData, record, rowIndex, colIndex, store, view) {
			 var amountToBeAdjusted = record.get("amountToBeAdjusted");
			 if (amountToBeAdjusted>0) {
				 var baseCSSPrefix = Ext.baseCSSPrefix;
				 metaData.tdCls = baseCSSPrefix + 'grid-cell-special ' + baseCSSPrefix + 'grid-cell-row-checker';
				 return '<div class="' + baseCSSPrefix + 'grid-row-checker">&#160;</div>';
			 } else {
				 return '';
			 } 
		 }
	},
	border: true,
	autoScroll: false,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS,
		loadMask: false
	},
	tbar: [{
		xtype: 'button',
		itemId: 'saveBtn',
		text:getFeeAndPaymentCommonTranslation('SAVE'),
		tooltip: getFeeAndPaymentCommonTranslation('SAVE')
	}],
	columns: [{
		header : getCommonTranslation('STUDENT_ID'),
		dataIndex : 'code',
		flex : 1,
		hidden:true
	},{
		header : getCommonTranslation('STUDENT_NAME'),
		dataIndex : 'printName',
		flex : 1,
		hidden:true
	},{
		header : getCommonTranslation('BILL_NO'),
		dataIndex : 'billNo',
		flex : 1	 
	},{
		header : getCommonTranslation('BILL_DATE'),
		dataIndex : 'billingDate',
		flex :1,
		renderer: function(date) {
			if(!isNullOrEmpty(date)) {
				return dateRender(date);
			}
		}
	},{
		header : getCommonTranslation('DUE_DATE'),
		dataIndex : 'dueDate',
		flex :1,
		renderer: function(date) {
			if(!isNullOrEmpty(date)) {
				return dateRender(date);
			}
		}
	},{
		header : getCommonTranslation('BILL_TYPE'),
		dataIndex : 'billType',
		flex : 1,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(value)) {
				return getCommonTranslation(value);
			}                    
		}
	},{
		header : getCommonTranslation('FEE_HEAD'),
		dataIndex : 'feeHeadName',
		flex : 1	
	},{
		header : getCommonTranslation('BILLING_AMOUNT'),
		dataIndex : 'totalAmount',
		flex : 1,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(value)) {
				return currencyRenderer(value,record.get("currencyId"));
			}                    
		} 
	},{
		header : getCommonTranslation('ALREADY_ADJUSTED_AMOUNT'),
		dataIndex : 'totalAdjustedAmount',
		flex : 1,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(value)) {
				return currencyRenderer(value,record.get("currencyId"));
			}                    
		} 
	},{
		header : getCommonTranslation('BALANCE_AMOUNT'),
		dataIndex : 'totalBalanceAmount',
		flex : 1,
		itemId:'totalBalanceAmount',
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(value)) {
				return currencyRenderer(value,record.get("currencyId"));
			}                    
		} 
	},{
		header : getCommonTranslation('CURRENCY_EXCHANGE_RATE'),
		dataIndex : 'currencyExchangeRate',
		flex : 1
	},{
		header : getCommonTranslation('CONVERTED_AMOUNT'),
		dataIndex : 'convertedBalanceAmount',
		flex : 1,
		itemId:'convertedBalanceAmount',
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(value)) {
				return currencyRenderer(value,record.get("baseCurrencyId"));
			}                    
		}
	},{
		header : getCommonTranslation('AMOUNT_TO_BE_ADJUSTED'),
		dataIndex : 'amountToBeAdjusted',
		flex : 1,
		editing:true,
		itemId : 'amountToBeAdjusted',
		editor : {
			xtype:'numberfield',
			name: 'amountToBeAdjusted',
			itemId:'amountToBeAdjusted',
			mouseWheelEnabled:false,
			allowDecimals:true,
			enableKeyEvents:true,
			hideTrigger:true,
			minValue:0
		},    
		renderer:function(value,meta){
			if(!isNullOrEmpty(value)) {
				return value;
			} else {
				meta.tdCls = 'gridInputCustomStyle'; 
				return getFeeAndPaymentCommonTranslation('CLICK_TO_ENTER');
			}                        
		}
	},{
		header : getCommonTranslation('VIEW_ADJUSTMENTS'),
		dataIndex : 'viewAdjustments',
		flex : 1,
		renderer:function(){
			return  '<a href="#">View</a>';
		}
	}],
	plugins: [{
	  	  ptype : 'cellediting',
	  	  clicksToEdit: 1
	    }]
});