/**
 *  @author Rajkumar.patidar
 */
Ext.define('Academia.view.feeandpayment.adjustment.PaymentsList', {
	extend : 'Ext.grid.Panel',
	alias : 'widget.paymentslist',
	title : getFeeAndPaymentCommonTranslation('PAYMENTS'),
	store : 'feeandpayment.adjustment.PaymentAdjustment',
	border: true,
	refreshStoreData:true,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS,
		loadMask: false
	},
	tbar: [{
		itemId: 'nextBtn',
		disabled:true,
		text:getCommonTranslation('NEXT'),
		tooltip: getCommonTranslation('NEXT')
	},{
		xtype: 'button',
		itemId: 'cancelSettlementLink',
		text:getFeeAndPaymentCommonTranslation('CANCEL_SETTLEMENT'),
		tooltip: getFeeAndPaymentCommonTranslation('CANCEL_SETTLEMENT')
	}],
	dockedItems : [{
	}],
	columns: [{
		header : getFeeAndPaymentCommonTranslation('PAYMENT_VOUCHER_NO'),
		dataIndex : 'paymentVoucherNo',
		flex : 1	 
	},{
		header : getFeeAndPaymentCommonTranslation('PAYMENT_DATE'),
		dataIndex : 'transactionDate',
		flex : 1,
		renderer: function(date) {
			return dateRender(date);
		}
	},{
		header : getFeeAndPaymentCommonTranslation('VOUCHER_MODE'),
		dataIndex : 'voucherMode',
		flex : 1	
	},{
		header : getFeeAndPaymentCommonTranslation('PAYMENT_AMOUNT'),
		dataIndex : 'amount',
		flex : 1,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(value)) {
				return currencyRenderer(value,record.get("currencyId"));
			}                    
		} 
	},{
		header : getFeeAndPaymentCommonTranslation('ALREADY_ADJUST_AMOUNT'),
		dataIndex : 'totalAdjustmentAmount',
		flex : 1,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(value)) {
				return currencyRenderer(value,record.get("currencyId"));
			}                    
		} 
	},{
		header : getFeeAndPaymentCommonTranslation('BALANCE_AMOUNT'),
		dataIndex : 'totalBalanceAmount',
		flex : 1,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(value)) {
				return currencyRenderer(value,record.get("currencyId"));
			}                    
		} 
	},{
		header : getFeeAndPaymentCommonTranslation('VIEW_ADJUSTMENTS'),
		dataIndex : 'viewAdjustments',
		flex : 1,
		renderer:function(){
			return  '<a href="#">View</a>';
		}
	}]
});