/**
 *  @author Rajkumar.patidar
 */
var discountListStoreforDG='feeandpayment.discount.DiscountListStore';
Ext.define('Academia.view.feeandpayment.discounts.DiscountList', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.discountlist',
	store : discountListStoreforDG,
	border: true,
	autoScroll: false,
	isGridConfigurable: true,
	enableColumnHide: false,
//	selType:'checkboxmodel',
	title: getCommonTranslation('DISCOUNTS'),
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : discountListStoreforDG,
			emptyMsg :getFeeAndPaymentCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	initComponent: function() {
        var grid=this;                   
        grid.addExportToolBarItems(grid);
        this.callParent(arguments);     
   },
	tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getCommonTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH
	}, {
		xtype: 'button',
		itemId: 'btnEdit',
		tooltip: getCommonTranslation('EDIT'),
		glyph: ICONGLYPH.EDITGLYPH
	}, {
		xtype: 'button',
		itemId: 'btnView',
		tooltip: getCommonTranslation('VIEW'),
		iconCls: 'view-icon'
	}, {
		xtype: 'button',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip: getCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH
	},{
		xtype : 'splitbutton',
		itemId:'spBtnMoreActions',
		text : getCommonTranslation('MOREACTIONS'),
		menu:[{
			text:getFeeAndPaymentCommonTranslation('MAP_FEE_PLAN_TYPE'),
			tooltip: getFeeAndPaymentCommonTranslation('MAP_FEE_PLAN_TYPE'),
			itemId:'btnMapFeePlanType'	
		}]
	}],
	columns: [{
		header : getCommonTranslation('STUDENT_DISCOUNT_TYPE'),
		dataIndex : 'discount',
		flex : 1,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(record.data.discount.value)){
				return record.data.discount.value;
			}
		}
	},{
		header : getCommonTranslation('DISCOUNT_CODE'),
		dataIndex : 'discountCode',
		flex : 1
	},{
		header : getCommonTranslation('DESCRIPTION'),
		dataIndex : 'description',
		flex : 1
	},{
		header : getCommonTranslation('WHETHER_PERCENTAGE'),
		dataIndex : 'whetherPercentage',
		flex : 1,
		renderer:function(value,meta,record){
			if(record.data.whetherPercentage){
				return 'Yes';
			} else {
				return 'No';
			}
		}
	},{
		header : getCommonTranslation('WHETHER_FIXED'),
		dataIndex : 'whetherFixedAmount',
		flex : 1,
		renderer:function(value,meta,record){
			if(record.data.whetherFixedAmount){
				return 'Yes';
			} else {
				return 'No';
			}
		}
	},{
		header : getCommonTranslation('WHETHER_STANDALONE'),
		dataIndex : 'whetherStandAlone',
		flex : 1,
		renderer:function(value,meta,record){
			if(record.data.whetherStandAlone){
				return 'Yes';
			} else {
				return 'No';
			}
		}
	},{
		header : getCommonTranslation('WHETHER_ADHOC'),
		dataIndex : 'whetherAdhoc',
		flex : 1,
		renderer:function(value,meta,record){
			if(record.data.whetherAdhoc){
				return 'Yes';
			} else {
				return 'No';
			}
		}
	},{
		header : getCommonTranslation('RULE_APPLICABLE'),
		dataIndex : 'rule',
		flex : 1,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(record.data.rule)){
				return 'Yes';
			} else {
				return 'No';
			}
		}
		
	},{
		header : getCommonTranslation('FEE_PLAN_TYPE_DETAILS'),
		dataIndex : 'feePlanType',
		flex : 1,
		renderer:function(value,meta,record){
			if(record.data.feePlanType.length>0){
				return '<a href=#>View</a>';
			} else {
				return '-';
			}
		}
	}],
	plugins: [{
	  	  ptype : 'cellediting',
	  	  clicksToEdit: 1
	    }]
});
