/**
 * @author Amit G
 */
Ext.define('Academia.view.feeandpayment.finance.ManageFinanceHoldAddForm', {   
	//extend : 'Ext.form.FormPanel',
	extend:'Academia.view.common.IdGeneratorForm',
	alias : 'widget.managefinanceholdaddform',
	method : 'POST',
	title:getFeeAndPaymentCommonTranslation('FINANCE_HOLD_DETAILS'),
	frame:true,
	standardSubmit : false,
	//bodyStyle:{ margin:CONSTANTS.LEFT_MARGIN_FOR_SEARCH_PANEL} ,		
	//cls: 'noPaddingPanel',
	//width:'100%',
	
	plugins : "formlabelrequired",
	defaults: {
		labelAlign:'top',
		width:226
	},
	items: [{
		xtype:'hidden',
		name:'id'
	},{
		xtype:'fieldcontainer',
		 width: '100%',
	        layout: {
	            type: 'hbox'
	        },
		defaults: {
			labelAlign:'top',
			width:226
		},
		items:[{
			xtype:'textfield',
			fieldLabel:getFeeAndPaymentCommonTranslation('FINANCE_HOLD_ID'),
			itemId:'financeHoldId',
			name:'financeHoldId',
			emptyText: getCommonTranslation('ID_AUTOGENERATE')
		},{
			xtype:'textfield',
			fieldLabel:getFeeAndPaymentCommonTranslation('FINANCE_HOLD_NAME'),
			itemId:'financeHoldName',
			name:'financeHoldName',
			forceSelection:true,
			allowBlank:false
		},{
			xtype : 'datefield',
			anchor : '100%',
			fieldLabel: getFeeAndPaymentCommonTranslation('CUTOFF_DATE'),
			name : 'cutOffDate',
			itemId : 'cutOffDate',
			allowBlank:false,
			vtype: 'daterange',
			minValue:new Date(),
			listeners: {
				render: function(field) {
					return dateFormatRender(field);
				}
			},
			//--submitFormat : CONSTANTS.SUBMIT_DATE_FORMAT,
		}]
	},{	
		xtype:'fieldcontainer',
		width: '100%',
		layout : 'hbox',
		defaults: {
			labelAlign:'top',
			width:226
		},
		items:[{
			xtype: 'customcombobox',
			name: 'financeHoldStatus',
			fieldLabel: getFeeAndPaymentCommonTranslation('STATUS'),
			itemId:'financeHoldStatus',
			store: 'feeandpayment.finance.FinanceHoldStatusStore',
			valueField: 'id',
			displayField: 'value',
			allowBlank:false,
			typeAhead:true,
			forceSelection:true
		},{
			xtype: 'customcombobox',
			name: 'applicableOn',
			fieldLabel: getFeeAndPaymentCommonTranslation('APPLICABLE_ON'),
			itemId:'applicableOn',
			store: 'feeandpayment.finance.FinanceHoldApplicableOnStore',
			valueField: 'name',
			displayField: 'value',
			allowBlank:false,
			typeAhead:true,
			forceSelection:true
		}]
	},{
		xtype:'panel',
		itemId: 'typeFeePercentheaderPanel',
		style: {margin:0},
		//style: {marginLeft:'0px',marginTop:'0px',marginRight:'0px',marginBottom:'0px'},
		width: '100%',
		items:[{
			xtype: 'fieldcontainer',
			itemId: 'defaultFieldContainer',
			width: '100%',
			layout: {
				type: 'hbox',
				align: 'bottom'
			},
			items: [{
				xtype:'hidden',
				name:'financeHoldTypeId',
				itemId:'financeHoldTypeId'
			},{
				xtype: 'customcombobox',
				itemId: 'financeHoldType',
				name: 'financeHoldType',
				fieldLabel: getFeeAndPaymentCommonTranslation('HOLD_TYPE'),
				labelAlign: 'top',
				width: 226,
				store: 'feeandpayment.finance.FinanceHoldTypeStore',
				valueField: 'id',
				displayField: 'value',
				forceSelection:true,
				allowBlank: false,
				newHoldTypes: [
                    'MAKRSHEET_PUBLISH',
                    'ASSESSMENT_SCHEME_LEVEL',
                    'ASSESSMENT_SCHEME_TYPE_LEVEL',
                    'ASSESSMENT_SCHEME_SUBTYPE_LEVEL',
                    'METHOD_LEVEL',
                    'EVENT_LEVEL',
                    'GRADEBOOK_PUBLISH'
                ],
                listConfig: {
                	listeners: {
                		beforeshow: function (picker) {
                			picker.minWidth = picker.up('combobox').getSize().width;
                			Academia.app.getController('Academia.controller.feeandpayment.finance.ManageFinanceHoldController').toggleHoldTypeOptions(picker);
                		},
                		refresh: function (boundList, eOpts) {
                			Academia.app.getController('Academia.controller.feeandpayment.finance.ManageFinanceHoldController').toggleHoldTypeOptions(boundList);
                		}
                	}
                }
			},{
				xtype:'hidden',
				name:'pendingFeePercentId',
				itemId:'pendingFeePercentId'
			}, {
				xtype:'numberfield',
				name:'pendingFeePercent',
				width: 226,
				allowExponential:true,
				labelAlign: 'top',
				fieldLabel:getFeeAndPaymentCommonTranslation('MINIMUM_PERCENTAGE_DUE'),
				itemId:'pendingFeePercent',
				minValue:0,
				maxLength:8,
				hideTrigger:true,
				mouseWheelEnabled:false,
				allowBlank: false
			}, {
				xtype:'numberfield',
				name:'minimumDueAmount',
				width: 226,
				allowExponential:true,
				labelAlign: 'top',
				fieldLabel:getFeeAndPaymentCommonTranslation('MINIMUM_DUE_AMOUNT'),
				itemId:'minimumDueAmount',
				minValue:0,
				maxLength:8,
				hideTrigger:true,
				mouseWheelEnabled:false,
				allowBlank: false,
				hidden:true
			},{
				xtype: 'button',
				itemId: 'btnAddTypeFeePercent',
				cls: 'CustomBodyBtnSettings',
				text: getCommonTranslation('ADDBUTTONTEXT'),
				tooltip: getCommonTranslation('ADD')
			}] 
		}]
	},{
		xtype:'fieldcontainer',
		layout:'hbox',
		width: 'auto',
		defaults: {
			width: 226,
			labelAlign: 'top'
		},
		items:[{
			xtype: 'radiogroup',
			itemId:'autoUnblockStudentRadioGroup',
			layout:'hbox',
			width:226,
			fieldLabel:getFeeAndPaymentCommonTranslation('AUTO_UNBLOCK_STUDENT_RADIO_GROUP'),
			items: [
			        { boxLabel: getFeeAndPaymentCommonTranslation('YES'), name: 'autoUnblockStudent', inputValue:true},
			        { boxLabel: getFeeAndPaymentCommonTranslation('NO'), style:{'margin-left':'55px !important'}, name: 'autoUnblockStudent', inputValue:false,checked:true}
			        ]
			}, {
				xtype: 'radiogroup',
				itemId:'visibleToStduentParentPortal',
				layout:'hbox',
				width:226,
				fieldLabel:getFeeAndPaymentCommonTranslation('VISIBLE_TO_STDUENT_PARENT_PORTAL'),
				items: [
				        { boxLabel: getFeeAndPaymentCommonTranslation('YES'), name: 'visibleToStduentParent', inputValue:true},
				        { boxLabel: getFeeAndPaymentCommonTranslation('NO'), style:{'margin-left':'55px !important'}, name: 'visibleToStduentParent', inputValue:false,checked:true}
				        ]
				}]
	},{
		xtype:'fieldcontainer',
		width:'100%',
		layout : 'hbox',
		items: [{
			xtype: 'button',
			text: getFeeAndPaymentCommonTranslation('SAVE'),
			formBind: true,
			itemId: 'SubmitBtn',
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE
		},{
			xtype: 'button',
			text: getFeeAndPaymentCommonTranslation('RESET'),
			itemId: 'resetBtn',
			ui: 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE
		}]
	}] 	

});
