var offlinePaymentStore='feeandpayment.payment.FeeOfflinePaymentDetailMainGridStore';
Ext.define('Academia.view.feeandpayment.payment.FeeOfflinePaymentDeatilForApplicantGrid', {
	//extend : 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.feeofflinepaymentdeatilforapplicantgrid',
	store : offlinePaymentStore,
	title: getCommonTranslation('OFFFLINE_PAYMENT_PROOF_DETAIL'),
	border: true,
	refreshStoreData:true,
	isGridConfigurable: true,
	enableColumnHide: false,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	features: [{
		ftype: 'summary',
		showSummaryRow:CONSTANTS.SHOW_SUMMARY_ROW 
	}],
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : offlinePaymentStore,
			emptyMsg :getFeeAndPaymentCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid);
		this.callParent(arguments);     
	},
	tbar: [{
		xtype: 'button',
		itemId: 'btnView',
		text: getFeeAndPaymentCommonTranslation('VIEW'),
		//iconCls: 'view-icon',
		cls: 'CustomBtnSubmit',
		scale: CONSTANTS.BUTTONSIZE,
	}],
	columns: [{
		header : getCommonTranslation('ACADEMY_LOCATION'),
		dataIndex : 'academyLocation.name',
		flex:1
	},{
		header : getCommonTranslation('APPLICANT_ID'),
		dataIndex : 'applicationCode',
		flex:1
	},{
		header : getCommonTranslation('APPLICANT_NAME'),
		dataIndex : 'applicantName',
		flex:1
	},{
		header : getCommonTranslation('APPLICANT_TOTAL_AMOUNT'),
		dataIndex : 'amount',
		flex:1
	},{
		header : getCommonTranslation('CREATED_ON'),
		dataIndex : 'createdOn',
		flex:1,
		renderer: function(date) {
			return dateRender(date);
		}
	},{
		header : getCommonTranslation('STATUS'),
		dataIndex : 'status',
		flex:1,
		renderer: function(value) {
			if(value == 'PENDING'){
				return 'Pending';
			}else if(value == 'APPROVED'){
				return 'Approved';
			}else if(value == 'REJECTED'){
				return 'Rejected';
			}
		}
	},{
		header : getCommonTranslation('RECEIPT_NO'),
		dataIndex : 'receiptNo',
		flex:1
	},{
		header : getCommonTranslation('DOCUMENTS'),
		dataIndex : 'noOfDocuments',
		flex:1,
		renderer : function(value){
			if(value>=1){
				return  '<a href="#">'+value+'</a>';
			}else{
				return value;
			}

		}
	}]
});
