/**
 * @author Amit G
 */
Ext.define('Academia.view.feeandpayment.payment.FeeOfflinePaymentDetailMainForm', {   
	extend : 'Ext.form.FormPanel',
	alias : 'widget.feeofflinepaymentdetailmainform',
	autoScroll: true,
	frame: false,
	method : 'POST',
	standardSubmit : false,
	defaults: {
		labelAlign:'top',
		width:226
	},
	plugins : "formlabelrequired",
	items: [{
		xtype:'panel',
		width:'100%',
		cls:'customSearchPanel',
		items:[{
			xtype:'hidden',
			name:'id'
		},
		{	
			xtype:'fieldcontainer',
			width: '100%',
			layout : 'hbox',
			defaults: {
				labelAlign:'top',
				width:226
			},
			items:[{
				xtype:'customcombobox',
				name: 'userType',
				itemId: 'userType',
				store: 'feeandpayment.dashboardAndReports.DiscountFindAllUserTypeStore',
				fieldLabel: getCommonTranslation('OFFLINE_PAYMENT_PROOF_FOR'),
				valueField: 'id',
				displayField: 'value',
				typeAhead: false,
				queryMode : 'local',
				allowBlank : true,
			}]
		},{	
			xtype:'fieldcontainer',
			width: '100%',
			layout : 'hbox',
			defaults: {
				labelAlign:'top',
				width:226
			},
			items:[{
				xtype: 'customcombobox',
				name: 'student',
				itemId:'student',
				width:460,
				hidden:true,
				fieldLabel: getFeeAndPaymentCommonTranslation('STUDENT_CODE_NAME'),
				store: 'feeandpayment.reports.Student',
				valueField: 'id',
				displayField: 'valueCode',
				queryParam:'studentNameOrCode',
				triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
				enableKeyEvents  : 'true',
				minChars:3,
				typeAhead:false,
				hideTrigger:false,
				forceSelection:true,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				triggerAction: '',
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{studentCode} / {studentName}' +
						'</div>';
					}
				}}]
		},/**applicant**/
		{
			
			xtype:'fieldcontainer',
			width: '100%',
			layout : 'hbox',
			defaults: {
				labelAlign:'top',
				width:226
			},
			items:[{

				xtype: 'customcombobox',
				name: 'applicant',
				itemId:'applicant',
				//hidden:true,
				width:460,
				fieldLabel: getFeeAndPaymentCommonTranslation('APPLICANT_CODE_NAME'),
				store: 'feeandpayment.discount.DiscountApplicantStore',
				valueField: 'id',
				displayField: 'printName',
				queryParam:'codeOrName',
				triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
				enableKeyEvents  : 'true',
				minChars:3,
				typeAhead:false,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				triggerAction: '',
				hideTrigger:false,
				forceSelection:true,
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{code}/{printName}' +
						'</div>';
					}
				}
			
			
			}]
		
		},
		{	
			xtype:'fieldcontainer',
			width: '100%',
			layout : 'hbox',
			defaults: {
				labelAlign:'top',
				width:226
			},
			items:[{  
				xtype: 'customcombobox',
				name: 'receiptNo',
				itemId:'receiptNo',
				fieldLabel: getFeeAndPaymentCommonTranslation('RECEIPT_NO'),
				store: 'feeandpayment.payment.FeeOfflinePaymentReceiptNoStore',
				valueField: 'id',
				displayField: 'value',
				triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
				enableKeyEvents  : 'true',
				minChars:3,
				forceSelection:true,
				typeAhead:false,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				triggerAction: '',
				hideTrigger:false,
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}' +
						'</div>';
					}
				}
			},{
				xtype: 'customcombobox',
				name: 'status',
				itemId:'status',
				fieldLabel: getFeeAndPaymentCommonTranslation('STATUS'),
				store: 'feeandpayment.payment.FeeOfflinePaymentStatusStore',
				valueField: 'id',
				displayField: 'name',
				typeAhead:true,
				forceSelection:true
			}]
		},{	
			xtype:'fieldcontainer',
			width: '100%',
			layout : 'hbox',
			defaults: {
				labelAlign:'top',
				width:226
			},
			items:[{
				xtype : 'datefield',
				anchor : '100%',
				fieldLabel : getFeeAndPaymentCommonTranslation('CREATED_FROM_DATE'),
				name : 'startDate',
				itemId : 'startDate',
				endDateField : 'tillDate',
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				},
				vtype : 'daterange',
				allowBlank:true
			},{
				xtype : 'datefield',
				anchor : '100%',
				fieldLabel : getFeeAndPaymentCommonTranslation('CREATED_TILL_DATE'),
				name : 'tillDate',
				itemId : 'tillDate',
				startDateField : 'startDate',
				listeners: {
            	  render: function(field) {
            		  return dateFormatRender(field);
            	  }
              },
				allowBlank:true,
				vtype : 'daterange'
			}]	
		},{
			xtype: 'panel',
			style:{marginLeft:'-12px',marginBottom:'-5px'},
			width: 'auto',
			items:[{  
				xtype: 'button',
				itemId: 'searchBtn',
				text: getCommonTranslation('SEARCH'),
				ui:'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE,
				formBind : true
			},{
				xtype: 'button',
				itemId: 'resetBtn',
				text: getCommonTranslation('RESET'),
				ui:'CustomBtnCancel',
				scale: CONSTANTS.BUTTONSIZE
			}]	
		}]
	  },{
			xtype : 'feeofflinepaymentdetailmaingrid', // by default no change
			hidden:true,
			width:'100%',
			itemId: 'feeofflinepaymentdetailmaingrid' 
		},{

			xtype:'feeofflinepaymentdeatilforapplicantgrid',
			itemId:'feeofflinepaymentdeatilforapplicantgrid',
			hidden:false,
			width:'100%',
		
		}]
	});