/**
 * @author Rajkumar.Patidar 
 */
Ext.define('Academia.view.feeandpayment.payment.StudentPaymentHeaderInstrumentAdjustmentDetailsGridWindow', {
	extend: 'Ext.window.Window',
	alias: 'widget.studentpaymentheaderinstrumentadjustmentdetailsgridwindow',
	modal : true,
	resizable:true,
	autoScroll: true,
	//height: 'auto',
	height: '40%',
	width: '80%',
	defaults:{
		width:'100%'
	},
	layout:'vbox',
	frame: true,
	title:getFeeAndPaymentCommonTranslation('INSTRUMENT_ADJUSTMENTS_DETAILS'),
	items: [{
		xtype: 'grid',
   	    itemId:'paymentheaderinstrumentdetailsgrid',
	    store : 'feeandpayment.payment.PaymentHeaderInstrumentAdjustmentDetails',
		autoScroll: true,
		border: true,
		viewConfig : {
			stripeRows : CONSTANTS.STRIPEROWS
		},
		 features: [{
		        ftype: 'summary',
		        showSummaryRow: CONSTANTS.SHOW_SUMMARY_ROW 
		    }],
		columns: [{
			 header : getFeeAndPaymentCommonTranslation('PAYMENT_MODE'),
		 	 dataIndex : 'paymentMode',
		 	 flex : 1,
		 	renderer:function(value) {
				if(value!=null){
					return value.value;
				}else{
					return value;
				}

			},
			summaryRenderer: function(value, summaryData, dataIndex) {
		          return getFeeAndPaymentCommonTranslation('TOTAL');
		      }
		 },{
			 header : getFeeAndPaymentCommonTranslation('INSTRUMENT_NO'),
		 	 dataIndex : 'instrumentNo',
		 	 flex : 1
		 },{
			 header : getFeeAndPaymentCommonTranslation('INSTRUMENT_DATE'),
		 	 dataIndex : 'instrumentDate',
		 	 flex : 1,
		 	 renderer: function(date) {
		 		 return dateRender(date);
		 	 }
		 },{
			 header : getFeeAndPaymentCommonTranslation('CURRENCY_EXCHANGE_RATE'),
			 dataIndex : 'currencyExchangeRate',
			 flex : 1.2,
			 hidden : true
		 },{
			 header : getFeeAndPaymentCommonTranslation('AMOUNT'),
			 dataIndex : 'amount',
			 flex : 1,
			// align: CONSTANTS.AMOUNT_COLUMN_ALIGN,
			 summaryType: 'sum',
			 renderer:function(value, metaData, record, row, col, store, gridView){
				 if(!isNullOrEmpty(record.get("currencyId"))){
					 return currencyRenderer(value,record.get("currencyId"));
				 }
			 },
			 summaryRenderer: function (value, summaryData, dataIndex, rowIndex, colIndex, store, view) {
				 return  value;
			 }
		 },{
			 header : getFeeAndPaymentCommonTranslation('CONVERTED_AMOUNT'),
			 dataIndex : 'convertedAmount',
			 flex : 1.2,
			 hidden : true
		 },{
			 header : getFeeAndPaymentCommonTranslation('DRAWN_ON_BANK'),
			 dataIndex : 'instrumentBank',
			 flex : 1,
			 hidden : true,
			 renderer:function(value) {
				 if(value!=null){
					 return value.value;
				 }else{
					 return 'Others';
				 }
			 }
		 },/*{
			 header : getFeeAndPaymentCommonTranslation('OUR_BANK_ACCOUNT'),
			 dataIndex : 'paymentInstrumentBank',
			 flex : 1,
			 renderer:function(value) {
				 if(value!=null){
					 return value;
				 }else{
					 return value;
				 }
			 }
		 }*/] 	
	}]
});

