/**
 * @author Rajkumar Patidar
 */
Ext.define('Academia.view.feeandpayment.receipts.FeeLedgerMasterSearchForm', {   
	extend : 'Ext.form.FormPanel',
	alias : 'widget.feeledgermastersearchform',
	method : 'POST',
	standardSubmit : false,
	frame: false,
	cls:'customSearchPanel',
	defaults: {
		labelAlign:'top',
		width:226
	},
	plugins : "formlabelrequired",
	items: [{
		xtype:'hidden',
		name:'id'
	},{
		xtype:'fieldcontainer',
		width: '100%',
		layout : 'hbox',
		defaults: {
			labelAlign:'top',
			width:226
		},
		items:[/*{
			xtype: 'customcombobox',
			name: 'academyId',
			itemId:'academyId',
			fieldLabel: getFeeAndPaymentCommonTranslation('ACADEMY'),
			store: 'common.AcademyStore',
			valueField: 'id',
			displayField: 'value',
			typeAhead:true,
			forceSelection:true
		},{
			xtype: 'customcombobox',
			name: 'locationId',
			itemId:'locationId',
			fieldLabel: getFeeAndPaymentCommonTranslation('LOCATION'),
			store: 'common.AcademyLocationByAcademyId',
			valueField: 'id',
			displayField: 'locationName',
			typeAhead:true,
			forceSelection:true  
		}*/{

            xtype: 'customcombobox',
			fieldLabel: getAdmissionTranslation('ACADEMY_LOCATION'),
            name: 'ACAD_LOC_ID',
            itemId:'academyLocationCombo',
            store: 'user.UserAcademyLocationStore',
            displayField: 'value',
            valueField: 'id',
            width:410,
            typeAhead : true,
            forceSelection:true,
            hideTrigger:false,
            //queryMode: 'local',	    
    	    triggerAction: 'all',
    	    queryParam:'qry',
            minChars:3,
            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            listConfig: {
				  listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
	                loadingText: getCommonTranslation('SEARCHING'),
	                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	                getInnerTpl: function() {
	                    return '<div class="search-item">' +
	                    '{value}'  +
	                    '</div>';
	                }
            }
	              
		}]
	
	},{
		xtype: 'customcombobox',
		name: 'ledgerName',
		itemId:'ledgerName',
		width:410,
		fieldLabel: getFeeAndPaymentCommonTranslation('LEDGER_NAME'),
		store: 'feeandpayment.receipts.FeeLedgerName',
		valueField: 'value',
		displayField: 'value',
		queryParam:'ledgerName',
		minChars:3,
		typeAhead:false,
		triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
		emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
		triggerAction: '',
        hideTrigger:false,
		  listConfig: {
			  listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
                loadingText: getCommonTranslation('SEARCHING'),
                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                getInnerTpl: function() {
                    return '<div class="search-item">' +
                        '{value}' +
                    '</div>';
                }
            }
	},{
		xtype:'fieldcontainer',
		width: '100%',
		
		items:[{  
			xtype: 'button',
			itemId: 'searchBtn',
			text: getCommonTranslation('SEARCH'),
			ui:'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE
		},{
			xtype: 'button',
			itemId: 'resetBtn',
			text: getCommonTranslation('RESET'),
			ui:'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE
		}]	
	}]
});