/**
 * @author nitin
 */
Ext.define('Academia.view.feeandpayment.reports.StudentFeeReportForm',{
	extend:'Ext.form.FormPanel',
	alias:'widget.studentfeereportform',
	autoScroll:false,
	frame:false,
	cls:'customSearchPanel',
	method:'POST',
	standardSubmit:false,
	defaults:{
				labelAlign:'top',
				width:226
	},
	plugins:"formlabelrequired",
	items:[{
		xtype:'fieldcontainer',
		width:'100%',
		layout:'hbox',
		defaults:{
			labelAlign:'top',
			width:226
		},
		items:[{
			xtype : 'customcombobox',
			name : 'intakeYear',
			itemId: 'intakeYear',
			fieldLabel : getFeeAndPaymentCommonTranslation('INTAKE_YEAR'),
			store: Ext.create('Academia.store.common.IntakeYearStore'),
			valueField : 'id',
			displayField : 'value',
			allowBlank : true,
			width:226

		},{
			xtype:'customcombobox',
			name:'feePlanType',
			itemId:'feePlanType',
			fieldLabel: getFeeAndPaymentCommonTranslation('FEE_PLAN_TYPE'),
			store:Ext.create('Academia.store.feeandpayment.FeePlanTypeStore'),
			valueField:'id',
			displayField:'value',
			typeAhead:true,
			forceSelection:true
		},
		]
	},{

		xtype:'fieldcontainer',
		width:'100%',
		layout:'hbox',
		defaults:{
			labelAlign:'top',
			width:226
		},
		items:[
		{
			xtype: 'customcombobox',
			name: 'student',
			itemId:'student',
			width:226,
			fieldLabel: getFeeAndPaymentCommonTranslation('STUDENT_CODE_NAME'),
			store:  Ext.create('Academia.store.feeandpayment.reports.StudentFeeReportStore'),
			valueField: 'id',
			displayField: 'valueCode',
			queryParam:'studentNameOrCode',
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			enableKeyEvents  : 'true',
			minChars:3,
			typeAhead:false,
			hideTrigger:false,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			triggerAction: '',
			//allowBlank : false,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{studentCode}/{studentName}' +
					'</div>';
				}
			}
		},{
       	 xtype: 'statusCombo',
            name: 'STATUS',
            itemId: 'statusComboItemId'
		}]
	
	},{
		xtype:'fieldset',
		title: getFeeAndPaymentCommonTranslation('MORE_FILTERS'),
		layout:'vbox',
		frame:true,	
		collapsible:true,
		collapsed:true,
		style:{marginTop: '33px!important'},
		width:'100%',
		items: [{
			xtype:'fieldcontainer',
			layout: 'hbox',
			width: '100%',
			defaults: {
				width: 226,
				labelAlign: 'top'
			},
			items:[{
				xtype: 'multiselectcombofield',
				name: 'programGroup',
				itemId:'programGroupItemId',
				fieldLabel: getCommonTranslation('PROGRAM_GROUP'),
				store:Ext.create('Academia.store.program.ProgramGroupStore'),
				displayField:'value',
				valueField:'id',
				forceSelection:true,
				width: 460,
				cls:'receiptHeaderMultiselect',
	  			
				typeAhead: true,
	            triggerCls: Ext.baseCSSPrefix + 'x-form-trigger',
	            enableKeyEvents: 'true',
	            hideTrigger: false,
	            listConfig: {
	                listeners: {
	                    beforeshow: function(picker) {
	                        picker.minWidth = picker.up('combobox').getSize().width;
	                    }
	                },
	                loadingText: getCommonTranslation('SEARCHING'),
	                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	                getInnerTpl: function() {
	                    return '<div class="search-item">' +
	                        '{code}' +
	                        '</div>';
	                }
	            }
			}, {
				xtype: 'customcombobox',
				name: 'programCategory',
				itemId:'programCategoryId',
				fieldLabel: getProgramandcourseTranslation('PROGRAM_CATEGORY'),
				store:Ext.create('Academia.store.program.ProgramCategoryStore'),
				displayField:'value',
				valueField:'id',
				forceSelection:true
			}]
		},{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			width:'100%',
			defaults: {
				width: 226,
				labelAlign: 'top',
				/*//xtype: 'numberfield',
				hideTrigger:true,
				mouseWheelEnabled:false,
				//allowDecimals:false,
				//allowExponential:false
				 */			},
				 items:[
					 {
						xtype:'customcombobox',
						name:'programId',
						itemId:'programId',
						fieldLabel: getCommonTranslation('PROGRAM_CODE_OR_NAME'),
						store:Ext.create('Academia.store.feeandpayment.reports.ProgramStudentByIntakeYearStore'),
						displayField:'valueCode',
						valueField:'id',
						typeAhead:true,
						forceSelection:true,
						hideTrigger:false,
						//queryMode: 'local',	    
						triggerAction: 'all',
						minChars:3,
						queryParam:'programName',
						emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
						listConfig: {
							listeners: {
								beforeshow: function(picker) {
									picker.minWidth = picker.up('combobox').getSize().width;
								}
							},
							loadingText: getCommonTranslation('SEARCHING'),
							emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
							getInnerTpl: function() {
								return '<div class="search-item">' +
								'{code} / {value}'  +
								'</div>';
							}
						}
					},{
						 xtype: 'customcombobox',
						 name: 'batchId',
						 disabled:true,
						 fieldLabel: getFeeAndPaymentCommonTranslation('BATCH'),
						 itemId:'batchId',
						 store: Ext.create('Academia.store.enquiry.AcademicBatchStore'),
						 valueField: 'id',
						 displayField: 'value',
						 typeAhead:true,
						 forceSelection:true
					 },{
						 xtype: 'customcombobox',
						 name: 'sectionId',
						 fieldLabel: getFeeAndPaymentCommonTranslation('SECTION'),
						 itemId:'sectionId',
						 store: Ext.create('Academia.store.completion.completionform.SectionByBatch'),
						 valueField: 'id',
						 displayField: 'value',
						 typeAhead:true,
						 disabled:true,
						 forceSelection:true
					 },{
						 xtype: 'customcombobox',
						 name: 'seatTypeId',
						 disabled:true,
						 itemId:'seatTypeId',
						 fieldLabel: getFeeAndPaymentCommonTranslation('SEAT_TYPE'),
						 store: Ext.create('Academia.store.feeandpayment.reports.ProgramBatchSeatIdByBatchStudentIdStore'),
						 valueField: 'id',
						 displayField: 'value',
						 typeAhead:true,
						 forceSelection:true
					 }]
		},
		{	
			xtype:'fieldcontainer',
			width: '100%',
			layout : 'hbox',
			defaults: {
				labelAlign:'top',
				width:226
			},
			items:[{
				 xtype: 'customcombobox',
				 name: 'feePlan',
				 itemId:'feePlan',
				 fieldLabel: getFeeAndPaymentCommonTranslation('FEE_PLAN_NAME'),
				 store: Ext.create('Academia.store.feeandpayment.reports.StudentFeePlanReportStore'),
				 valueField: 'id',
				 displayField: 'value',
				 typeAhead:true,
				 forceSelection:true,
				 disabled : true
			 },{
				xtype: 'customcombobox',
				name: 'period',
				itemId : 'periodId',
				fieldLabel: getCommonTranslation('PERIOD'),
				store : Ext.create('Academia.store.program.programDetails.programBatches.courseParameter.ProgramCoursePeriod'),
				displayField : 'value',
				valueField : 'id',
				//allowBlank: false,
				hidden:true,
				disabled : true
			}]	
		},
		{
			xtype:'fieldcontainer',
			width: '100%',
			layout : 'hbox',
			defaults: {
				labelAlign:'top',
				width:226
			},
			items:[
				/*{
		    	    xtype: 'customcombobox',
					name: 'voucherMode',
					itemId:'voucherMode',
					fieldLabel: getFeeAndPaymentCommonTranslation('VOUCHER_MODE'),
					store:'feeandpayment.payment.VoucherMode',
					valueField: 'id',
					displayField: 'value',
					typeAhead:true,
					forceSelection:true
		       },*/
				{
					xtype: 'customcombobox',
					name: 'paymentMode',
					itemId:'paymentMode',
					fieldLabel: getFeeAndPaymentCommonTranslation('PAYMENT_MODE'),
					store:Ext.create('Academia.store.feeandpayment.FeePaymentMode'),
					valueField: 'id',
					displayField: 'value',
					typeAhead:true,
					forceSelection:true 
				},{
					xtype: 'checkboxfield',
					width: 'auto',
					style:{
						marginTop:'25px'
					},
					labelAlign: 'right',
					itemId:'whetherStudentId',
					boxLabel: getCommonTranslation('ONLY_STUDENT'),
					name: 'whetherStudent',
					inputValue : true
				}]

		},
		/*{
		xtype:'fieldcontainer',
		layout:'hbox',
		width: '100%',
		defaults: {
			width: 226,
			labelAlign: 'top'
		},
		items:[
		{
			xtype : 'customcombobox',
			name : 'academicYear',
			itemId: 'academicYear',
			fieldLabel : getFeeAndPaymentCommonTranslation('ACADEMIC_YEAR'),
			store : 'program.programDetails.programBatches.PrimaryAcademicStore',
			valueField : 'id',
			displayField : 'yearName',
			allowBlank : true,
			width:226
		},{
			xtype : 'customcombobox',
			name : 'academyYearTenure',			
			itemId : 'academyYearTenure',			
			fieldLabel : getCommonTranslation('ACADEMY_YEAR_TENURE'),//Current Academic Year Tenure
			store : 'organization.academylocations.AcademicTenureStore',
			valueField : 'id',
			displayField : 'tenureName',
			editable:false,
			//emptyText:getCommonTranslation("SELECT_YEAR_TENURE"),//Select a academic year tenure
			//queryMode: 'local',
			triggerAction:'all',
			forceSelection :true,
			//disabled:true,
		}]},*/
		{
			xtype:'fieldcontainer',
			layout:'hbox',
			width: '100%',
			defaults: {
				width: 226,
				labelAlign: 'top'
			},
			items:[{
				xtype: 'datefield',
				name: 'fromdate',
				itemId:'fromdate',
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				},
				//--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
				vtype: 'daterange',
				endDateField: 'todate',
				editable:false,
				fieldLabel: getFeeAndPaymentCommonTranslation('FROM_DATE')
			},{
				xtype: 'datefield',
				name: 'todate',
				itemId:'todate',
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				},
				//--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
				vtype: 'daterange',
				startDateField: 'fromdate',
				editable:false,
				fieldLabel: getFeeAndPaymentCommonTranslation('TILL_DATE')
			}]}],
			listeners:{
				render: function(myfieldset){
					myfieldset.setMargin('-10px');
				}
			}
	},
	{
		xtype : 'fieldcontainer',
		width : 'auto',
		cls : 'windowBtnPos',
		items: [{
			xtype: 'button',
			text: getCommonTranslation('SEARCH'),
			itemId: 'searchBtn',
			buttonAlign: 'left',
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE,
			formBind : true
		},{
			xtype: 'button',
			text: getCommonTranslation('RESET'),
			itemId: 'resetBtn',
			ui: 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE   
		}]	
	}


	]
});
