/**
 * @author Nitin Gaikwad
 */
Ext.define('Academia.view.feeandpayment.reports.UserWiseCollectionReportGrid',{
		extend : 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
		alias : 'widget.userwisecollectionreportgrid',
		store : 'feeandpayment.reports.UserWiseCollectionReport',
		title : getCommonTranslation('USER_WISE_COLLECTION_REPORT'),
		cls:'centerAlignTitle',
		border : true,
		refreshStoreData:true,
		isGridConfigurable: true,
		enableColumnHide: false,
		viewConfig : {
			stripeRows : CONSTANTS.STRIPEROWS
		},
		features: [{
			ftype: 'summary',
			showSummaryRow:false 
		}],
		dockedItems : [{
			xtype : 'toolbar',
			dock : 'bottom',
			items : [ {
				xtype : 'custompagingtoolbar',
				plugins : [ 'pagesize' ],
				store : 'feeandpayment.reports.UserWiseCollectionReport',
				emptyMsg : getFeeAndPaymentCommonTranslation('EMPTY_MESSAGE'),
				displayInfo : true
			} ]
		}],
		tbar : ['->',{
			xtype : 'button',
			dock: 'right',
			itemId : 'exportUserWiseReportsId',
			tooltip : getCommonTranslation('EXPORTREPORTS'),
			text : getCommonTranslation('EXPORTREPORTS')
		}],
		initComponent : function() {
			var grid = this;
			grid.addExportToolBarItems(grid, false);
			this.callParent(arguments);
		},
		columns : [{
			header : getCommonTranslation('COLLECTED_BY_ID'),
			dataIndex : 'collectedById',
			flex : 1,
			summaryRenderer: function(value, metaData, record, row, col, store, gridView)  {
				if(store.data.items[0].data.conversionType == "AL" || store.data.items[0].data.conversionType == "ORG") {
					return getFeeAndPaymentCommonTranslation('Total (In ' + store.data.items[0].data.currencyName +')');
				}
				else {
					return getFeeAndPaymentCommonTranslation('TOTAL');
				}
			}
		},{
			header : getCommonTranslation('COLLECTED_BY_NAME'),
			dataIndex : 'collectedByName',
			flex : 1
		},{
			header : getCommonTranslation('RECEIPT_NO'),
			dataIndex : 'receiptNo',
			flex : 1,
			renderer:function(value){
				if(value){
					return  '<a href="#">'+value+'</a>';
				}
			}
		},{
			header : getCommonTranslation('RECEIPT_FORM'),
			dataIndex : 'userType',
			flex : 1
		},{
			header : getCommonTranslation('RECEIPT_USER_NAME'),
			dataIndex : 'printName',
			flex : 1
		},{
			header : getCommonTranslation('RECEIPT_USER_CODE'),
			dataIndex : 'code',
			flex : 1
		},{
			header : getCommonTranslation('PROGRAM'),
			dataIndex : 'programName',
			flex : 1
		},{
			header : getCommonTranslation('ADMISSION_CODE'),
			dataIndex : 'admissionCode',
			hidden : true,
			flex : 1
		},
		{
			header : getCommonTranslation('ADMISSION_DATE'),
			dataIndex : 'admissionDate',
			hidden : true,
			flex : 1,
			renderer : function(date) {
				return dateRender(date);
			}
		},{
			header : getCommonTranslation('RECEIPT_DATE'),
			dataIndex : 'receiptDate',
			flex : 1,
			renderer:function(date) {
				return dateRender(date);
			}
		},{
			header : getCommonTranslation('VOUCHER_MODE'),
			dataIndex : 'voucherMode',
			flex : 1
			
		},{
			header : getCommonTranslation('CURRENCY_EXCHANGE_RATE'),
			dataIndex : 'currencyExchangeRate',
			flex:1.0
		},{
			header : getCommonTranslation('RECEIPT_AMOUNT'),
			dataIndex : 'receiptAmount',
			flex : 1.8,
			summaryType: 'sum',
			//align: CONSTANTS.AMOUNT_COLUMN_ALIGN,
			renderer:function(value, metaData, record, row, col, store, gridView){
				if(!isNullOrEmpty(value)){
					return currencyRenderer(value,record.get("currencyId"));
				}
			},
			summaryRenderer: function (value, summaryData, dataIndex, rowIndex, colIndex, store, view) {
				if(store.data.items[0].data.conversionType == 'EX'){
					return currencyRenderer(value, store.data.items[0].data.currencyId);
				}
				else {
					return '';
				}
			}
		},{
			header : getCommonTranslation('CONVERTED_RECEIPT_AMOUNT'),
			dataIndex : 'convertedReceiptAmount',
			flex : 1.8,
			summaryType: 'sum',
			//align: CONSTANTS.AMOUNT_COLUMN_ALIGN,
			renderer:function(value, metaData, record, row, col, store, gridView){
				if(!isNullOrEmpty(value)){
					return currencyRenderer(value,record.get("baseCurrencyId"));
				}
			},
			summaryRenderer: function (value, summaryData, dataIndex, rowIndex, colIndex, store, view) {
				if(store.data.items[0].data.conversionType == 'AL' || store.data.items[0].data.conversionType == 'ORG'){
					return currencyRenderer(value,store.data.items[0].data.baseCurrencyId);
				}
				else {
					return '';
				}
			}
		},{
			header : getCommonTranslation('SETTLEMENT_DETAILS'),
			dataIndex : 'settledAmount',
			flex:1.8,
			header : getCommonTranslation('ADJUSTMENT_DETAILS'),
			dataIndex : 'adjustmentDetails',
			flex : 1,
			renderer : function(value){
				return  '<a href="#">'+"View"+'</a>';
			}
		
			
			
			
/*			summaryType: 'sum',
			align: CONSTANTS.AMOUNT_COLUMN_ALIGN,
			renderer:function(value, metaData, record, row, col, store, gridView){
				if(!isNullOrEmpty(value)){
					return currencyRenderer(value,record.get("currencyId"));
				}
			},
			summaryRenderer: function (value, summaryData, dataIndex, rowIndex, colIndex, store, view) {
				if(store.data.items[0].data.conversionType == 'EX'){
					return currencyRenderer(value, store.data.items[0].data.currencyId);
				}
				else {
					return '';
				}
			}*/
		},
		/*{
			header : getFeeAndPaymentCommonTranslation('CONVERTED_SETTLED_AMOUNT'),
			dataIndex : 'convertedSettledAmount',
			flex:1.8,
			summaryType: 'sum',
			align: CONSTANTS.AMOUNT_COLUMN_ALIGN,
			renderer:function(value, metaData, record, row, col, store, gridView){
				if(!isNullOrEmpty(value)){
					return currencyRenderer(value,record.get("baseCurrencyId"));
				}
			},
			summaryRenderer: function (value, summaryData, dataIndex, rowIndex, colIndex, store, view) {
				if(store.data.items[0].data.conversionType == 'AL' || store.data.items[0].data.conversionType == 'ORG'){
					return currencyRenderer(value,store.data.items[0].data.baseCurrencyId);
				}
				else {
					return '';
				}
			}
		},*/{
			header : getCommonTranslation('NARRATION'),
			hidden : true,
			dataIndex : 'narration',
			flex : 1
		}]

	});
