/**
 * priyanshi Sharma 
 */
Ext.define('Academia.view.feeandpayment.siblingranking.SiblingRankingFilter', {
    extend: 'Ext.form.Panel',
    alias: 'widget.siblingrankingfilter',
    autoScroll: true,
    frame: false,
    cls: 'customSearchPanel',
    method: 'POST',
    standardSubmit: false,
    plugins: "formlabelrequired",
    items: [{
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        items: [{
			xtype: 'multiselectcombofield',
			name: 'academyLocationId',
			itemId: 'academyLocationItemId',
			fieldLabel:getCommonTranslation('ACADEMY_LOCATION'),
			width: 463,
			store:Ext.create('Academia.store.common.AcademyLocationNameSeparated'),
			allowBlank : false,
			queryParam: "qry",
			valueField : 'id',
			forceSelection : true,
			displayField : 'value',
			hideTrigger:false,
			typeAhead:true,
			triggerAction: 'all',
			minChars:3,			
			emptyText: getCommonTranslation('ENTER_THREE_CHAR')			
        },{
        	xtype: 'customcombobox',
        	name: 'intakeYear',
        	itemId: 'intakeYearId',
        	fieldLabel: getCommonTranslation('INTAKE_YEAR'),
        	editable: false,
        	store: Ext.create('Academia.store.common.IntakeYearStore'),
        	valueField: 'id',
        	displayField: 'value',
        }]
    },{
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        items: [{
			xtype: 'customcombobox',
			name: 'admissionIdOrStudentId',
			itemId: 'admissionOrStudentItemId',
			width: 463,
			fieldLabel: getFeeAndPaymentCommonTranslation('ADMISSION_ID_STUDENT_ID'),
			valueField: 'id',
			displayField: 'valueCode',
			queryParam:'studentNameOrCode',
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			enableKeyEvents  : 'true',
			minChars:3,
			allowBlank: false,
			typeAhead:false,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			triggerAction: '',
			hideTrigger:false,
			listeners: {
				render: function(combo) {
                    var store = Ext.create('Academia.store.feeandpayment.managebill.Student');
                    combo.bindStore(store);
                }
			},
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{studentCode} / {studentName}' +
					'</div>';
				}
			}
        },{
        	xtype: 'customcombobox',
        	store:Ext.create('Academia.store.program.ProgramSortedSequenceWiseStore'),
        	itemId:'programId',
        	name:'programName',
        	fieldLabel: getCommonTranslation('PROGRAM_CODE_OR_NAME'),
        	valueField: 'id',
        	displayField: 'valueCode',
        	queryParam:'qry',
        	minChars:3,
        	allowBlank: true,
        	typeAhead:false,
        	emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
        	forceSelection:true,
        	listConfig: {
        		listeners: {
        			beforeshow: function(picker) {
        				picker.minWidth = picker.up('combobox').getSize().width;
        			}
        		},
        		loadingText: getCommonTranslation('SEARCHING'),
        		emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
        		getInnerTpl: function() {
        			return '<div class="search-item">' +
        			'{code} / {value}'+ 
        			'</div>';
        		}
        	}

        }]
    },{
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        items: [{
        	xtype: 'customcombobox',
        	name: 'intake',
        	itemId: 'intakeId',
        	fieldLabel: getCommonTranslation('INTAKE'),
        	editable: false,
        	//store:Ext.create('Academia.store.common.StatusComboStore'),
        	displayField: 'name',
        	valueField: 'value',
        },{
        	xtype: 'customcombobox',
        	name: 'stdClass',
        	itemId: 'stdClassId',
        	fieldLabel: getFeeAndPaymentCommonTranslation('CLASS'),
        	editable: false,
        	//store:Ext.create('Academia.store.common.StatusComboStore'),
        	displayField: 'name',
        	valueField: 'value',
        },{
        	xtype: 'customcombobox',
        	store:Ext.create('Academia.store.program.ProgramSortedSequenceWiseStore'),
        	itemId:'siblingId',
        	name:'siblingName',
        	fieldLabel: getCommonTranslation('SIBLING_ID_NAME'),
        	valueField: 'id',
        	displayField: 'valueCode',
        	queryParam:'qry',
        	minChars:3,
        	allowBlank: true,
        	typeAhead:false,
        	emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
        	forceSelection:true,
        	listConfig: {
        		listeners: {
        			beforeshow: function(picker) {
        				picker.minWidth = picker.up('combobox').getSize().width;
        			}
        		},
        		loadingText: getCommonTranslation('SEARCHING'),
        		emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
        		getInnerTpl: function() {
        			return '<div class="search-item">' +
        			'{code} / {value}'+ 
        			'</div>';
        		}
        	}

        }]
    },{
        xtype: 'fieldcontainer',
        width: 'auto',
        cls: 'windowBtnPos',
        style: {
            marginLeft: '-2px'
        },
        items: [{
            xtype: 'button',
            text: getCommonTranslation('SEARCH'),
            itemId: 'searchBtnItemId',
            buttonAlign: 'left',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            formBind: true
        }, {
            xtype: 'button',
            text: getCommonTranslation('RESET'),
            itemId: 'resetBtnItemId',
            buttonAlign: 'left',
            ui: 'CustomBtnCancel',
            scale: CONSTANTS.BUTTONSIZE
        }]
    }]
});
