/**
 * @author Rajkumar.Patidar
 */

Ext.define('Academia.view.feeandpayment.voucherMode.VoucherModeFilters',{
	extend: 'Ext.form.FormPanel',
	alias: 'widget.vouchermodefilters',
	autoScroll: false,
	frame: false,
	method: 'POST',
	standardSubmit: false,
	defaults: {
		width: 226,
		labelAlign: 'top'
	},
	plugins : "formlabelrequired",
	cls:'customSearchPanel',
	items: [{

		xtype:'fieldcontainer',
		width: '100%',
		layout : 'hbox',
		defaults: {
			labelAlign:'top',
			width:226
		},
		items:[{
				xtype: 'multiselectcombofield',
				name: 'multiBrandCampusName',
				itemId: 'multiBrandCampusItemId',
				fieldLabel: getCommonTranslation('BRAND_CAMPUS'),
				valueField: 'id',
				displayField: 'value',
				store: 'user.UserAcademyLocationStore',
				width: 698,
				cls:'multiBrandCampusCls',
				typeAhead: true,
				forceSelection: true,
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{code}' +
						'</div>';
					}
				}
			}]
	
	},{
		xtype:'fieldcontainer',
		width: '100%',
		layout : 'hbox',
		defaults: {
			labelAlign:'top',
			width:226
		},
		items:[{
			xtype: 'customcombobox',
			name: 'organizationUnit',
			itemId:'organizationUnit',
			fieldLabel: getFeeAndPaymentCommonTranslation('IAU'),
			store: 'feeandpayment.accountingConfigurationMapping.IAUAcademyLocationWise',
			valueField: 'id',
			displayField: 'value',
			typeAhead:true,
			forceSelection:true
		},{
			xtype: 'customcombobox',
			name: 'voucherType',
			itemId:'voucherType',
			fieldLabel: getFeeAndPaymentCommonTranslation('VOUCHER_TYPE'),
			store: 'feeandpayment.voucherMode.VoucherType',
			valueField: 'id',
			displayField: 'value',
			typeAhead:true,
			forceSelection:true
		},{
			xtype: 'customcombobox',
			name: 'voucherLinkType',
			itemId:'voucherLinkType',
			fieldLabel: getFeeAndPaymentCommonTranslation('VOUCHER_LINK_TYPE'),
			store:'feeandpayment.voucherMode.VoucherLinkType',
			valueField: 'id',
			displayField: 'value',
			typeAhead:true,
			forceSelection:true
		}]
	},{
		xtype:'fieldcontainer',
		width: '100%',
		layout : 'hbox',
		itemId:'billDetailId',
		hidden:true,
		defaults: {
			labelAlign:'top',
			width:226,
			xtype: 'customcombobox'
		},
		items:[{
			name: 'billType',
			itemId:'billType',
			fieldLabel: getFeeAndPaymentCommonTranslation('BILL_TYPE'),
			store:'feeandpayment.managebill.BillType',
			valueField: 'id',
			displayField: 'value',
			typeAhead:true,
			forceSelection:true
		},{
			name: 'billNo',
			width:460,
			itemId:'billNo',
			fieldLabel: getFeeAndPaymentCommonTranslation('BILL_NO'),
			store: 'feeandpayment.voucherMode.VoucherBillNo',
			valueField: 'id',
			displayField: 'value',
			queryParam:'billNo',
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			enableKeyEvents  : 'true',
			minChars:3,
			forceSelection:true,
			typeAhead:false,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			triggerAction: '',
			hideTrigger:false,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
		}]
	},{
		xtype:'fieldcontainer',
		width: '100%',
		layout : 'hbox',
		itemId:'receiptDetailId',
		defaults: {
			labelAlign:'top',
			width:226,
			xtype: 'customcombobox'
		},
		items:[{
			name: 'receiptType',
			itemId:'receiptType',
			fieldLabel: getFeeAndPaymentCommonTranslation('RECEIPT_TYPE'),
			store:'feeandpayment.voucherMode.VoucherReceiptType',
			valueField: 'id',
			displayField: 'value',
			typeAhead:true,
			forceSelection:true
		},{

			name: 'receiptNo',
			width:460,
			itemId:'receiptNo',
			fieldLabel: getFeeAndPaymentCommonTranslation('RECEIPT_NO'),
			store: 'feeandpayment.voucherMode.VoucherReceiptNo',
			valueField: 'id',
			displayField: 'value',
			queryParam:'receiptNo',
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			enableKeyEvents  : 'true',
			minChars:3,
			forceSelection:true,
			typeAhead:false,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			triggerAction: '',
			hideTrigger:false,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
		}]
	},{
		xtype:'fieldcontainer',
		width: '100%',
		itemId:'paymentDetailId',
		hidden:true,
		layout : 'hbox',
		defaults: {
			labelAlign:'top',
			width:226,
			xtype: 'customcombobox'
		},
		items:[{
			name: 'paymentType',
			itemId:'paymentType',
			fieldLabel: getFeeAndPaymentCommonTranslation('PAYMENT_TYPE'),
			store:'feeandpayment.voucherMode.VoucherPaymentType',
			valueField: 'id',
			displayField: 'value',
			typeAhead:true,
			forceSelection:true
		},{
			name: 'paymentNo',
			itemId:'paymentNo',
			width:460,
			fieldLabel: getFeeAndPaymentCommonTranslation('PAYMENT_NO'),
			store: 'feeandpayment.voucherMode.VoucherPaymentNo',
			valueField: 'id',
			displayField: 'value',
			queryParam:'paymentNo',
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			enableKeyEvents  : 'true',
			minChars:3,
			forceSelection:true,
			typeAhead:false,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			triggerAction: '',
			hideTrigger:false,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
		}]
	},{
		xtype:'fieldcontainer',
		layout:'hbox',
		width: '100%',
		defaults: {
			labelAlign: 'top',
			width: 226
		},
		items:[{
			xtype: 'customcombobox',
			name: 'voucherID',
			itemId:'voucherId',
			fieldLabel: getFeeAndPaymentCommonTranslation('VOUCHER_ID'),
			store: 'feeandpayment.voucherMode.VoucherID',
			valueField: 'id',
			displayField: 'value',
			queryParam:'voucherId',
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			enableKeyEvents  : 'true',
			minChars:3,
			forceSelection:true,
			typeAhead:false,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			triggerAction: '',
			hideTrigger:false,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
		},{
			xtype: 'customcombobox',
			name: 'voucherStatus',
			itemId:'voucherStatus',
			fieldLabel: getFeeAndPaymentCommonTranslation('VOUCHER_STATUS'),
			store:'feeandpayment.voucherMode.VoucherStatus',
			valueField: 'id',
			displayField: 'value',
			typeAhead:true,
			forceSelection:true 
		},{
			xtype: 'customcombobox',
			name: 'voucherFlag',
			itemId:'voucherFlag',
			fieldLabel: getFeeAndPaymentCommonTranslation('VOUCHER_FLAG'),
			store:'feeandpayment.voucherMode.VoucherFlag',
			valueField: 'id',
			displayField: 'value',
			typeAhead:true,
			forceSelection:true
		}]
	},{ 
		xtype:'fieldcontainer',
		layout:'hbox',
		width:'100%',
		defaults: {
			labelAlign: 'top',
			width:226
		},
		items:[{
			xtype: 'datefield',
			name: 'dateFrom',
			itemId:'dateFrom',
			listeners: {
				render: function(field) {
					return dateFormatRender(field);
				}
			},
			//--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
			editable:false,
			fieldLabel: getFeeAndPaymentCommonTranslation('VOUCHER_DATE_FROM')
		},{
			xtype: 'datefield',
			name: 'dateTill',
			itemId:'dateTill',
			listeners: {
				render: function(field) {
					return dateFormatRender(field);
				}
			},
			//--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
			editable:false,
			fieldLabel: getFeeAndPaymentCommonTranslation('VOUCHER_DATE_TILL')
		}]
	},{
		xtype: 'fieldcontainer',
		width: 'auto',
		items: [{
			xtype: 'button',
			text: getCommonTranslation('SEARCH'),
			itemId: 'searchBtn',
			buttonAlign: 'left',
			ui: 'CustomBtnSubmit',
			margin:'0 0 0 0',
			scale: CONSTANTS.BUTTONSIZE               
		},{
			xtype: 'button',
			text: getCommonTranslation('RESET'),
			itemId: 'resetBtn',
			ui: 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE   
		}]	
	}]
});