/**
 * @author Amit Gupta
 */

Ext.define('Academia.view.filemanagement.CurrentFileLocationWindow', {
	extend: 'Ext.window.Window',
	alias: 'widget.currentfilelocationwindow',
	modal : true,
	resizable:true,
	autoScroll: true,
	height: '60%',
	width: '60%',
	title:getFileManagementTranslation('CURRENT_FILE_LOCATION'),
	items: [{
		xtype:'form',
		items:[{
			xtype:'fieldcontainer',
			layout:'hbox',
			defaults: {
				width: 226,
				labelAlign: 'top'
			},
			items:[{
				xtype:'displayfield',
				name:'fileNumber',
				itemId:'fileNumber',
				fieldLabel: getServiceRequestTranslation('FILE_NO'),
			},{
				xtype:'displayfield',
				name:'assignmentDate',
				itemId:'assignmentDate',
				fieldLabel:getFileManagementTranslation('DATE_OF_ASSIGNMENT')
			},{
				xtype:'displayfield',
				name:'dueDate',
				itemId:'dueDate',
				fieldLabel:getFileManagementTranslation('DUE_DATE')
			}]
		}]
	},{
		xtype: 'grid',
		itemId : 'periodGridWin',
		store:'filemanagement.CurrentFileLocationStore',
		frame: false,
		border:true,
		autoScroll: true,
		viewConfig : {
			stripeRows : CONSTANTS.STRIPEROWS
		},
		features: [{
			ftype: 'summary',
			showSummaryRow: CONSTANTS.SHOW_SUMMARY_ROW 
		}],
		dockedItems : [{
			xtype : 'toolbar',
			dock : 'bottom',
			items : [{
				xtype: 'custompagingtoolbar',
				plugins:['pagesize'],
				store : 'filemanagement.CurrentFileLocationStore',
				emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
				displayInfo : true
			}]
		}],
		columns: [{
			header:  getFileManagementTranslation('ASSIGNED_TO'),
			dataIndex: 'assignedUserName',
			flex:.1,
			sortable:true
		},{
			header:  getServiceRequestTranslation('FILE_STATUS'),
			dataIndex: 'fileStatus',
			flex:.1,
			sortable:true,
			renderer:function(value,meta,record){
				if(!isNullOrEmpty(value)) {
					return getCommonTranslation(value);
				} else {
					return value;
				}
			}
		},{
			header:  getFileManagementTranslation('ACKNOWLEDGMENT_STATUS'),
			dataIndex: 'acknowledgement',
			flex:.1,
			sortable:true,
			renderer:function(value,meta,record){
				if(!isNullOrEmpty(value)) {
					return getCommonTranslation(value);
				} else {
					return value;
				}
			}
		},{
			header:  getFileManagementTranslation('RETURN_REASON'),
			dataIndex: 'returnReason',
			flex:.1,
			sortable:true
		}] 	
	}]
});
